/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.widgets.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.netxms.base.Glob;
import org.netxms.base.InetAddressEx;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.ServiceCheck;
import org.netxms.client.objects.Subnet;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ObjectFilter
extends ViewerFilter {
    private static final int NONE = 0;
    private static final int NAME = 1;
    private static final int COMMENTS = 2;
    private static final int IP_ADDRESS = 3;
    private static final int OBJECT_ID = 4;
    private String filterString = null;
    private boolean hideUnmanaged = false;
    private boolean hideTemplateChecks = false;
    private Map<Long, AbstractObject> objectList = null;
    private AbstractObject lastMatch = null;
    private AbstractObject[] sourceObjects = null;
    private long[] rootObjects = null;
    private Set<Integer> classFilter = null;
    private boolean usePatternMatching = false;
    private int mode = 1;

    public ObjectFilter(long[] rootObjects, AbstractObject[] sourceObjects, Set<Integer> classFilter) {
        if (rootObjects != null) {
            this.rootObjects = new long[rootObjects.length];
            System.arraycopy(rootObjects, 0, this.rootObjects, 0, rootObjects.length);
        }
        this.sourceObjects = sourceObjects;
        this.classFilter = classFilter;
    }

    private boolean matchFilterString(AbstractObject object) {
        if (this.mode == 0 || this.filterString == null) {
            return true;
        }
        switch (this.mode) {
            case 1: {
                return this.usePatternMatching ? Glob.matchIgnoreCase((String)this.filterString, (String)object.getObjectName()) : object.getObjectName().toLowerCase().contains(this.filterString);
            }
            case 3: {
                if (object instanceof AbstractNode) {
                    return ((AbstractNode)object).getPrimaryIP().getHostAddress().startsWith(this.filterString);
                }
                if (object instanceof Subnet) {
                    return ((Subnet)object).getSubnetAddress().getHostAddress().startsWith(this.filterString);
                }
                if (object instanceof Interface) {
                    for (InetAddressEx a : ((Interface)object).getIpAddressList()) {
                        if (!a.address.getHostAddress().startsWith(this.filterString)) continue;
                        return true;
                    }
                    return false;
                }
                if (object instanceof AccessPoint) {
                    return ((AccessPoint)object).getIpAddress().getHostAddress().startsWith(this.filterString);
                }
                return false;
            }
            case 4: {
                if (object instanceof AbstractObject) {
                    long objectID = object.getObjectId();
                    return String.valueOf(objectID).startsWith(this.filterString);
                }
                return false;
            }
            case 2: {
                return object.getComments().toLowerCase().contains(this.filterString);
            }
        }
        return false;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.classFilter != null && !this.classFilter.contains(((AbstractObject)element).getObjectClass())) {
            return false;
        }
        if (this.hideUnmanaged && ((AbstractObject)element).getStatus() == ObjectStatus.UNMANAGED) {
            return false;
        }
        if (this.hideTemplateChecks && element instanceof ServiceCheck && ((ServiceCheck)element).isTemplate()) {
            return false;
        }
        if (this.objectList == null) {
            return true;
        }
        boolean pass = this.objectList.containsKey(((AbstractObject)element).getObjectId());
        if (!pass && ((AbstractObject)element).hasChildren()) {
            for (AbstractObject obj : this.objectList.values()) {
                if (!obj.isChildOf(((AbstractObject)element).getObjectId())) continue;
                pass = true;
                break;
            }
        }
        return pass;
    }

    public void setFilterString(String filterString) {
        boolean fullSearch = true;
        if (filterString != null && !filterString.isEmpty()) {
            if (filterString.charAt(0) == '/') {
                this.mode = 2;
                this.filterString = filterString.substring(1);
            } else if (filterString.charAt(0) == '>') {
                this.mode = 3;
                this.filterString = filterString.substring(1);
            } else if (filterString.charAt(0) == '#') {
                this.mode = 4;
                this.filterString = filterString.substring(1);
            } else {
                this.mode = 1;
                boolean bl = this.usePatternMatching = filterString.contains("*") || filterString.contains("?");
                if (this.usePatternMatching) {
                    this.filterString = String.valueOf(filterString.toLowerCase()) + "*";
                } else {
                    String newFilterString = filterString.toLowerCase();
                    if (this.filterString != null && newFilterString.startsWith(this.filterString)) {
                        fullSearch = false;
                    }
                    this.filterString = newFilterString;
                }
            }
        } else {
            this.filterString = null;
            this.usePatternMatching = false;
            this.mode = 0;
        }
        this.updateObjectList(fullSearch);
    }

    private void updateObjectList(boolean doFullSearch) {
        if (this.filterString != null) {
            if (doFullSearch) {
                AbstractObject[] fullList = this.sourceObjects != null ? this.sourceObjects : ConsoleSharedData.getSession().getAllObjects();
                this.objectList = new HashMap<Long, AbstractObject>();
                int i = 0;
                while (i < fullList.length) {
                    if (this.matchFilterString(fullList[i]) && (this.rootObjects == null || fullList[i].isChildOf(this.rootObjects))) {
                        this.objectList.put(fullList[i].getObjectId(), fullList[i]);
                        this.lastMatch = fullList[i];
                    }
                    ++i;
                }
            } else {
                this.lastMatch = null;
                Iterator<AbstractObject> it = this.objectList.values().iterator();
                while (it.hasNext()) {
                    AbstractObject obj = it.next();
                    if (!this.matchFilterString(obj)) {
                        it.remove();
                        continue;
                    }
                    this.lastMatch = obj;
                }
            }
        } else {
            this.objectList = null;
            this.lastMatch = null;
        }
    }

    public final AbstractObject getLastMatch() {
        return this.lastMatch;
    }

    public AbstractObject getParent(AbstractObject childObject) {
        AbstractObject[] parents;
        AbstractObject[] abstractObjectArray = parents = childObject.getParentsAsArray();
        int n = parents.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractObject object = abstractObjectArray[n2];
            if (object != null && (this.rootObjects == null || object.isChildOf(this.rootObjects))) {
                return object;
            }
            ++n2;
        }
        return null;
    }

    public boolean isHideUnmanaged() {
        return this.hideUnmanaged;
    }

    public void setHideUnmanaged(boolean hideUnmanaged) {
        this.hideUnmanaged = hideUnmanaged;
    }

    public boolean isHideTemplateChecks() {
        return this.hideTemplateChecks;
    }

    public void setHideTemplateChecks(boolean hideTemplateChecks) {
        this.hideTemplateChecks = hideTemplateChecks;
    }

    public void setRootObjects(long[] rootObjects) {
        if (rootObjects != null) {
            this.rootObjects = new long[rootObjects.length];
            System.arraycopy(rootObjects, 0, this.rootObjects, 0, rootObjects.length);
        } else {
            this.rootObjects = null;
        }
    }
}

