/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Interface;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class InterfacesTabFilter
extends ViewerFilter {
    private NXCSession session = ConsoleSharedData.getSession();
    private String filterString = null;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.filterString == null || this.filterString.isEmpty()) {
            return true;
        }
        Interface interf = (Interface)element;
        if (this.containsOId(interf)) {
            return true;
        }
        if (this.containsName(interf)) {
            return true;
        }
        if (this.containsAlias(interf)) {
            return true;
        }
        if (this.containsIfType(interf)) {
            return true;
        }
        if (this.containsIfIndex(interf)) {
            return true;
        }
        if (this.containsIfTypeName(interf)) {
            return true;
        }
        if (this.containsSlot(interf)) {
            return true;
        }
        if (this.containsPort(interf)) {
            return true;
        }
        if (this.containsMtu(interf)) {
            return true;
        }
        if (this.containsSpeed(interf)) {
            return true;
        }
        if (this.containsDescription(interf)) {
            return true;
        }
        if (this.containsMac(interf)) {
            return true;
        }
        if (this.containsIp(interf)) {
            return true;
        }
        if (this.containsPeerNode(interf)) {
            return true;
        }
        if (this.containsPeerMac(interf)) {
            return true;
        }
        if (this.containsPeerIp(interf)) {
            return true;
        }
        if (this.containsPeerDiscoveryProtocol(interf)) {
            return true;
        }
        if (this.containsAdminState(interf)) {
            return true;
        }
        if (this.containsOperState(interf)) {
            return true;
        }
        if (this.containsExpState(interf)) {
            return true;
        }
        if (this.containsStatus(interf)) {
            return true;
        }
        if (this.containsDot1xPaeState(interf)) {
            return true;
        }
        return this.containsDot1xBackendState(interf);
    }

    public boolean containsOId(Interface interf) {
        return Long.toString(interf.getObjectId()).contains(this.filterString);
    }

    public boolean containsName(Interface interf) {
        return interf.getObjectName().toLowerCase().contains(this.filterString);
    }

    public boolean containsAlias(Interface interf) {
        return interf.getAlias().toLowerCase().contains(this.filterString);
    }

    public boolean containsIfType(Interface interf) {
        return Integer.toString(interf.getIfType()).toLowerCase().contains(this.filterString);
    }

    public boolean containsIfTypeName(Interface interf) {
        return interf.getIfTypeName().toLowerCase().contains(this.filterString);
    }

    public boolean containsIfIndex(Interface interf) {
        return Integer.toString(interf.getIfIndex()).toLowerCase().contains(this.filterString);
    }

    public boolean containsSlot(Interface interf) {
        return Integer.toString(interf.getSlot()).toLowerCase().contains(this.filterString);
    }

    public boolean containsPort(Interface interf) {
        return Integer.toString(interf.getPort()).toLowerCase().contains(this.filterString);
    }

    public boolean containsMtu(Interface interf) {
        return Integer.toString(interf.getMtu()).toLowerCase().contains(this.filterString);
    }

    public boolean containsSpeed(Interface interf) {
        return Long.toString(interf.getSpeed()).toLowerCase().contains(this.filterString);
    }

    public boolean containsDescription(Interface interf) {
        return interf.getDescription().toLowerCase().contains(this.filterString);
    }

    public boolean containsMac(Interface interf) {
        return interf.getMacAddress().toString().toLowerCase().contains(this.filterString);
    }

    public boolean containsIp(Interface interf) {
        return interf.getIpAddressListAsString().toLowerCase().contains(this.filterString);
    }

    public boolean containsPeerNode(Interface interf) {
        return Long.toString(interf.getPeerNodeId()).toLowerCase().contains(this.filterString);
    }

    public boolean containsPeerMac(Interface interf) {
        Interface peer = (Interface)this.session.findObjectById(interf.getPeerInterfaceId(), Interface.class);
        if (peer == null) {
            return false;
        }
        return peer.getMacAddress().toString().toLowerCase().contains(this.filterString);
    }

    public boolean containsPeerIp(Interface interf) {
        Interface peer = (Interface)this.session.findObjectById(interf.getPeerInterfaceId(), Interface.class);
        if (peer == null) {
            return false;
        }
        return peer.getIpAddressListAsString().toLowerCase().contains(this.filterString);
    }

    public boolean containsPeerDiscoveryProtocol(Interface interf) {
        return interf.getPeerDiscoveryProtocol().toString().toLowerCase().contains(this.filterString);
    }

    public boolean containsAdminState(Interface interf) {
        return interf.getAdminStateAsText().toLowerCase().contains(this.filterString);
    }

    public boolean containsOperState(Interface interf) {
        return interf.getOperStateAsText().toLowerCase().contains(this.filterString);
    }

    public boolean containsExpState(Interface interf) {
        return Integer.toString(interf.getExpectedState()).toLowerCase().contains(this.filterString);
    }

    public boolean containsStatus(Interface interf) {
        return interf.getStatus().toString().toLowerCase().contains(this.filterString);
    }

    public boolean containsDot1xPaeState(Interface interf) {
        return interf.getDot1xPaeStateAsText().toLowerCase().contains(this.filterString);
    }

    public boolean containsDot1xBackendState(Interface interf) {
        return interf.getDot1xBackendStateAsText().toLowerCase().contains(this.filterString);
    }

    public String getFilterString() {
        return this.filterString;
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString.toLowerCase();
    }
}

