/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs.helpers;

import java.net.InetAddress;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.Rack;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ComparatorHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class NodeListComparator
extends ViewerComparator {
    private NXCSession session = ConsoleSharedData.getSession();

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result;
        AbstractNode node1 = (AbstractNode)e1;
        AbstractNode node2 = (AbstractNode)e2;
        int column = (Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID");
        switch (column) {
            case 6: {
                result = node1.getSystemDescription().compareToIgnoreCase(node2.getSystemDescription());
                break;
            }
            case 4: {
                result = node1.getPlatformName().compareToIgnoreCase(node2.getPlatformName());
                break;
            }
            case 5: {
                result = node1.getAgentVersion().compareToIgnoreCase(node2.getAgentVersion());
                break;
            }
            case 0: {
                result = Long.signum(node1.getObjectId() - node2.getObjectId());
                break;
            }
            case 1: {
                result = node1.getObjectName().compareToIgnoreCase(node2.getObjectName());
                break;
            }
            case 7: {
                result = node1.getStatus().compareTo((Enum)node2.getStatus());
                break;
            }
            case 2: {
                result = ComparatorHelper.compareInetAddresses((InetAddress)node1.getPrimaryIP(), (InetAddress)node2.getPrimaryIP());
                break;
            }
            case 3: {
                Rack rack1 = (Rack)this.session.findObjectById(node1.getRackId(), Rack.class);
                Rack rack2 = (Rack)this.session.findObjectById(node2.getRackId(), Rack.class);
                if (rack1 != null && rack2 != null) {
                    result = rack1.getObjectName().compareToIgnoreCase(rack2.getObjectName());
                    if (result != 0) break;
                    result = node1.getRackPosition() - node2.getRackPosition();
                    break;
                }
                result = Long.signum(node1.getRackId() - node2.getRackId());
                break;
            }
            default: {
                result = 0;
            }
        }
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }
}

