/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class Communication
extends PropertyPage {
    private AbstractNode node;
    private LabeledText primaryName;
    private Button agentIsRemote;
    private boolean primaryNameChanged = false;

    protected Control createContents(Composite parent) {
        this.node = (AbstractNode)this.getElement().getAdapter(AbstractNode.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout dialogLayout = new GridLayout();
        dialogLayout.marginWidth = 0;
        dialogLayout.marginHeight = 0;
        dialogArea.setLayout((Layout)dialogLayout);
        this.primaryName = new LabeledText(dialogArea, 0);
        Messages.get();
        this.primaryName.setLabel(Messages.Communication_PrimaryHostName);
        this.primaryName.setText(this.node.getPrimaryName());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.primaryName.setLayoutData((Object)gd);
        this.primaryName.getTextControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Communication.this.primaryNameChanged = true;
            }
        });
        this.agentIsRemote = new Button(dialogArea, 32);
        Messages.get();
        this.agentIsRemote.setText(Messages.Communication_RemoteAgent);
        this.agentIsRemote.setSelection((this.node.getFlags() & 0x80) != 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.agentIsRemote.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected boolean applyChanges(final boolean isApply) {
        final NXCObjectModificationData md = new NXCObjectModificationData(this.node.getObjectId());
        if (this.primaryNameChanged) {
            String hostName = this.primaryName.getText().trim();
            if (!hostName.matches("^(([A-Za-z0-9\\-]+\\.)*[A-Za-z0-9\\-]+|[A-Fa-f0-9:]+)$")) {
                Shell shell = this.getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openWarning((Shell)shell, (String)Messages.Communication_Warning, (String)String.format(Messages.Communication_WarningInvalidHostname, hostName));
                return false;
            }
            md.setPrimaryName(hostName);
        }
        if (isApply) {
            this.setValid(false);
        }
        int flags = this.node.getFlags();
        flags = this.agentIsRemote.getSelection() ? (flags |= 0x80) : (flags &= 0xFFFFFF7F);
        md.setObjectFlags(flags);
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(String.format(Messages.Communication_JobName, this.node.getObjectName()), null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.Communication_JobError;
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            Communication.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.agentIsRemote.setSelection(false);
    }
}

