/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.ScheduledTask;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.widgets.LabeledText;
import org.netxms.ui.eclipse.widgets.ScheduleSelector;

public class ScheduledTaskEditor
extends Dialog {
    private ScheduledTask scheduledTask;
    private List<String> scheduleTypeList;
    private LabeledText textParameters;
    private Combo scheduleType;
    private ScheduleSelector scheduleSelector;
    private ObjectSelector selector;

    public ScheduledTaskEditor(Shell shell, ScheduledTask task, List<String> scheduleType) {
        super(shell);
        this.scheduledTask = task != null ? task : new ScheduledTask();
        this.scheduleTypeList = scheduleType;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Edit Scheduled Task");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        this.scheduleType = new Combo(dialogArea, 8);
        for (String type : this.scheduleTypeList) {
            this.scheduleType.add(type);
        }
        int taskId = this.scheduleTypeList.indexOf(this.scheduledTask.getScheduledTaskId());
        this.scheduleType.select(taskId == -1 ? 0 : taskId);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.scheduleType.setLayoutData((Object)gd);
        this.selector = new ObjectSelector(dialogArea, 0, true);
        this.selector.setLabel("Select execution object");
        this.selector.setObjectClass(AbstractObject.class);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.selector.setLayoutData((Object)gd);
        if (this.scheduledTask.getObjectId() != 0L) {
            this.selector.setObjectId(this.scheduledTask.getObjectId());
        }
        this.textParameters = new LabeledText(dialogArea, 0);
        this.textParameters.setLabel("Parameters");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.textParameters.setLayoutData((Object)gd);
        this.textParameters.setText(this.scheduledTask.getParameters());
        if ((this.scheduledTask.getFlags() & 8) != 0) {
            this.scheduleType.add(this.scheduledTask.getScheduledTaskId());
            this.scheduleType.select(this.scheduleTypeList.size());
            this.scheduleType.setEnabled(false);
            this.selector.setEnabled(false);
            this.textParameters.setEnabled(false);
        }
        this.scheduleSelector = new ScheduleSelector(dialogArea, 0);
        this.scheduleSelector.setSchedule(this.scheduledTask);
        return dialogArea;
    }

    protected void okPressed() {
        ScheduledTask task = this.scheduleSelector.getSchedule();
        this.scheduledTask.setSchedule(task.getSchedule());
        this.scheduledTask.setExecutionTime(task.getExecutionTime());
        if ((this.scheduledTask.getFlags() & 8) == 0) {
            this.scheduledTask.setScheduledTaskId(this.scheduleTypeList.get(this.scheduleType.getSelectionIndex()));
            this.scheduledTask.setParameters(this.textParameters.getText());
            this.scheduledTask.setObjectId(this.selector.getObjectId());
        }
        super.okPressed();
    }

    public ScheduledTask getScheduledTask() {
        return this.scheduledTask;
    }
}

