/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.views;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.Script;
import org.netxms.client.datacollection.DciSummaryTableDescriptor;
import org.netxms.client.events.EventProcessingPolicyRule;
import org.netxms.client.events.EventTemplate;
import org.netxms.client.market.Repository;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Template;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.client.snmp.SnmpTrap;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.epp.dialogs.RuleSelectionDialog;
import org.netxms.ui.eclipse.eventmanager.dialogs.EventSelectionDialog;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.nxsl.dialogs.SelectScriptDialog;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.serverconfig.Activator;
import org.netxms.ui.eclipse.serverconfig.Messages;
import org.netxms.ui.eclipse.serverconfig.dialogs.ObjectToolSelectionDialog;
import org.netxms.ui.eclipse.serverconfig.dialogs.RepositorySelectionDialog;
import org.netxms.ui.eclipse.serverconfig.dialogs.SelectSnmpTrapDialog;
import org.netxms.ui.eclipse.serverconfig.dialogs.SummaryTableSelectionDialog;
import org.netxms.ui.eclipse.serverconfig.dialogs.helpers.TrapListLabelProvider;
import org.netxms.ui.eclipse.serverconfig.views.helpers.RuleComparator;
import org.netxms.ui.eclipse.serverconfig.views.helpers.RuleLabelProvider;
import org.netxms.ui.eclipse.serverconfig.views.helpers.ScriptComparator;
import org.netxms.ui.eclipse.serverconfig.views.helpers.ScriptLabelProvider;
import org.netxms.ui.eclipse.serverconfig.views.helpers.SummaryTablesComparator;
import org.netxms.ui.eclipse.serverconfig.views.helpers.SummaryTablesLabelProvider;
import org.netxms.ui.eclipse.serverconfig.views.helpers.ToolComparator;
import org.netxms.ui.eclipse.serverconfig.views.helpers.ToolLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ObjectLabelComparator;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class ExportFileBuilder
extends ViewPart
implements ISaveablePart {
    public static final String ID = "org.netxms.ui.eclipse.serverconfig.views.ExportFileBuilder";
    private NXCSession session = ConsoleSharedData.getSession();
    private FormToolkit toolkit;
    private ScrolledForm form;
    private LabeledText description;
    private TableViewer templateViewer;
    private TableViewer eventViewer;
    private TableViewer trapViewer;
    private TableViewer ruleViewer;
    private TableViewer scriptViewer;
    private TableViewer toolsViewer;
    private TableViewer summaryTableViewer;
    private Action actionSave;
    private Action actionPublish;
    private Map<Long, EventTemplate> events = new HashMap<Long, EventTemplate>();
    private Map<Long, Template> templates = new HashMap<Long, Template>();
    private Map<Long, SnmpTrap> traps = new HashMap<Long, SnmpTrap>();
    private Map<UUID, EventProcessingPolicyRule> rules = new HashMap<UUID, EventProcessingPolicyRule>();
    private Map<Long, Script> scripts = new HashMap<Long, Script>();
    private Map<Long, ObjectTool> tools = new HashMap<Long, ObjectTool>();
    private Map<Integer, DciSummaryTableDescriptor> summaryTables = new HashMap<Integer, DciSummaryTableDescriptor>();
    private boolean modified = false;
    private List<SnmpTrap> snmpTrapCache = null;
    private List<EventProcessingPolicyRule> rulesCache = null;
    private String exportFileName = null;

    public void createPartControl(Composite parent) {
        try {
            Platform.getAdapterManager().loadAdapter((Object)new EventTemplate(0L), "org.eclipse.ui.model.IWorkbenchAdapter");
            Platform.getAdapterManager().loadAdapter((Object)this.session.getTopLevelObjects()[0], "org.eclipse.ui.model.IWorkbenchAdapter");
        }
        catch (Exception exception) {}
        this.toolkit = new FormToolkit(this.getSite().getShell().getDisplay());
        this.form = this.toolkit.createScrolledForm(parent);
        Messages.get();
        this.form.setText(Messages.ExportFileBuilder_FormTitle);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 3;
        this.form.getBody().setLayout((Layout)layout);
        this.createFileSection();
        this.createTemplateSection();
        this.createEventSection();
        this.createTrapSection();
        this.createRuleSection();
        this.createScriptSection();
        this.createToolsSection();
        this.createSummaryTablesSection();
        this.form.reflow(true);
        this.activateContext();
        this.createActions();
        this.contributeToActionBars();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.serverconfig.context.ExportFileBuilder");
        }
    }

    private void createFileSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 256);
        Messages.get();
        section.setText(Messages.ExportFileBuilder_SectionFile);
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        td.colspan = 2;
        section.setLayoutData((Object)td);
        Composite clientArea = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        section.setClient((Control)clientArea);
        this.description = new LabeledText(clientArea, 0, 2818);
        this.toolkit.adapt((Composite)this.description);
        Messages.get();
        this.description.setLabel(Messages.ExportFileBuilder_Description);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 200;
        this.description.setLayoutData((Object)gd);
    }

    private void createTemplateSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 256);
        Messages.get();
        section.setText(Messages.ExportFileBuilder_SectionTemplates);
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite clientArea = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        section.setClient((Control)clientArea);
        this.templateViewer = new TableViewer(clientArea, 67586);
        this.toolkit.adapt((Composite)this.templateViewer.getTable());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 200;
        gd.verticalSpan = 2;
        this.templateViewer.getTable().setLayoutData((Object)gd);
        this.templateViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.templateViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.templateViewer.setComparator((ViewerComparator)new ObjectLabelComparator((ILabelProvider)this.templateViewer.getLabelProvider()));
        this.templateViewer.getTable().setSortDirection(128);
        ImageHyperlink linkAdd = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkAdd.setText(Messages.ExportFileBuilder_Add);
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ExportFileBuilder.this.addTemplates();
            }
        });
        ImageHyperlink linkRemove = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkRemove.setText(Messages.ExportFileBuilder_Remove);
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ExportFileBuilder.this.removeObjects(ExportFileBuilder.this.templateViewer, ExportFileBuilder.this.templates);
            }
        });
    }

    private void createEventSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 256);
        Messages.get();
        section.setText(Messages.ExportFileBuilder_SectionEvents);
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite clientArea = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        section.setClient((Control)clientArea);
        this.eventViewer = new TableViewer(clientArea, 67586);
        this.toolkit.adapt((Composite)this.eventViewer.getTable());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 200;
        gd.verticalSpan = 2;
        this.eventViewer.getTable().setLayoutData((Object)gd);
        this.eventViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.eventViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.eventViewer.setComparator((ViewerComparator)new ObjectLabelComparator((ILabelProvider)this.eventViewer.getLabelProvider()));
        this.eventViewer.getTable().setSortDirection(128);
        ImageHyperlink linkAdd = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkAdd.setText(Messages.ExportFileBuilder_Add);
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ExportFileBuilder.this.addEvents();
            }
        });
        ImageHyperlink linkRemove = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkRemove.setText(Messages.ExportFileBuilder_Remove);
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ExportFileBuilder.this.removeObjects(ExportFileBuilder.this.eventViewer, ExportFileBuilder.this.events);
            }
        });
    }

    private void createTrapSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 256);
        Messages.get();
        section.setText(Messages.ExportFileBuilder_SectionTraps);
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite clientArea = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        section.setClient((Control)clientArea);
        this.trapViewer = new TableViewer(clientArea, 67586);
        this.toolkit.adapt((Composite)this.trapViewer.getTable());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 200;
        gd.verticalSpan = 2;
        this.trapViewer.getTable().setLayoutData((Object)gd);
        this.trapViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.trapViewer.setLabelProvider((IBaseLabelProvider)new TrapListLabelProvider());
        this.trapViewer.setComparator((ViewerComparator)new ObjectLabelComparator((ILabelProvider)this.eventViewer.getLabelProvider()));
        this.trapViewer.getTable().setSortDirection(128);
        ImageHyperlink linkAdd = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkAdd.setText(Messages.ExportFileBuilder_Add);
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (ExportFileBuilder.this.snmpTrapCache == null) {
                    Messages.get();
                    new ConsoleJob(Messages.ExportFileBuilder_TrapsLoadJobName, (IWorkbenchPart)ExportFileBuilder.this, "org.netxms.ui.eclipse.serverconfig", null){

                        protected void runInternal(IProgressMonitor monitor) throws Exception {
                            ExportFileBuilder.this.snmpTrapCache = ExportFileBuilder.this.session.getSnmpTrapsConfigurationSummary();
                            this.runInUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    ExportFileBuilder.this.addTraps();
                                }
                            });
                        }

                        protected String getErrorMessage() {
                            Messages.get();
                            return Messages.ExportFileBuilder_TrapsLoadJobError;
                        }
                    }.start();
                } else {
                    ExportFileBuilder.this.addTraps();
                }
            }
        });
        ImageHyperlink linkRemove = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkRemove.setText(Messages.ExportFileBuilder_Remove);
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ExportFileBuilder.this.removeObjects(ExportFileBuilder.this.trapViewer, ExportFileBuilder.this.traps);
            }
        });
    }

    private void createRuleSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 256);
        Messages.get();
        section.setText(Messages.ExportFileBuilder_SectionRules);
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite clientArea = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        section.setClient((Control)clientArea);
        this.ruleViewer = new TableViewer(clientArea, 67586);
        this.toolkit.adapt((Composite)this.ruleViewer.getTable());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 200;
        gd.verticalSpan = 2;
        this.ruleViewer.getTable().setLayoutData((Object)gd);
        this.ruleViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.ruleViewer.setLabelProvider((IBaseLabelProvider)new RuleLabelProvider());
        this.ruleViewer.setComparator((ViewerComparator)new RuleComparator());
        this.ruleViewer.getTable().setSortDirection(128);
        ImageHyperlink linkAdd = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkAdd.setText(Messages.ExportFileBuilder_Add);
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (ExportFileBuilder.this.rulesCache == null) {
                    Messages.get();
                    new ConsoleJob(Messages.ExportFileBuilder_EPPLoadJobName, (IWorkbenchPart)ExportFileBuilder.this, "org.netxms.ui.eclipse.serverconfig", null){

                        protected void runInternal(IProgressMonitor monitor) throws Exception {
                            ExportFileBuilder.this.rulesCache = ExportFileBuilder.this.session.getEventProcessingPolicy().getRules();
                            this.runInUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    ExportFileBuilder.this.addRules();
                                }
                            });
                        }

                        protected String getErrorMessage() {
                            Messages.get();
                            return Messages.ExportFileBuilder_EPPLoadJobError;
                        }
                    }.start();
                } else {
                    ExportFileBuilder.this.addRules();
                }
            }
        });
        ImageHyperlink linkRemove = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkRemove.setText(Messages.ExportFileBuilder_Remove);
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ExportFileBuilder.this.removeObjects(ExportFileBuilder.this.ruleViewer, ExportFileBuilder.this.rules);
            }
        });
    }

    private void createScriptSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 256);
        section.setText("Scripts");
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite clientArea = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        section.setClient((Control)clientArea);
        this.scriptViewer = new TableViewer(clientArea, 67586);
        this.toolkit.adapt((Composite)this.ruleViewer.getTable());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 200;
        gd.verticalSpan = 2;
        this.scriptViewer.getTable().setLayoutData((Object)gd);
        this.scriptViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.scriptViewer.setLabelProvider((IBaseLabelProvider)new ScriptLabelProvider());
        this.scriptViewer.setComparator((ViewerComparator)new ScriptComparator());
        this.scriptViewer.getTable().setSortDirection(128);
        ImageHyperlink linkAdd = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkAdd.setText(Messages.ExportFileBuilder_Add);
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ExportFileBuilder.this.addScripts();
            }
        });
        ImageHyperlink linkRemove = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkRemove.setText(Messages.ExportFileBuilder_Remove);
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ExportFileBuilder.this.removeObjects(ExportFileBuilder.this.scriptViewer, ExportFileBuilder.this.scripts);
            }
        });
    }

    private void createToolsSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 256);
        section.setText("Object Tools");
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite clientArea = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        section.setClient((Control)clientArea);
        this.toolsViewer = new TableViewer(clientArea, 67586);
        this.toolkit.adapt((Composite)this.ruleViewer.getTable());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 200;
        gd.verticalSpan = 2;
        this.toolsViewer.getTable().setLayoutData((Object)gd);
        this.toolsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.toolsViewer.setLabelProvider((IBaseLabelProvider)new ToolLabelProvider());
        this.toolsViewer.setComparator((ViewerComparator)new ToolComparator());
        this.toolsViewer.getTable().setSortDirection(128);
        ImageHyperlink linkAdd = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkAdd.setText(Messages.ExportFileBuilder_Add);
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ExportFileBuilder.this.addObjectTools();
            }
        });
        ImageHyperlink linkRemove = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkRemove.setText(Messages.ExportFileBuilder_Remove);
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ExportFileBuilder.this.removeObjects(ExportFileBuilder.this.toolsViewer, ExportFileBuilder.this.tools);
            }
        });
    }

    private void createSummaryTablesSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 256);
        section.setText("DCI Summary Tables");
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite clientArea = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        section.setClient((Control)clientArea);
        this.summaryTableViewer = new TableViewer(clientArea, 67586);
        this.toolkit.adapt((Composite)this.ruleViewer.getTable());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 200;
        gd.verticalSpan = 2;
        this.summaryTableViewer.getTable().setLayoutData((Object)gd);
        this.summaryTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.summaryTableViewer.setLabelProvider((IBaseLabelProvider)new SummaryTablesLabelProvider());
        this.summaryTableViewer.setComparator((ViewerComparator)new SummaryTablesComparator());
        this.summaryTableViewer.getTable().setSortDirection(128);
        ImageHyperlink linkAdd = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkAdd.setText(Messages.ExportFileBuilder_Add);
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ExportFileBuilder.this.addSummaryTables();
            }
        });
        ImageHyperlink linkRemove = this.toolkit.createImageHyperlink(clientArea, 0);
        Messages.get();
        linkRemove.setText(Messages.ExportFileBuilder_Remove);
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ExportFileBuilder.this.removeObjects(ExportFileBuilder.this.summaryTableViewer, ExportFileBuilder.this.summaryTables);
            }
        });
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        Messages.get();
        this.actionSave = new Action(Messages.ExportFileBuilder_Save, SharedIcons.SAVE){

            public void run() {
                ExportFileBuilder.this.save();
            }
        };
        this.actionSave.setActionDefinitionId("org.netxms.ui.eclipse.serverconfig.commands.save_exported_config");
        handlerService.activateHandler(this.actionSave.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionSave));
        this.actionPublish = new Action("&Publish...", Activator.getImageDescriptor("icons/publish.gif")){

            public void run() {
                ExportFileBuilder.this.publish();
            }
        };
        this.actionPublish.setActionDefinitionId("org.netxms.ui.eclipse.serverconfig.commands.publish_config");
        handlerService.activateHandler(this.actionPublish.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionPublish));
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionSave);
        manager.add((IAction)this.actionPublish);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionSave);
        manager.add((IAction)this.actionPublish);
    }

    public void setFocus() {
        this.form.setFocus();
    }

    private void setModified() {
        if (!this.modified) {
            this.modified = true;
            this.firePropertyChange(257);
        }
    }

    private void publish() {
        new ConsoleJob("Get list of configured repositories", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List repositories = ExportFileBuilder.this.session.getRepositories();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ExportFileBuilder.this.publishStage2(repositories);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get list of configured repositories";
            }
        }.start();
    }

    private void publishStage2(List<Repository> repositories) {
        RepositorySelectionDialog dlg = new RepositorySelectionDialog(this.getSite().getShell(), repositories);
        if (dlg.open() != 0) {
            return;
        }
        final Repository repository = dlg.getSelection();
        this.doExport(new ExportCompletionHandler(){

            @Override
            public void exportCompleted(final String xml) {
                new ConsoleJob("Publish configuration", (IWorkbenchPart)ExportFileBuilder.this, "org.netxms.ui.eclipse.serverconfig", null){

                    protected void runInternal(IProgressMonitor monitor) throws Exception {
                        URL url = new URL(String.valueOf(repository.getUrl()) + "/rest-api/push-export?accessToken=" + repository.getAuthToken());
                        URLConnection conn = url.openConnection();
                        if (!(conn instanceof HttpURLConnection)) {
                            throw new Exception("Unsupported URL type");
                        }
                        ((HttpURLConnection)conn).setRequestMethod("POST");
                        ((HttpURLConnection)conn).setRequestProperty("User-Agent", "NetXMS Console/2.1-M1");
                        ((HttpURLConnection)conn).setRequestProperty("Content-Type", "application/xml; charset=utf-8");
                        ((HttpURLConnection)conn).setDoOutput(true);
                        ((HttpURLConnection)conn).setAllowUserInteraction(false);
                        ((HttpURLConnection)conn).setUseCaches(false);
                        OutputStream out = conn.getOutputStream();
                        try {
                            out.write(xml.getBytes("UTF-8"));
                            out.flush();
                            int responseCode = ((HttpURLConnection)conn).getResponseCode();
                            Activator.logInfo("Publish config: url=" + url.toString() + " response=" + responseCode);
                            if (responseCode != 200) {
                                throw new Exception(String.format("HTTP error %d", responseCode));
                            }
                        }
                        finally {
                            out.close();
                        }
                    }

                    protected String getErrorMessage() {
                        return "Cannot publish configuration to repository";
                    }
                }.start();
            }
        });
    }

    private void doExport(final ExportCompletionHandler completionHandler) {
        final long[] eventList = new long[this.events.size()];
        int i = 0;
        for (EventTemplate t : this.events.values()) {
            eventList[i++] = t.getCode();
        }
        final long[] templateList = new long[this.templates.size()];
        i = 0;
        for (Template t : this.templates.values()) {
            templateList[i++] = t.getObjectId();
        }
        final long[] trapList = new long[this.traps.size()];
        i = 0;
        for (SnmpTrap t : this.traps.values()) {
            trapList[i++] = t.getId();
        }
        final UUID[] ruleList = new UUID[this.rules.size()];
        i = 0;
        for (EventProcessingPolicyRule r : this.rules.values()) {
            ruleList[i++] = r.getGuid();
        }
        final long[] scriptList = new long[this.scripts.size()];
        i = 0;
        for (Script s : this.scripts.values()) {
            scriptList[i++] = s.getId();
        }
        final long[] toolList = new long[this.tools.size()];
        i = 0;
        for (ObjectTool t : this.tools.values()) {
            toolList[i++] = t.getId();
        }
        final long[] summaryTableList = new long[this.summaryTables.size()];
        i = 0;
        for (DciSummaryTableDescriptor t : this.summaryTables.values()) {
            summaryTableList[i++] = t.getId();
        }
        final String descriptionText = this.description.getText();
        Messages.get();
        new ConsoleJob(Messages.ExportFileBuilder_ExportJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final String xml = ExportFileBuilder.this.session.exportConfiguration(descriptionText, eventList, trapList, templateList, ruleList, scriptList, toolList, summaryTableList);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        completionHandler.exportCompleted(xml);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ExportFileBuilder_ExportJobError;
            }
        }.start();
    }

    private void save() {
        this.doExport(new ExportCompletionHandler(){

            @Override
            public void exportCompleted(final String xml) {
                FileDialog dlg = new FileDialog(ExportFileBuilder.this.getSite().getShell(), 8192);
                dlg.setFilterExtensions(new String[]{"*.xml", "*.*"});
                String[] stringArray = new String[2];
                Messages.get();
                stringArray[0] = Messages.ConfigurationImportDialog_FileTypeXML;
                Messages.get();
                stringArray[1] = Messages.ConfigurationImportDialog_FileTypeAll;
                dlg.setFilterNames(stringArray);
                dlg.setOverwrite(true);
                dlg.setFileName(ExportFileBuilder.this.exportFileName);
                final String fileName = dlg.open();
                if (fileName != null) {
                    ExportFileBuilder.this.exportFileName = fileName;
                    new ConsoleJob("Save exported configuration", (IWorkbenchPart)ExportFileBuilder.this, "org.netxms.ui.eclipse.serverconfig", null){

                        protected void runInternal(IProgressMonitor monitor) throws Exception {
                            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF-8");
                            try {
                                out.write(xml);
                            }
                            finally {
                                out.close();
                            }
                            this.runInUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    ExportFileBuilder.this.modified = false;
                                    ExportFileBuilder.this.firePropertyChange(257);
                                }
                            });
                        }

                        protected String getErrorMessage() {
                            return "Cannot save exported configuration to file";
                        }
                    }.start();
                }
            }
        });
    }

    public void doSave(IProgressMonitor monitor) {
        this.getSite().getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ExportFileBuilder.this.save();
            }
        });
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.modified;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.modified;
    }

    private static Object keyFromObject(Object o) {
        if (o instanceof Template) {
            return ((Template)o).getObjectId();
        }
        if (o instanceof EventTemplate) {
            return ((EventTemplate)o).getCode();
        }
        if (o instanceof SnmpTrap) {
            return ((SnmpTrap)o).getId();
        }
        if (o instanceof Script) {
            return ((Script)o).getId();
        }
        if (o instanceof ObjectTool) {
            return ((ObjectTool)o).getId();
        }
        if (o instanceof EventProcessingPolicyRule) {
            return ((EventProcessingPolicyRule)o).getGuid();
        }
        if (o instanceof DciSummaryTableDescriptor) {
            return ((DciSummaryTableDescriptor)o).getId();
        }
        return 0L;
    }

    private void removeObjects(TableViewer viewer, Map<?, ?> objects) {
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                objects.remove(ExportFileBuilder.keyFromObject(o));
            }
            viewer.setInput((Object)objects.values().toArray());
            this.setModified();
        }
    }

    private void addEvents() {
        EventSelectionDialog dlg = new EventSelectionDialog(this.getSite().getShell());
        dlg.enableMultiSelection(true);
        if (dlg.open() == 0) {
            EventTemplate[] eventTemplateArray = dlg.getSelectedEvents();
            int n = eventTemplateArray.length;
            int n2 = 0;
            while (n2 < n) {
                EventTemplate t = eventTemplateArray[n2];
                this.events.put(t.getCode(), t);
                ++n2;
            }
            this.eventViewer.setInput((Object)this.events.values().toArray());
            this.setModified();
        }
    }

    private void addTemplates() {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getSite().getShell(), null, ObjectSelectionDialog.createTemplateSelectionFilter());
        dlg.enableMultiSelection(true);
        dlg.showFilterToolTip(false);
        if (dlg.open() == 0) {
            final HashSet<Long> idList = new HashSet<Long>();
            AbstractObject[] abstractObjectArray = dlg.getSelectedObjects(Template.class);
            int n = abstractObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractObject o = abstractObjectArray[n2];
                this.templates.put(((Template)o).getObjectId(), (Template)o);
                idList.add(o.getObjectId());
                ++n2;
            }
            this.templateViewer.setInput((Object)this.templates.values().toArray());
            this.setModified();
            Messages.get();
            new ConsoleJob(Messages.ExportFileBuilder_ResolveJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    final HashSet<Long> eventCodes = new HashSet<Long>();
                    final HashMap<Long, Script> scriptList = new HashMap<Long, Script>();
                    for (Long id : idList) {
                        long[] e;
                        long[] lArray = e = ExportFileBuilder.this.session.getDataCollectionEvents(id.longValue());
                        int n = e.length;
                        int n2 = 0;
                        while (n2 < n) {
                            long c = lArray[n2];
                            if (c >= 100000L) {
                                eventCodes.add(c);
                            }
                            ++n2;
                        }
                        for (Script s : ExportFileBuilder.this.session.getDataCollectionScripts(id.longValue())) {
                            scriptList.put(s.getId(), s);
                        }
                    }
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            for (EventTemplate e : ExportFileBuilder.this.session.findMultipleEventTemplates(eventCodes.toArray(new Long[eventCodes.size()]))) {
                                ExportFileBuilder.this.events.put(e.getCode(), e);
                            }
                            ExportFileBuilder.this.eventViewer.setInput((Object)ExportFileBuilder.this.events.values().toArray());
                            ExportFileBuilder.this.scripts.putAll(scriptList);
                            ExportFileBuilder.this.scriptViewer.setInput((Object)ExportFileBuilder.this.scripts.values().toArray());
                        }
                    });
                }

                protected String getErrorMessage() {
                    return null;
                }
            }.start();
        }
    }

    private void addTraps() {
        SelectSnmpTrapDialog dlg = new SelectSnmpTrapDialog(this.getSite().getShell(), this.snmpTrapCache);
        if (dlg.open() == 0) {
            HashSet<Long> eventCodes = new HashSet<Long>();
            for (SnmpTrap t : dlg.getSelection()) {
                this.traps.put(t.getId(), t);
                if (t.getEventCode() < 100000) continue;
                eventCodes.add(Long.valueOf(t.getEventCode()));
            }
            this.trapViewer.setInput((Object)this.traps.values().toArray());
            this.setModified();
            if (eventCodes.size() > 0) {
                for (EventTemplate e : this.session.findMultipleEventTemplates(eventCodes.toArray(new Long[eventCodes.size()]))) {
                    this.events.put(e.getCode(), e);
                }
                this.eventViewer.setInput((Object)this.events.values().toArray());
            }
        }
    }

    private void addRules() {
        RuleSelectionDialog dlg = new RuleSelectionDialog(this.getSite().getShell(), this.rulesCache);
        if (dlg.open() == 0) {
            HashSet<Long> eventCodes = new HashSet<Long>();
            for (EventProcessingPolicyRule r : dlg.getSelectedRules()) {
                this.rules.put(r.getGuid(), r);
                for (Long e : r.getEvents()) {
                    if (e < 100000L) continue;
                    eventCodes.add(e);
                }
            }
            this.ruleViewer.setInput((Object)this.rules.values().toArray());
            this.setModified();
            if (eventCodes.size() > 0) {
                for (EventTemplate e : this.session.findMultipleEventTemplates(eventCodes.toArray(new Long[eventCodes.size()]))) {
                    this.events.put(e.getCode(), e);
                }
                this.eventViewer.setInput((Object)this.events.values().toArray());
            }
        }
    }

    private void addScripts() {
        SelectScriptDialog dlg = new SelectScriptDialog(this.getSite().getShell());
        dlg.setMultiSelection(true);
        if (dlg.open() == 0) {
            for (Script s : dlg.getSelection()) {
                this.scripts.put(s.getId(), s);
            }
            this.scriptViewer.setInput((Object)this.scripts.values().toArray());
            this.setModified();
        }
    }

    private void addObjectTools() {
        ObjectToolSelectionDialog dlg = new ObjectToolSelectionDialog(this.getSite().getShell());
        if (dlg.open() == 0) {
            for (ObjectTool t : dlg.getSelection()) {
                this.tools.put(t.getId(), t);
            }
            this.toolsViewer.setInput((Object)this.tools.values().toArray());
            this.setModified();
        }
    }

    private void addSummaryTables() {
        SummaryTableSelectionDialog dlg = new SummaryTableSelectionDialog(this.getSite().getShell());
        if (dlg.open() == 0) {
            for (DciSummaryTableDescriptor t : dlg.getSelection()) {
                this.summaryTables.put(t.getId(), t);
            }
            this.summaryTableViewer.setInput((Object)this.summaryTables.values().toArray());
            this.setModified();
        }
    }

    private static interface ExportCompletionHandler {
        public void exportCompleted(String var1);
    }
}

