/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.views.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.NXCSession;
import org.netxms.client.ScheduledTask;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ScheduleTableEntryLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private NXCSession session = ConsoleSharedData.getSession();
    private WorkbenchLabelProvider wbLabelProvider = new WorkbenchLabelProvider();

    public Image getColumnImage(Object element, int columnIndex) {
        switch (columnIndex) {
            case 2: {
                if (((ScheduledTask)element).getObjectId() == 0L) {
                    return null;
                }
                AbstractObject object = this.session.findObjectById(((ScheduledTask)element).getObjectId());
                return object != null ? this.wbLabelProvider.getImage((Object)object) : null;
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        ScheduledTask task = (ScheduledTask)element;
        switch (columnIndex) {
            case 0: {
                return Long.toString(task.getId());
            }
            case 1: {
                return task.getScheduledTaskId();
            }
            case 2: {
                if (task.getObjectId() == 0L) {
                    return "";
                }
                AbstractObject object = this.session.findObjectById(task.getObjectId());
                return object != null ? object.getObjectName() : "[" + Long.toString(task.getObjectId()) + "]";
            }
            case 3: {
                return task.getParameters();
            }
            case 4: {
                return task.getSchedule().isEmpty() ? RegionalSettings.getDateTimeFormat().format(task.getExecutionTime()) : task.getSchedule();
            }
            case 5: {
                return task.getLastExecutionTime().getTime() == 0L ? "" : RegionalSettings.getDateTimeFormat().format(task.getLastExecutionTime());
            }
            case 6: {
                return task.getStatus();
            }
            case 7: {
                if ((task.getFlags() & 8) != 0) {
                    return "system";
                }
                AbstractUserObject user = this.session.findUserDBObjectById(task.getOwner());
                return user != null ? user.getName() : "[" + Long.toString(task.getOwner()) + "]";
            }
        }
        return null;
    }
}

