/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.filemanager.widgets;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.netxms.client.AgentFileData;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.ui.eclipse.filemanager.Messages;
import org.netxms.ui.eclipse.filemanager.widgets.BaseFileViewer;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class DynamicFileViewer
extends BaseFileViewer {
    protected ConsoleJob monitoringJob = null;
    protected ConsoleJob restartJob = null;
    protected String fileId = null;
    protected long nodeId = 0L;
    protected String remoteFileName;
    protected NXCSession session = ConsoleSharedData.getSession();

    public DynamicFileViewer(Composite parent, int style, IViewPart viewPart) {
        super(parent, style, viewPart);
        final SessionListener sessionListener = new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                if (n.getCode() == 1026 && n.getSubCode() == DynamicFileViewer.this.nodeId) {
                    DynamicFileViewer.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            DynamicFileViewer.this.restartTracking();
                        }
                    });
                }
            }
        };
        this.session.addListener(sessionListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DynamicFileViewer.this.session.removeListener(sessionListener);
                DynamicFileViewer.this.stopTracking();
            }
        });
    }

    public void startTracking(final long nodeId, final String fileId, String remoteFileName) {
        if (this.restartJob != null) {
            this.restartJob.cancel();
        }
        if (this.monitoringJob != null) {
            this.monitoringJob.cancel();
        }
        this.hideMessage();
        this.fileId = fileId;
        this.nodeId = nodeId;
        this.remoteFileName = remoteFileName;
        this.text.setTopIndex(this.text.getLineCount() - 1);
        Messages.get();
        this.monitoringJob = new ConsoleJob(Messages.DynamicFileViewer_TrackFileChanges, null, "org.netxms.ui.eclipse.filemanager", null){
            private boolean tracking;
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3);
                this.tracking = true;
            }

            protected void canceling() {
                this.tracking = false;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                while (this.tracking) {
                    final String s = DynamicFileViewer.this.session.waitForFileTail(fileId, 3000);
                    if (s == null) continue;
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (!(this).DynamicFileViewer.this.text.isDisposed()) {
                                DynamicFileViewer.this.append(s);
                            } else {
                                tracking = false;
                            }
                        }
                    });
                }
                DynamicFileViewer.this.session.cancelFileMonitoring(nodeId, fileId);
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.DynamicFileViewer_FileTrackingFailed;
            }
        };
        this.monitoringJob.setUser(false);
        this.monitoringJob.setSystem(true);
        this.monitoringJob.start();
    }

    public void stopTracking() {
        if (this.restartJob != null) {
            this.restartJob.cancel();
            this.restartJob = null;
        }
        if (this.monitoringJob != null) {
            this.monitoringJob.cancel();
            this.monitoringJob = null;
            this.fileId = null;
            this.nodeId = 0L;
        }
    }

    private void restartTracking() {
        if (this.monitoringJob != null) {
            this.monitoringJob.cancel();
            this.monitoringJob = null;
        }
        if (this.restartJob != null) {
            this.restartJob.cancel();
        }
        StringBuilder stringBuilder = new StringBuilder("\n\n----------------------------------------------------------------------\n");
        Messages.get();
        this.text.append(stringBuilder.append(Messages.FileViewer_NotifyFollowConnectionLost).append("\n----------------------------------------------------------------------\n").toString());
        Messages.get();
        this.showMessage(2, Messages.FileViewer_NotifyFollowConnectionLost);
        Messages.get();
        this.restartJob = new ConsoleJob(Messages.DynamicFileViewer_RestartFileTracking, null, "org.netxms.ui.eclipse.filemanager", null){
            private boolean running;
            {
                this.running = true;
            }

            protected void canceling() {
                this.running = false;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                while (this.running) {
                    try {
                        final AgentFileData file = DynamicFileViewer.this.session.downloadFileFromAgent(DynamicFileViewer.this.nodeId, DynamicFileViewer.this.remoteFileName, 1024L, true);
                        this.runInUIThread(new Runnable(){

                            @Override
                            public void run() {
                                if ((this).DynamicFileViewer.this.text.isDisposed()) {
                                    running = false;
                                    return;
                                }
                                DynamicFileViewer.this.hideMessage();
                                StyledText styledText = (this).DynamicFileViewer.this.text;
                                StringBuilder stringBuilder = new StringBuilder("-------------------------------------------------------------------------------\n");
                                Messages.get();
                                styledText.append(stringBuilder.append(Messages.FileViewer_NotifyFollowConnectionEnabed).append("\n-------------------------------------------------------------------------------\n\n").toString());
                                DynamicFileViewer.this.append(DynamicFileViewer.loadFile(file.getFile()));
                                DynamicFileViewer.this.startTracking((this).DynamicFileViewer.this.nodeId, (this).DynamicFileViewer.this.fileId, (this).DynamicFileViewer.this.remoteFileName);
                            }
                        });
                        break;
                    }
                    catch (Exception exception) {
                        Thread.sleep(20000L);
                    }
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.DynamicFileViewer_CannotRestartFileTracking;
            }
        };
        this.restartJob.setUser(false);
        this.restartJob.setSystem(true);
        this.restartJob.start();
    }
}

