/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.netxms.client.NXCSession;
import org.netxms.client.Table;
import org.netxms.client.TableRow;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.actions.ExportToCsvAction;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.views.helpers.ObjectSelectionProvider;
import org.netxms.ui.eclipse.datacollection.widgets.internal.TableContentProvider;
import org.netxms.ui.eclipse.datacollection.widgets.internal.TableItemComparator;
import org.netxms.ui.eclipse.datacollection.widgets.internal.TableLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectContextMenu;
import org.netxms.ui.eclipse.objects.ObjectWrapper;
import org.netxms.ui.eclipse.objectview.views.TabbedObjectView;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.ViewRefreshController;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class SummaryTableWidget
extends Composite {
    private int tableId;
    private long baseObjectId;
    private IViewPart viewPart;
    private SortableTableViewer viewer;
    private TableLabelProvider labelProvider;
    private Action actionExportToCsv;
    private Action actionUseMultipliers;
    private Action actionForcePollAll;
    private Action actionShowObjectDetails;
    private ViewRefreshController refreshController;
    private boolean useMultipliers = true;
    private TableColumn currentColumn = null;
    private ObjectSelectionProvider objectSelectionProvider;

    public SummaryTableWidget(Composite parent, int style, IViewPart viewPart, int tableId, long baseObjectId) {
        super(parent, style);
        this.viewPart = viewPart;
        this.tableId = tableId;
        this.baseObjectId = baseObjectId;
        this.setLayout((Layout)new FillLayout());
        this.viewer = new SortableTableViewer((Composite)this, 65538);
        this.viewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.labelProvider = new TableLabelProvider();
        this.labelProvider.setUseMultipliers(this.useMultipliers);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.objectSelectionProvider = new ObjectSelectionProvider((ISelectionProvider)this.viewer);
        this.createActions();
        this.createPopupMenu();
        this.refreshController = new ViewRefreshController(viewPart, -1, new Runnable(){

            @Override
            public void run() {
                if (SummaryTableWidget.this.isDisposed()) {
                    return;
                }
                SummaryTableWidget.this.refresh();
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SummaryTableWidget.this.refreshController.dispose();
            }
        });
        this.viewer.getTable().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 3) {
                    SummaryTableWidget.this.currentColumn = SummaryTableWidget.this.viewer.getColumnAtPoint(new Point(e.x, e.y));
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    private void createActions() {
        this.actionExportToCsv = new ExportToCsvAction(this.viewPart, (ColumnViewer)this.viewer, true);
        Messages.get();
        this.actionUseMultipliers = new Action(Messages.LastValues_UseMultipliers, 2){

            public void run() {
                SummaryTableWidget.this.setUseMultipliers(!SummaryTableWidget.this.useMultipliers);
            }
        };
        this.actionUseMultipliers.setChecked(this.useMultipliers);
        Messages.get();
        this.actionForcePollAll = new Action(Messages.SummaryTableWidget_ForcePollForAllColumns){

            public void run() {
                SummaryTableWidget.this.forcePoll(true);
            }
        };
        Messages.get();
        this.actionShowObjectDetails = new Action(Messages.SummaryTableWidget_ShowObjectDetails){

            public void run() {
                SummaryTableWidget.this.showObjectDetails();
            }
        };
        this.actionShowObjectDetails.setId("org.netxms.ui.eclipse.datacollection.popupActions.ShowObjectDetails");
    }

    private void createPopupMenu() {
        final MenuManager nodeMenuManager = new MenuManager(){

            public String getMenuText() {
                Messages.get();
                return Messages.SummaryTableWidget_Node;
            }
        };
        nodeMenuManager.setRemoveAllWhenShown(true);
        nodeMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ObjectContextMenu.fill((IMenuManager)mgr, (IShellProvider)SummaryTableWidget.this.viewPart.getSite(), (ISelectionProvider)SummaryTableWidget.this.objectSelectionProvider);
            }
        });
        MenuManager rowMenuManager = new MenuManager();
        rowMenuManager.setRemoveAllWhenShown(true);
        rowMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                SummaryTableWidget.this.fillContextMenu(mgr, nodeMenuManager);
            }
        });
        Menu menu = rowMenuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        if (this.viewPart != null) {
            this.viewPart.getSite().registerContextMenu(String.valueOf(this.viewPart.getSite().getId()) + ".data", rowMenuManager, (ISelectionProvider)this.viewer);
            this.viewPart.getSite().registerContextMenu(String.valueOf(this.viewPart.getSite().getId()) + ".node", nodeMenuManager, (ISelectionProvider)this.objectSelectionProvider);
        }
    }

    protected void fillContextMenu(IMenuManager manager, MenuManager nodeMenuManager) {
        manager.add((IAction)this.actionUseMultipliers);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)nodeMenuManager);
        manager.add((IContributionItem)new GroupMarker("objecttools"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowObjectDetails);
        manager.add((IContributionItem)new Separator());
        if (this.currentColumn != null && (Integer)this.currentColumn.getData("ID") > 0) {
            Messages.get();
            manager.add((IAction)new Action(String.format(Messages.SummaryTableWidget_ForcePollForNode, this.currentColumn.getText())){

                public void run() {
                    SummaryTableWidget.this.forcePoll(false);
                }
            });
        }
        manager.add((IAction)this.actionForcePollAll);
        manager.add((IAction)this.actionExportToCsv);
    }

    public void refresh() {
        this.viewer.setInput(null);
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(Messages.SummaryTable_JobName, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Table table = session.queryDciSummaryTable(SummaryTableWidget.this.tableId, SummaryTableWidget.this.baseObjectId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        SummaryTableWidget.this.update(table);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.SummaryTable_JobError;
            }
        }.start();
    }

    public void update(Table table) {
        if (!this.viewer.isInitialized()) {
            String[] names = table.getColumnDisplayNames();
            int[] widths = new int[names.length];
            Arrays.fill(widths, 100);
            this.viewer.createColumns(names, widths, 0, 128);
            final IDialogSettings settings = Activator.getDefault().getDialogSettings();
            final String key = String.valueOf(this.viewPart.getViewSite().getId()) + ".SummaryTable." + Integer.toString(this.tableId);
            WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)settings, (String)key);
            String value = settings.get(String.valueOf(key) + ".useMultipliers");
            if (value != null) {
                this.useMultipliers = Boolean.parseBoolean(value);
            }
            this.labelProvider.setUseMultipliers(this.useMultipliers);
            this.viewer.getTable().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    WidgetHelper.saveTableViewerSettings((SortableTableViewer)SummaryTableWidget.this.viewer, (IDialogSettings)settings, (String)key);
                    settings.put(String.valueOf(key) + ".useMultipliers", SummaryTableWidget.this.useMultipliers);
                }
            });
            this.viewer.setComparator((ViewerComparator)new TableItemComparator(table.getColumnDataTypes()));
        }
        this.labelProvider.setColumnDataTypes(table.getColumnDataTypes());
        this.viewer.setInput((Object)table);
    }

    public SortableTableViewer getViewer() {
        return this.viewer;
    }

    public ISelectionProvider getObjectSelectionProvider() {
        return this.objectSelectionProvider;
    }

    public void setAutoRefresh(int interval) {
        this.refreshController.setInterval(interval);
    }

    public boolean areMultipliersUsed() {
        return this.useMultipliers;
    }

    public void setUseMultipliers(boolean value) {
        this.useMultipliers = value;
        this.actionUseMultipliers.setChecked(value);
        if (this.viewer.isInitialized()) {
            this.labelProvider.setUseMultipliers(value);
            this.viewer.refresh();
        }
    }

    public Action getActionUseMultipliers() {
        return this.actionUseMultipliers;
    }

    private void showObjectDetails() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        AbstractObject object = ((ObjectWrapper)selection.getFirstElement()).getObject();
        if (object != null) {
            try {
                TabbedObjectView view = (TabbedObjectView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.netxms.ui.eclipse.objectview.view.tabbed_object_view");
                view.setObject(object);
            }
            catch (PartInitException e) {
                Shell shell = this.getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openError((Shell)shell, (String)Messages.SummaryTableWidget_Error, (String)String.format(Messages.SummaryTableWidget_CannotOpenObjectDetails, e.getLocalizedMessage()));
            }
        }
    }

    private void forcePoll(boolean pollAll) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        final ArrayList<PollRequest> requests = new ArrayList<PollRequest>();
        for (Object o : selection.toList()) {
            TableRow r = (TableRow)o;
            long nodeId = r.getObjectId();
            if (pollAll) {
                int count = ((Table)this.viewer.getInput()).getColumnCount();
                int i = 1;
                while (i < count) {
                    long dciId = r.get(i).getObjectId();
                    if (dciId != 0L) {
                        requests.add(new PollRequest(nodeId, dciId));
                    }
                    ++i;
                }
                continue;
            }
            int index = ((Table)this.viewer.getInput()).getColumnIndex(this.currentColumn.getText());
            long dciId = r.get(index).getObjectId();
            if (dciId == 0L) continue;
            requests.add(new PollRequest(nodeId, dciId));
        }
        if (requests.isEmpty()) {
            return;
        }
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(Messages.SummaryTableWidget_ForceDciPoll, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                Messages.get();
                monitor.beginTask(Messages.SummaryTableWidget_DciPoll, requests.size());
                for (PollRequest r : requests) {
                    session.forceDCIPoll(r.nodeId, r.dciId);
                    monitor.worked(1);
                }
                monitor.done();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        SummaryTableWidget.this.refresh();
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.SummaryTableWidget_13;
            }
        }.start();
    }

    private class PollRequest {
        public long nodeId;
        public long dciId;

        public PollRequest(long nodeId, long dciId) {
            this.nodeId = nodeId;
            this.dciId = dciId;
        }
    }
}

