/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netxms.base.Logger;
import org.netxms.base.NXCPMessage;
import org.netxms.client.AccessListElement;
import org.netxms.client.ObjectMenuFilter;
import org.netxms.client.datacollection.ChartConfig;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.MenuFiltringObj;
import org.simpleframework.xml.convert.AnnotationStrategy;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.strategy.Strategy;

public class GraphSettings
extends ChartConfig
implements MenuFiltringObj {
    public static final int MAX_GRAPH_ITEM_COUNT = 16;
    public static final int TIME_FRAME_FIXED = 0;
    public static final int TIME_FRAME_BACK_FROM_NOW = 1;
    public static final int TIME_FRAME_CURRENT = 2;
    public static final int TIME_UNIT_MINUTE = 0;
    public static final int TIME_UNIT_HOUR = 1;
    public static final int TIME_UNIT_DAY = 2;
    public static final int GF_AUTO_UPDATE = 1;
    public static final int GF_AUTO_SCALE = 256;
    public static final int GF_SHOW_GRID = 512;
    public static final int GF_SHOW_LEGEND = 1024;
    public static final int GF_SHOW_RULER = 2048;
    public static final int GF_SHOW_HOST_NAMES = 4096;
    public static final int GF_LOG_SCALE = 8192;
    public static final int GF_SHOW_TOOLTIPS = 16384;
    public static final int GF_ENABLE_ZOOM = 32768;
    public static final int POSITION_LEFT = 1;
    public static final int POSITION_RIGHT = 2;
    public static final int POSITION_TOP = 4;
    public static final int POSITION_BOTTOM = 8;
    public static final int ACCESS_READ = 1;
    public static final int ACCESS_WRITE = 2;
    public static final int GRAPH_FLAG_TEMPLATE = 1;
    private long id;
    private long ownerId;
    private int flags;
    private String name;
    private String shortName;
    private List<AccessListElement> accessList;
    private ObjectMenuFilter filters;

    public GraphSettings() {
        this.id = 0L;
        this.ownerId = 0L;
        this.flags = 0;
        this.name = "noname";
        this.shortName = "noname";
        this.accessList = new ArrayList<AccessListElement>(0);
        this.filters = new ObjectMenuFilter();
    }

    public GraphSettings(long id, long ownerId, int flags, Collection<AccessListElement> accessList) {
        this.id = id;
        this.ownerId = ownerId;
        this.name = "noname";
        this.shortName = "noname";
        this.flags = flags;
        this.accessList = new ArrayList<AccessListElement>(accessList.size());
        this.accessList.addAll(accessList);
        this.filters = new ObjectMenuFilter();
    }

    public GraphSettings(GraphSettings data, String name) {
        this.id = data.id;
        this.ownerId = data.ownerId;
        this.name = data.name;
        this.shortName = data.shortName;
        this.flags = data.flags & 0xFFFFFFFE;
        this.accessList = new ArrayList<AccessListElement>(data.accessList.size());
        this.accessList.addAll(data.accessList);
        this.filters = data.filters;
        this.setConfig(data);
        this.setTitle(name);
    }

    public static GraphSettings createFromXml(String xml) throws Exception {
        Persister serializer = new Persister((Strategy)new AnnotationStrategy());
        return (GraphSettings)serializer.read(GraphSettings.class, xml);
    }

    public static GraphSettings createGraphSettings(NXCPMessage msg, long baseId) {
        GraphSettings gs;
        try {
            gs = GraphSettings.createFromXml(msg.getFieldAsString(baseId + 4L));
        }
        catch (Exception e) {
            gs = new GraphSettings();
            Logger.debug((String)"GraphSettings.CreateGraphSettings", (String)"Cannot parse ChartConfig XML", (Throwable)e);
        }
        gs.id = msg.getFieldAsInt64(baseId);
        gs.ownerId = msg.getFieldAsInt64(baseId + 1L);
        gs.flags = (int)msg.getFieldAsInt64(baseId + 2L);
        gs.name = msg.getFieldAsString(baseId + 3L);
        try {
            gs.filters = ObjectMenuFilter.createFromXml(msg.getFieldAsString(baseId + 5L));
        }
        catch (Exception e) {
            Logger.debug((String)"GraphSettings.CreateGraphSettings", (String)"Cannot parse ObjectMenuFilter XML: ", (Throwable)e);
            gs.filters = new ObjectMenuFilter();
        }
        String[] parts = gs.name.split("->");
        gs.shortName = parts.length > 1 ? parts[parts.length - 1] : gs.name;
        int count = msg.getFieldAsInt32(baseId + 6L);
        long[] users = msg.getFieldAsUInt32Array(baseId + 7L);
        long[] rights = msg.getFieldAsUInt32Array(baseId + 8L);
        gs.accessList = new ArrayList<AccessListElement>(count);
        for (int i = 0; i < count; ++i) {
            gs.accessList.add(new AccessListElement(users[i], (int)rights[i]));
        }
        return gs;
    }

    public void fillMessage(NXCPMessage msg) {
        msg.setFieldInt32(274L, (int)this.id);
        msg.setField(20L, this.name);
        msg.setFieldInt32(13L, this.flags);
        msg.setField(232L, this.getFiltersAsXML());
        try {
            msg.setField(272L, this.createXml());
        }
        catch (Exception e) {
            Logger.debug((String)"GraphSettings.CreateGraphSettings", (String)"Cannot convert ChartConfig to XML: ", (Throwable)e);
            msg.setField(272L, "");
        }
        msg.setFieldInt32(32L, this.accessList.size());
        long varId = 0x20000000L;
        for (AccessListElement el : this.accessList) {
            msg.setFieldInt32(varId++, (int)el.getUserId());
            msg.setFieldInt32(varId++, el.getAccessRights());
        }
    }

    public long getId() {
        return this.id;
    }

    public long getOwnerId() {
        return this.ownerId;
    }

    public String getName() {
        return this.name;
    }

    public List<AccessListElement> getAccessList() {
        return this.accessList;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setName(String name) {
        this.name = name;
        String[] parts = name.split("->");
        this.shortName = parts.length > 1 ? parts[parts.length - 1] : name;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public ObjectMenuFilter getFilters() {
        return this.filters;
    }

    public String getFiltersAsXML() {
        try {
            return this.filters.createXml();
        }
        catch (Exception e) {
            Logger.debug((String)"GraphSettings.CreateGraphSettings", (String)"Cannot create XML from ObjectMenuFilter: ", (Throwable)e);
            return "";
        }
    }

    public void setFilters(ObjectMenuFilter filters) {
        this.filters = filters;
    }

    public boolean isApplicableForNode(AbstractNode node) {
        return this.filters.isApplicableForNode(node);
    }

    public boolean isTemplate() {
        return (this.flags & 1) > 0;
    }

    @Override
    public ObjectMenuFilter getFilter() {
        return this.filters;
    }

    @Override
    public void setFilter(ObjectMenuFilter filter) {
        this.filters = filter;
    }

    @Override
    public int getType() {
        return 0;
    }
}

