/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.Severity;

public class EventProcessingPolicyRule {
    public static final int STOP_PROCESSING = 1;
    public static final int NEGATED_SOURCE = 2;
    public static final int NEGATED_EVENTS = 4;
    public static final int GENERATE_ALARM = 8;
    public static final int DISABLED = 16;
    public static final int TERMINATE_BY_REGEXP = 32;
    public static final int SEVERITY_NORMAL = 256;
    public static final int SEVERITY_WARNING = 512;
    public static final int SEVERITY_MINOR = 1024;
    public static final int SEVERITY_MAJOR = 2048;
    public static final int SEVERITY_CRITICAL = 4096;
    public static final int SEVERITY_ANY = 7936;
    private UUID guid;
    private List<Long> sources;
    private List<Long> events;
    private String script;
    private int flags;
    private String alarmKey;
    private String alarmMessage;
    private Severity alarmSeverity;
    private int alarmTimeout;
    private long alarmTimeoutEvent;
    private List<Long> alarmCategoryIds;
    private List<Long> actions;
    private long situationId;
    private String situationInstance;
    private Map<String, String> situationAttributes;
    private String comments;

    public EventProcessingPolicyRule() {
        this.guid = UUID.randomUUID();
        this.sources = new ArrayList<Long>(0);
        this.events = new ArrayList<Long>(0);
        this.script = "";
        this.flags = 7936;
        this.alarmKey = "";
        this.alarmMessage = "%m";
        this.alarmSeverity = Severity.UNKNOWN;
        this.alarmTimeout = 0;
        this.alarmTimeoutEvent = 43L;
        this.alarmCategoryIds = new ArrayList<Long>(0);
        this.actions = new ArrayList<Long>(0);
        this.situationId = 0L;
        this.situationInstance = "";
        this.situationAttributes = new HashMap<String, String>(0);
        this.comments = "";
    }

    public EventProcessingPolicyRule(EventProcessingPolicyRule src) {
        this.guid = UUID.randomUUID();
        this.sources = new ArrayList<Long>(src.sources);
        this.events = new ArrayList<Long>(src.events);
        this.script = src.script;
        this.flags = src.flags;
        this.alarmKey = src.alarmKey;
        this.alarmMessage = src.alarmMessage;
        this.alarmSeverity = src.alarmSeverity;
        this.alarmTimeout = src.alarmTimeout;
        this.alarmTimeoutEvent = src.alarmTimeoutEvent;
        this.alarmCategoryIds = src.alarmCategoryIds;
        this.actions = new ArrayList<Long>(src.actions);
        this.situationId = src.situationId;
        this.situationInstance = src.situationInstance;
        this.situationAttributes = new HashMap<String, String>(src.situationAttributes);
        this.comments = src.comments;
    }

    public EventProcessingPolicyRule(NXCPMessage msg) {
        this.guid = msg.getFieldAsUUID(222L);
        this.sources = Arrays.asList(msg.getFieldAsUInt32ArrayEx(71L));
        this.events = Arrays.asList(msg.getFieldAsUInt32ArrayEx(72L));
        this.script = msg.getFieldAsString(228L);
        this.flags = msg.getFieldAsInt32(13L);
        this.alarmKey = msg.getFieldAsString(64L);
        this.alarmMessage = msg.getFieldAsString(66L);
        this.alarmSeverity = Severity.getByValue(msg.getFieldAsInt32(63L));
        this.alarmTimeout = msg.getFieldAsInt32(65L);
        this.alarmTimeoutEvent = msg.getFieldAsInt64(283L);
        this.alarmCategoryIds = Arrays.asList(msg.getFieldAsUInt32ArrayEx(555L));
        this.actions = Arrays.asList(msg.getFieldAsUInt32ArrayEx(73L));
        this.situationId = msg.getFieldAsInt64(301L);
        this.situationInstance = msg.getFieldAsString(302L);
        this.comments = msg.getFieldAsString(82L);
        int numAttrs = msg.getFieldAsInt32(303L);
        this.situationAttributes = new HashMap<String, String>(numAttrs);
        long varId = 0x10000000L;
        for (int i = 0; i < numAttrs; ++i) {
            String attr = msg.getFieldAsString(varId++);
            String value = msg.getFieldAsString(varId++);
            this.situationAttributes.put(attr, value);
        }
    }

    public void fillMessage(NXCPMessage msg) {
        msg.setField(222L, this.guid);
        msg.setFieldInt32(13L, this.flags);
        msg.setField(82L, this.comments);
        msg.setField(228L, this.script);
        msg.setFieldInt32(70L, this.actions.size());
        msg.setField(73L, this.actions.toArray(new Long[this.actions.size()]));
        msg.setFieldInt32(69L, this.events.size());
        msg.setField(72L, this.events.toArray(new Long[this.events.size()]));
        msg.setFieldInt32(68L, this.sources.size());
        msg.setField(71L, this.sources.toArray(new Long[this.sources.size()]));
        msg.setField(64L, this.alarmKey);
        msg.setField(66L, this.alarmMessage);
        msg.setFieldInt16(63L, this.alarmSeverity.getValue());
        msg.setFieldInt32(65L, this.alarmTimeout);
        msg.setFieldInt32(283L, (int)this.alarmTimeoutEvent);
        msg.setField(555L, this.alarmCategoryIds.toArray(new Long[this.alarmCategoryIds.size()]));
        msg.setFieldInt32(301L, (int)this.situationId);
        msg.setField(302L, this.situationInstance);
        msg.setFieldInt32(303L, this.situationAttributes.size());
        long varId = 0x10000000L;
        for (Map.Entry<String, String> e : this.situationAttributes.entrySet()) {
            msg.setField(varId++, e.getKey());
            msg.setField(varId++, e.getValue());
        }
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String getAlarmKey() {
        return this.alarmKey;
    }

    public void setAlarmKey(String alarmKey) {
        this.alarmKey = alarmKey;
    }

    public String getAlarmMessage() {
        return this.alarmMessage;
    }

    public void setAlarmMessage(String alarmMessage) {
        this.alarmMessage = alarmMessage;
    }

    public Severity getAlarmSeverity() {
        return this.alarmSeverity;
    }

    public void setAlarmSeverity(Severity alarmSeverity) {
        this.alarmSeverity = alarmSeverity;
    }

    public int getAlarmTimeout() {
        return this.alarmTimeout;
    }

    public void setAlarmTimeout(int alarmTimeout) {
        this.alarmTimeout = alarmTimeout;
    }

    public long getAlarmTimeoutEvent() {
        return this.alarmTimeoutEvent;
    }

    public void setAlarmTimeoutEvent(long alarmTimeoutEvent) {
        this.alarmTimeoutEvent = alarmTimeoutEvent;
    }

    public List<Long> getAlarmCategories() {
        return this.alarmCategoryIds;
    }

    public void setAlarmCategories(List<Long> alarmCategoryIds) {
        this.alarmCategoryIds = alarmCategoryIds;
    }

    public void removeAlarmCategory(Long categoryId) {
        for (int i = 0; i < this.alarmCategoryIds.size(); ++i) {
            if (this.alarmCategoryIds.get(i) != categoryId) continue;
            this.alarmCategoryIds.remove(i);
            break;
        }
    }

    public long getSituationId() {
        return this.situationId;
    }

    public void setSituationId(long situationId) {
        this.situationId = situationId;
    }

    public String getSituationInstance() {
        return this.situationInstance;
    }

    public void setSituationInstance(String situationInstance) {
        this.situationInstance = situationInstance;
    }

    public List<Long> getSources() {
        return this.sources;
    }

    public List<Long> getEvents() {
        return this.events;
    }

    public List<Long> getActions() {
        return this.actions;
    }

    public Map<String, String> getSituationAttributes() {
        return this.situationAttributes;
    }

    public void setSources(List<Long> sources) {
        this.sources = sources;
    }

    public void setEvents(List<Long> events) {
        this.events = events;
    }

    public void setActions(List<Long> actions) {
        this.actions = actions;
    }

    public void setSituationAttributes(Map<String, String> situationAttributes) {
        this.situationAttributes = situationAttributes;
    }

    public boolean isDisabled() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isSourceInverted() {
        return (this.flags & 2) != 0;
    }

    public boolean isEventsInverted() {
        return (this.flags & 4) != 0;
    }

    public UUID getGuid() {
        return this.guid;
    }
}

