/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objecttools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.netxms.base.Logger;
import org.netxms.base.NXCPMessage;
import org.netxms.client.ObjectMenuFilter;
import org.netxms.client.objecttools.InputField;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.client.objecttools.ObjectToolTableColumn;

public class ObjectToolDetails
extends ObjectTool {
    private boolean modified = false;
    private List<Long> accessList;
    private List<ObjectToolTableColumn> columns;

    public ObjectToolDetails(long toolId, int type, String name) {
        this.id = toolId;
        this.type = type;
        this.name = name;
        this.data = "";
        this.flags = 0;
        this.description = "";
        this.filter = new ObjectMenuFilter();
        this.confirmationText = "";
        this.accessList = new ArrayList<Long>(0);
        this.columns = new ArrayList<ObjectToolTableColumn>(0);
        this.commandName = "";
        this.commandShortName = "";
        this.imageData = null;
        this.inputFields = new HashMap();
        this.createDisplayName();
    }

    public ObjectToolDetails(NXCPMessage msg) {
        this.id = msg.getFieldAsInt64(165L);
        this.name = msg.getFieldAsString(20L);
        this.type = msg.getFieldAsInt32(196L);
        this.data = msg.getFieldAsString(197L);
        this.flags = msg.getFieldAsInt32(13L);
        this.description = msg.getFieldAsString(27L);
        String filterData = msg.getFieldAsString(199L);
        this.confirmationText = msg.getFieldAsString(250L);
        this.commandName = msg.getFieldAsString(474L);
        this.commandShortName = msg.getFieldAsString(475L);
        this.imageData = msg.getFieldAsBinary(369L);
        try {
            this.filter = ObjectMenuFilter.createFromXml(filterData);
        }
        catch (Exception e) {
            this.filter = new ObjectMenuFilter();
            Logger.debug((String)"ObjectToolDetails.ObjectToolDetails", (String)"Failed to convert object tool filter to string");
        }
        Long[] acl = msg.getFieldAsUInt32ArrayEx(198L);
        this.accessList = acl != null ? new ArrayList<Long>(Arrays.asList(acl)) : new ArrayList(0);
        int count = msg.getFieldAsInt32(166L);
        this.columns = new ArrayList<ObjectToolTableColumn>(count);
        long varId = 0x10000000L;
        for (int i = 0; i < count; ++i) {
            this.columns.add(new ObjectToolTableColumn(msg, varId));
            varId += 4L;
        }
        count = msg.getFieldAsInt32(507L);
        this.inputFields = new HashMap(count);
        long fieldId = 0x70000000L;
        for (int i = 0; i < count; ++i) {
            InputField f = new InputField(msg, fieldId);
            this.inputFields.put(f.getName(), f);
            fieldId += 10L;
        }
        if (this.type == 1 || this.type == 7 || this.type == 5 || this.type == 6 || this.type == 4) {
            this.validateInputFields();
        }
        this.createDisplayName();
    }

    public void fillMessage(NXCPMessage msg) {
        String filterData;
        try {
            filterData = this.filter.createXml();
        }
        catch (Exception e) {
            filterData = "";
            Logger.debug((String)"ObjectTool.ObjectTool", (String)"Failed to convert object tool filter to XML");
        }
        msg.setFieldInt32(165L, (int)this.id);
        msg.setField(20L, this.name);
        msg.setField(27L, this.description);
        msg.setField(199L, filterData);
        msg.setField(250L, this.confirmationText);
        msg.setField(197L, this.data);
        msg.setFieldInt16(196L, this.type);
        msg.setFieldInt32(13L, this.flags);
        msg.setField(474L, this.commandName);
        msg.setField(475L, this.commandShortName);
        if (this.imageData != null) {
            msg.setField(369L, this.imageData);
        }
        msg.setFieldInt32(32L, this.accessList.size());
        msg.setField(198L, this.accessList.toArray(new Long[this.accessList.size()]));
        msg.setFieldInt16(166L, this.columns.size());
        long fieldId = 0x10000000L;
        for (int i = 0; i < this.columns.size(); ++i) {
            ObjectToolTableColumn c = this.columns.get(i);
            msg.setField(fieldId++, c.getName());
            msg.setField(fieldId++, c.getSnmpOid());
            msg.setFieldInt16(fieldId++, c.getFormat());
            msg.setFieldInt16(fieldId++, c.getSubstringIndex());
        }
        msg.setFieldInt16(507L, this.inputFields.size());
        fieldId = 0x70000000L;
        for (InputField f : this.inputFields.values()) {
            f.fillMessage(msg, fieldId);
            fieldId += 10L;
        }
    }

    public List<Long> getAccessList() {
        return this.accessList;
    }

    public List<ObjectToolTableColumn> getColumns() {
        return this.columns;
    }

    public void addInputField(InputField f) {
        this.inputFields.put(f.getName(), f);
        this.modified = true;
    }

    public void setInputFields(Collection<InputField> fields) {
        this.inputFields.clear();
        for (InputField f : fields) {
            this.inputFields.put(f.getName(), f);
        }
        this.modified = true;
    }

    public void setId(long id) {
        this.id = id;
        this.modified = true;
    }

    public void setName(String name) {
        this.name = name;
        this.createDisplayName();
        this.modified = true;
    }

    public void setType(int type) {
        this.type = type;
        this.modified = true;
    }

    public void setFlags(int flags) {
        this.flags = flags;
        this.modified = true;
    }

    public void setDescription(String description) {
        this.description = description;
        this.modified = true;
    }

    public void setData(String data) {
        this.data = data;
        this.modified = true;
    }

    public void setConfirmationText(String confirmationText) {
        this.confirmationText = confirmationText;
        this.modified = true;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setAccessList(List<Long> accessList) {
        this.accessList = accessList;
        this.modified = true;
    }

    public void setColumns(List<ObjectToolTableColumn> columns) {
        this.columns = columns;
        this.modified = true;
    }

    public void setCommandName(String commandName) {
        this.commandName = commandName;
        this.modified = true;
    }

    public void setCommandShortName(String commandShortName) {
        this.commandShortName = commandShortName;
        this.modified = true;
    }

    public void setImageData(byte[] imageData) {
        this.imageData = imageData;
        this.modified = true;
    }
}

