/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.net.InetAddress;
import org.netxms.base.InetAddressEx;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;

public class Subnet
extends GenericObject {
    private long zoneId;
    private InetAddressEx networkAddress;

    public Subnet(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        this.zoneId = msg.getFieldAsInt64(147L);
        this.networkAddress = msg.getFieldAsInetAddressEx(8L);
    }

    public InetAddressEx getNetworkAddress() {
        return this.networkAddress;
    }

    public InetAddress getSubnetAddress() {
        return this.networkAddress.getAddress();
    }

    public int getSubnetMask() {
        return this.networkAddress.getMask();
    }

    @Override
    public String getObjectClassName() {
        return "Subnet";
    }

    @Override
    public boolean isAllowedOnMap() {
        return true;
    }

    @Override
    public boolean isAlarmsVisible() {
        return true;
    }

    public long getZoneId() {
        return this.zoneId;
    }
}

