/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.propertypages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.events.EventTemplate;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.ThresholdLabelProvider;
import org.netxms.ui.eclipse.datacollection.api.DataCollectionObjectEditor;
import org.netxms.ui.eclipse.datacollection.dialogs.EditThresholdDialog;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class Thresholds
extends PropertyPage {
    public static final int COLUMN_OPERATION = 0;
    public static final int COLUMN_EVENT = 1;
    private static final String COLUMN_SETTINGS_PREFIX = "Thresholds.ThresholdList";
    private DataCollectionObjectEditor editor;
    private DataCollectionItem dci;
    private List<Threshold> thresholds;
    private LabeledText instance;
    private Button checkAllThresholds;
    private TableViewer thresholdList;
    private Button addButton;
    private Button modifyButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;

    protected Control createContents(Composite parent) {
        Platform.getAdapterManager().loadAdapter((Object)new EventTemplate(0L), "org.eclipse.ui.model.IWorkbenchAdapter");
        this.editor = (DataCollectionObjectEditor)this.getElement().getAdapter(DataCollectionObjectEditor.class);
        this.dci = this.editor.getObjectAsItem();
        this.thresholds = new ArrayList<Threshold>(this.dci.getThresholds().size());
        for (Threshold t : this.dci.getThresholds()) {
            this.thresholds.add(new Threshold(t));
        }
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.instance = new LabeledText(dialogArea, 0);
        Messages.get();
        this.instance.setLabel(Messages.Thresholds_Instance);
        this.instance.setText(this.dci.getInstance());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.instance.setLayoutData((Object)gd);
        if (this.dci.getTemplateId() == this.dci.getNodeId()) {
            this.instance.getTextControl().setEditable(false);
        }
        this.checkAllThresholds = new Button(dialogArea, 32);
        Messages.get();
        this.checkAllThresholds.setText(Messages.Thresholds_ProcessAll);
        this.checkAllThresholds.setSelection(this.dci.isProcessAllThresholds());
        Composite thresholdArea = new Composite(dialogArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        thresholdArea.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        thresholdArea.setLayout((Layout)layout);
        Label label = new Label(thresholdArea, 0);
        Messages.get();
        label.setText(Messages.Thresholds_Thresholds);
        this.thresholdList = new TableViewer(thresholdArea, 68354);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        this.thresholdList.getControl().setLayoutData((Object)gd);
        this.setupThresholdList();
        this.thresholdList.setInput((Object)this.thresholds.toArray());
        Composite leftButtons = new Composite(thresholdArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        leftButtons.setLayoutData((Object)gd);
        RowLayout buttonsLayout = new RowLayout(256);
        buttonsLayout.marginBottom = 0;
        buttonsLayout.marginLeft = 0;
        buttonsLayout.marginRight = 0;
        buttonsLayout.marginTop = 0;
        buttonsLayout.spacing = 4;
        buttonsLayout.fill = true;
        buttonsLayout.pack = false;
        leftButtons.setLayout((Layout)buttonsLayout);
        this.upButton = new Button(leftButtons, 8);
        Messages.get();
        this.upButton.setText(Messages.Thresholds_Up);
        this.upButton.setEnabled(false);
        this.upButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Thresholds.this.moveUp();
            }
        });
        this.downButton = new Button(leftButtons, 8);
        Messages.get();
        this.downButton.setText(Messages.Thresholds_Down);
        this.downButton.setEnabled(false);
        this.downButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Thresholds.this.moveDown();
            }
        });
        Composite buttons = new Composite(thresholdArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gd);
        buttonsLayout = new RowLayout(256);
        buttonsLayout.marginBottom = 0;
        buttonsLayout.marginLeft = 0;
        buttonsLayout.marginRight = 0;
        buttonsLayout.marginTop = 0;
        buttonsLayout.spacing = 4;
        buttonsLayout.fill = true;
        buttonsLayout.pack = false;
        buttons.setLayout((Layout)buttonsLayout);
        this.addButton = new Button(buttons, 8);
        Messages.get();
        this.addButton.setText(Messages.Thresholds_Add);
        RowData rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Thresholds.this.addThreshold();
            }
        });
        this.modifyButton = new Button(buttons, 8);
        Messages.get();
        this.modifyButton.setText(Messages.Thresholds_Edit);
        rd = new RowData();
        rd.width = 90;
        this.modifyButton.setLayoutData((Object)rd);
        this.modifyButton.setEnabled(false);
        this.modifyButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Thresholds.this.editThreshold();
            }
        });
        this.deleteButton = new Button(buttons, 8);
        Messages.get();
        this.deleteButton.setText(Messages.Thresholds_Delete);
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Thresholds.this.deleteThresholds();
            }
        });
        this.thresholdList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                int index = Thresholds.this.thresholds.indexOf(selection.getFirstElement());
                Thresholds.this.upButton.setEnabled(selection.size() == 1 && index > 0);
                Thresholds.this.downButton.setEnabled(selection.size() == 1 && index >= 0 && index < Thresholds.this.thresholds.size() - 1);
                Thresholds.this.modifyButton.setEnabled(selection.size() == 1);
                Thresholds.this.deleteButton.setEnabled(selection.size() > 0);
            }
        });
        this.thresholdList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Thresholds.this.editThreshold();
            }
        });
        return dialogArea;
    }

    private void deleteThresholds() {
        IStructuredSelection selection = (IStructuredSelection)this.thresholdList.getSelection();
        if (!selection.isEmpty()) {
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                this.thresholds.remove(it.next());
            }
            this.thresholdList.setInput((Object)this.thresholds.toArray());
        }
    }

    private void editThreshold() {
        IStructuredSelection selection = (IStructuredSelection)this.thresholdList.getSelection();
        if (selection.size() == 1) {
            Threshold threshold = (Threshold)selection.getFirstElement();
            EditThresholdDialog dlg = new EditThresholdDialog(this.getShell(), threshold);
            if (dlg.open() == 0) {
                this.thresholdList.update((Object)threshold, null);
            }
        }
    }

    private void addThreshold() {
        Threshold threshold = new Threshold();
        EditThresholdDialog dlg = new EditThresholdDialog(this.getShell(), threshold);
        if (dlg.open() == 0) {
            this.thresholds.add(threshold);
            this.thresholdList.setInput((Object)this.thresholds.toArray());
            this.thresholdList.setSelection((ISelection)new StructuredSelection((Object)threshold));
        }
    }

    private void moveUp() {
        Threshold threshold;
        int index;
        IStructuredSelection selection = (IStructuredSelection)this.thresholdList.getSelection();
        if (selection.size() == 1 && (index = this.thresholds.indexOf(threshold = (Threshold)selection.getFirstElement())) > 0) {
            Collections.swap(this.thresholds, index - 1, index);
            this.thresholdList.setInput((Object)this.thresholds.toArray());
            this.thresholdList.setSelection((ISelection)new StructuredSelection((Object)threshold));
        }
    }

    private void moveDown() {
        Threshold threshold;
        int index;
        IStructuredSelection selection = (IStructuredSelection)this.thresholdList.getSelection();
        if (selection.size() == 1 && (index = this.thresholds.indexOf(threshold = (Threshold)selection.getFirstElement())) < this.thresholds.size() - 1 && index >= 0) {
            Collections.swap(this.thresholds, index + 1, index);
            this.thresholdList.setInput((Object)this.thresholds.toArray());
            this.thresholdList.setSelection((ISelection)new StructuredSelection((Object)threshold));
        }
    }

    private void setupThresholdList() {
        Table table = this.thresholdList.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 16384);
        Messages.get();
        column.setText(Messages.Thresholds_Expression);
        column.setWidth(200);
        column = new TableColumn(table, 16384);
        Messages.get();
        column.setText(Messages.Thresholds_Event);
        column.setWidth(150);
        WidgetHelper.restoreColumnSettings((Table)table, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)COLUMN_SETTINGS_PREFIX);
        this.thresholdList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.thresholdList.setLabelProvider((IBaseLabelProvider)new ThresholdLabelProvider());
    }

    protected void performApply() {
        this.saveSettings();
        this.applyChanges(true);
    }

    public boolean performOk() {
        this.saveSettings();
        this.applyChanges(false);
        return true;
    }

    protected void applyChanges(boolean isApply) {
        this.dci.setInstance(this.instance.getText());
        this.dci.setProcessAllThresholds(this.checkAllThresholds.getSelection());
        this.dci.getThresholds().clear();
        this.dci.getThresholds().addAll(this.thresholds);
        this.editor.modify();
    }

    public boolean performCancel() {
        this.saveSettings();
        return true;
    }

    private void saveSettings() {
        WidgetHelper.saveColumnSettings((Table)this.thresholdList.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)COLUMN_SETTINGS_PREFIX);
    }
}

