/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.ui.eclipse.actions.ExportToCsvAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.api.DciOpenHandler;
import org.netxms.ui.eclipse.datacollection.widgets.internal.LastValuesComparator;
import org.netxms.ui.eclipse.datacollection.widgets.internal.LastValuesFilter;
import org.netxms.ui.eclipse.datacollection.widgets.internal.LastValuesLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ViewRefreshController;
import org.netxms.ui.eclipse.tools.VisibilityValidator;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.CompositeWithMessageBar;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class LastValuesWidget
extends CompositeWithMessageBar {
    public static final String JOB_FAMILY = "LastValuesViewJob";
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_DESCRIPTION = 1;
    public static final int COLUMN_VALUE = 2;
    public static final int COLUMN_TIMESTAMP = 3;
    public static final int COLUMN_THRESHOLD = 4;
    private final ViewPart viewPart;
    private DataCollectionTarget dcTarget;
    private NXCSession session;
    private SessionListener clientListener = null;
    private boolean filterEnabled = true;
    private FilterText filterText;
    private SortableTableViewer dataViewer;
    private LastValuesLabelProvider labelProvider;
    private LastValuesComparator comparator;
    private LastValuesFilter filter;
    private boolean autoRefreshEnabled = false;
    private int autoRefreshInterval = 30;
    private ViewRefreshController refreshController;
    private Action actionUseMultipliers;
    private Action actionShowErrors;
    private Action actionShowDisabled;
    private Action actionShowUnsupported;
    private Action actionExportToCsv;
    private Action actionCopyToClipboard;
    private Action actionCopyDciName;
    private List<OpenHandlerData> openHandlers = new ArrayList<OpenHandlerData>(0);

    public LastValuesWidget(ViewPart viewPart, Composite parent, int style, final AbstractObject dcTarget, final String configPrefix, VisibilityValidator validator) {
        super(parent, style);
        this.session = ConsoleSharedData.getSession();
        this.viewPart = viewPart;
        this.setDataCollectionTarget(dcTarget);
        this.registerOpenHandlers();
        final IDialogSettings ds = Activator.getDefault().getDialogSettings();
        this.refreshController = new ViewRefreshController((IViewPart)viewPart, -1, new Runnable(){

            @Override
            public void run() {
                if (LastValuesWidget.this.isDisposed()) {
                    return;
                }
                LastValuesWidget.this.getDataFromServer();
            }
        }, validator);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LastValuesWidget.this.refreshController.dispose();
            }
        });
        this.getContent().setLayout((Layout)new FormLayout());
        this.filterText = new FilterText(this.getContent(), 0);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LastValuesWidget.this.onFilterModify();
            }
        });
        this.filterText.setCloseAction(new Action(){

            public void run() {
                LastValuesWidget.this.enableFilter(false);
            }
        });
        String[] stringArray = new String[5];
        Messages.get();
        stringArray[0] = Messages.LastValuesWidget_ColID;
        Messages.get();
        stringArray[1] = Messages.LastValuesWidget_ColDescr;
        Messages.get();
        stringArray[2] = Messages.LastValuesWidget_ColValue;
        Messages.get();
        stringArray[3] = Messages.LastValuesWidget_ColTime;
        Messages.get();
        stringArray[4] = Messages.LastValuesWidget_ColThreshold;
        String[] names = stringArray;
        int[] widths = new int[]{70, 250, 150, 120, 150};
        this.dataViewer = new SortableTableViewer(this.getContent(), names, widths, 0, 1024, -1);
        this.labelProvider = new LastValuesLabelProvider();
        this.comparator = new LastValuesComparator();
        this.filter = new LastValuesFilter();
        this.dataViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.dataViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.dataViewer.setComparator((ViewerComparator)this.comparator);
        this.dataViewer.addFilter((ViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.dataViewer, (IDialogSettings)ds, (String)configPrefix);
        this.dataViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)LastValuesWidget.this.dataViewer.getSelection();
                if (selection.size() == 1) {
                    LastValuesWidget.this.callOpenObjectHandler((DciValue)selection.getFirstElement());
                }
            }
        });
        this.dataViewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)LastValuesWidget.this.dataViewer, (IDialogSettings)ds, (String)configPrefix);
                ds.put(String.valueOf(configPrefix) + ".autoRefresh", LastValuesWidget.this.autoRefreshEnabled);
                ds.put(String.valueOf(configPrefix) + ".autoRefreshInterval", LastValuesWidget.this.autoRefreshEnabled);
                ds.put(String.valueOf(configPrefix) + ".useMultipliers", LastValuesWidget.this.labelProvider.areMultipliersUsed());
                ds.put(String.valueOf(configPrefix) + ".showErrors", LastValuesWidget.this.isShowErrors());
                ds.put(String.valueOf(configPrefix) + ".showDisabled", LastValuesWidget.this.isShowDisabled());
                ds.put(String.valueOf(configPrefix) + ".showUnsupported", LastValuesWidget.this.isShowUnsupported());
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.dataViewer.getTable().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        try {
            this.autoRefreshInterval = ds.getInt(String.valueOf(configPrefix) + ".autoRefreshInterval");
            if (this.autoRefreshInterval >= 1000) {
                this.autoRefreshInterval /= 1000;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        this.setAutoRefreshEnabled(ds.getBoolean(String.valueOf(configPrefix) + ".autoRefresh"));
        if (ds.get(String.valueOf(configPrefix) + ".useMultipliers") != null) {
            this.labelProvider.setUseMultipliers(ds.getBoolean(String.valueOf(configPrefix) + ".useMultipliers"));
        } else {
            this.labelProvider.setUseMultipliers(true);
        }
        if (ds.get(String.valueOf(configPrefix) + ".showErrors") != null) {
            this.labelProvider.setShowErrors(ds.getBoolean(String.valueOf(configPrefix) + ".showErrors"));
            this.comparator.setShowErrors(ds.getBoolean(String.valueOf(configPrefix) + ".showErrors"));
        } else {
            this.labelProvider.setShowErrors(true);
            this.comparator.setShowErrors(true);
        }
        this.filter.setShowDisabled(ds.getBoolean(String.valueOf(configPrefix) + ".showDisabled"));
        this.filter.setShowUnsupported(ds.getBoolean(String.valueOf(configPrefix) + ".showUnsupported"));
        this.createActions();
        this.createPopupMenu();
        if (validator == null || validator.isVisible()) {
            this.getDataFromServer();
        }
        if (this.filterEnabled) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.clientListener = new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                if (n.getCode() == 1034 && n.getSubCode() == dcTarget.getObjectId()) {
                    LastValuesWidget.this.refresh();
                }
            }
        };
        this.session.addListener(this.clientListener);
    }

    private void createActions() {
        Messages.get();
        this.actionUseMultipliers = new Action(Messages.LastValuesWidget_UseMultipliers, 2){

            public void run() {
                LastValuesWidget.this.setUseMultipliers(LastValuesWidget.this.actionUseMultipliers.isChecked());
            }
        };
        this.actionUseMultipliers.setChecked(this.areMultipliersUsed());
        Messages.get();
        this.actionShowErrors = new Action(Messages.LastValuesWidget_ShowErrors, 2){

            public void run() {
                LastValuesWidget.this.setShowErrors(LastValuesWidget.this.actionShowErrors.isChecked());
            }
        };
        this.actionShowErrors.setChecked(this.isShowErrors());
        Messages.get();
        this.actionShowUnsupported = new Action(Messages.LastValuesWidget_ShowUnsupported, 2){

            public void run() {
                LastValuesWidget.this.setShowUnsupported(LastValuesWidget.this.actionShowUnsupported.isChecked());
            }
        };
        this.actionShowUnsupported.setChecked(this.isShowUnsupported());
        Messages.get();
        this.actionShowDisabled = new Action(Messages.LastValuesWidget_ShowDisabled, 2){

            public void run() {
                LastValuesWidget.this.setShowDisabled(LastValuesWidget.this.actionShowDisabled.isChecked());
            }
        };
        this.actionShowDisabled.setChecked(this.isShowDisabled());
        this.actionExportToCsv = new ExportToCsvAction((IViewPart)this.viewPart, (ColumnViewer)this.dataViewer, true);
        Messages.get();
        this.actionCopyToClipboard = new Action(Messages.LastValuesWidget_CopyToClipboard, SharedIcons.COPY){

            public void run() {
                LastValuesWidget.this.copySelection();
            }
        };
        this.actionCopyDciName = new Action("Copy DCI Name", SharedIcons.COPY){

            public void run() {
                LastValuesWidget.this.copySelectionDciName();
            }
        };
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                LastValuesWidget.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.dataViewer.getControl());
        this.dataViewer.getControl().setMenu(menu);
        if (this.viewPart != null) {
            this.viewPart.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.dataViewer);
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionCopyToClipboard);
        manager.add((IAction)this.actionCopyDciName);
        manager.add((IAction)this.actionExportToCsv);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("secondary"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionUseMultipliers);
        manager.add((IAction)this.actionShowErrors);
        manager.add((IAction)this.actionShowDisabled);
        manager.add((IAction)this.actionShowUnsupported);
    }

    private void getDataFromServer() {
        if (this.dcTarget == null) {
            this.dataViewer.setInput((Object)new DciValue[0]);
            return;
        }
        Messages.get();
        ConsoleJob job = new ConsoleJob(String.valueOf(Messages.LastValuesWidget_JobTitle) + this.dcTarget.getObjectName(), (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.datacollection", JOB_FAMILY){

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.LastValuesWidget_JobError, LastValuesWidget.this.dcTarget != null ? LastValuesWidget.this.dcTarget.getObjectName() : null);
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                try {
                    final DciValue[] data = LastValuesWidget.this.session.getLastValues(LastValuesWidget.this.dcTarget.getObjectId());
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (!LastValuesWidget.this.isDisposed()) {
                                LastValuesWidget.this.dataViewer.setInput((Object)data);
                                LastValuesWidget.this.hideMessage();
                            }
                        }
                    });
                }
                catch (Exception e) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (!LastValuesWidget.this.isDisposed()) {
                                LastValuesWidget.this.showMessage(2, String.format("Cannot read data from server: %s", e.getLocalizedMessage()));
                            }
                        }
                    });
                }
            }
        };
        job.setUser(false);
        job.start();
    }

    public void setDataCollectionTarget(AbstractObject dcTarget) {
        this.dcTarget = dcTarget instanceof DataCollectionTarget ? (DataCollectionTarget)dcTarget : null;
    }

    public void refresh() {
        this.getDataFromServer();
    }

    public boolean isAutoRefreshEnabled() {
        return this.autoRefreshEnabled;
    }

    public void setAutoRefreshEnabled(boolean autoRefreshEnabled) {
        this.autoRefreshEnabled = autoRefreshEnabled;
        this.refreshController.setInterval(autoRefreshEnabled ? this.autoRefreshInterval : -1);
    }

    public int getAutoRefreshInterval() {
        return this.autoRefreshInterval;
    }

    public void setAutoRefreshInterval(int autoRefreshInterval) {
        this.autoRefreshInterval = autoRefreshInterval;
    }

    public boolean areMultipliersUsed() {
        return this.labelProvider != null ? this.labelProvider.areMultipliersUsed() : false;
    }

    public void setUseMultipliers(boolean useMultipliers) {
        if (this.labelProvider != null) {
            this.labelProvider.setUseMultipliers(useMultipliers);
            if (this.dataViewer != null) {
                this.dataViewer.refresh(true);
            }
        }
    }

    public void enableFilter(boolean enable) {
        this.filterEnabled = enable;
        this.filterText.setVisible(this.filterEnabled);
        FormData fd = (FormData)this.dataViewer.getTable().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        this.getContent().layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.setFilter("");
        }
    }

    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    public void setFilter(String text) {
        this.filterText.setText(text);
        this.onFilterModify();
    }

    private void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.dataViewer.refresh(false);
    }

    public void setFilterCloseAction(Action action) {
        this.filterText.setCloseAction(action);
    }

    public boolean isShowErrors() {
        return this.labelProvider != null ? this.labelProvider.isShowErrors() : false;
    }

    public void setShowErrors(boolean show) {
        this.labelProvider.setShowErrors(show);
        this.comparator.setShowErrors(show);
        if (this.dataViewer != null) {
            this.dataViewer.refresh(true);
        }
    }

    public boolean isShowDisabled() {
        return this.filter != null ? this.filter.isShowDisabled() : false;
    }

    public void setShowDisabled(boolean show) {
        this.filter.setShowDisabled(show);
        if (this.dataViewer != null) {
            this.dataViewer.refresh(true);
        }
    }

    public boolean isShowUnsupported() {
        return this.filter != null ? this.filter.isShowUnsupported() : false;
    }

    public void setShowUnsupported(boolean show) {
        this.filter.setShowUnsupported(show);
        if (this.dataViewer != null) {
            this.dataViewer.refresh(true);
        }
    }

    public Action getActionUseMultipliers() {
        return this.actionUseMultipliers;
    }

    private void registerOpenHandlers() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("org.netxms.ui.eclipse.datacollection.dciOpenHandlers");
        int i = 0;
        while (i < elements.length) {
            try {
                OpenHandlerData h = new OpenHandlerData();
                h.handler = (DciOpenHandler)elements[i].createExecutableExtension("class");
                h.priority = LastValuesWidget.safeParseInt(elements[i].getAttribute("priority"));
                this.openHandlers.add(h);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
        Collections.sort(this.openHandlers, new Comparator<OpenHandlerData>(){

            @Override
            public int compare(OpenHandlerData arg0, OpenHandlerData arg1) {
                return arg0.priority - arg1.priority;
            }
        });
    }

    private static int safeParseInt(String s) {
        if (s == null) {
            return 65535;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return 65535;
        }
    }

    private boolean callOpenObjectHandler(DciValue object) {
        for (OpenHandlerData h : this.openHandlers) {
            if (!h.handler.open(object)) continue;
            return true;
        }
        return false;
    }

    private void copySelection() {
        IStructuredSelection selection = (IStructuredSelection)this.dataViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        String nl = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        for (Object o : selection.toList()) {
            if (sb.length() > 0) {
                sb.append(nl);
            }
            DciValue v = (DciValue)o;
            sb.append(v.getDescription());
            sb.append(" = ");
            sb.append(v.getValue());
        }
        if (selection.size() > 1) {
            sb.append(nl);
        }
        WidgetHelper.copyToClipboard((String)sb.toString());
    }

    private void copySelectionDciName() {
        IStructuredSelection selection = (IStructuredSelection)this.dataViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        StringBuilder dciName = new StringBuilder();
        for (Object o : selection.toList()) {
            if (dciName.length() > 0) {
                dciName.append(' ');
            }
            DciValue v = (DciValue)o;
            dciName.append(v.getName());
        }
        WidgetHelper.copyToClipboard((String)dciName.toString());
    }

    private class OpenHandlerData {
        DciOpenHandler handler;
        int priority;

        private OpenHandlerData() {
        }
    }
}

