/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.widgets.helpers;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netxms.ui.eclipse.serverconfig.widgets.helpers.LogParserFile;
import org.netxms.ui.eclipse.serverconfig.widgets.helpers.LogParserRule;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;

@Root(name="parser", strict=false)
public class LogParser {
    public static int PARSER_SYSLOG = 0;
    public static int PARSER_OTHER = 1;
    @Attribute(required=false)
    private String processALL = null;
    @Attribute(required=false)
    private Integer trace = null;
    @Element(required=false)
    private LogParserFile file = new LogParserFile();
    @ElementList(required=false)
    private ArrayList<LogParserRule> rules = new ArrayList(0);
    @ElementMap(entry="macro", key="name", attribute=true, required=false)
    private HashMap<String, String> macros = new HashMap(0);
    private boolean isSyslogParser;

    public static LogParser createFromXml(String xml) throws Exception {
        Persister serializer = new Persister();
        return (LogParser)serializer.read(LogParser.class, xml);
    }

    public String createXml() throws Exception {
        Persister serializer = new Persister();
        StringWriter writer = new StringWriter();
        serializer.write((Object)this, (Writer)writer);
        return ((Object)writer).toString();
    }

    public boolean isSyslogParser() {
        return this.isSyslogParser;
    }

    public void setSyslogParser(boolean isSyslogParser) {
        this.isSyslogParser = isSyslogParser;
        if (isSyslogParser) {
            this.file.setFile(null);
            this.file.setEncoding(null);
        }
        for (LogParserRule rule : this.rules) {
            rule.updateFieldsCorrectly(isSyslogParser);
        }
    }

    public String getFile() {
        return this.file.getFile();
    }

    public void setFile(String file) {
        this.file.setFile(file);
    }

    public String getEncoding() {
        return this.file.getEncoding();
    }

    public void setEncoding(String encoding) {
        this.file.setEncoding(encoding);
    }

    public Integer getTrace() {
        return this.trace;
    }

    public void setTrace(Integer trace) {
        this.trace = trace;
    }

    public boolean getProcessALL() {
        return LogParser.stringToBoolean(this.processALL);
    }

    public void setProcessALL(boolean processALL) {
        this.processALL = LogParser.booleanToString(processALL);
    }

    public List<LogParserRule> getRules() {
        return this.rules;
    }

    public Map<String, String> getMacros() {
        return this.macros;
    }

    public static boolean stringToBoolean(String value) {
        block4: {
            if (value != null) {
                try {
                    if (Integer.parseInt(value) > 0) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("yes")) break block4;
                    return true;
                }
            }
        }
        return false;
    }

    public static String booleanToString(boolean value) {
        return value ? "true" : null;
    }

    public static String integerToString(Integer value) {
        return value == null ? "" : Integer.toString(value);
    }
}

