/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Line;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.constants.Severity;
import org.netxms.client.events.Alarm;
import org.netxms.client.events.BulkAlarmStateChangeData;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.alarmviewer.Activator;
import org.netxms.ui.eclipse.alarmviewer.Messages;
import org.netxms.ui.eclipse.alarmviewer.dialogs.AlarmReminderDialog;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class AlarmNotifier {
    public static final String[] SEVERITY_TEXT = new String[]{"NORMAL", "WARNING", "MINOR", "MAJOR", "CRITICAL"};
    private static SessionListener listener = null;
    private static Map<Long, Integer> alarmStates = new HashMap<Long, Integer>();
    private static int outstandingAlarms = 0;
    private static long lastReminderTime = 0L;
    private static NXCSession session;
    private static IPreferenceStore ps;
    private static URL workspaceUrl;

    public static void init(NXCSession session) {
        AlarmNotifier.session = session;
        ps = Activator.getDefault().getPreferenceStore();
        workspaceUrl = Platform.getInstanceLocation().getURL();
        AlarmNotifier.checkSounds();
        lastReminderTime = System.currentTimeMillis();
        try {
            HashMap alarms = session.getAlarms();
            for (Alarm a : alarms.values()) {
                alarmStates.put(a.getId(), a.getState());
                if (a.getState() != 0) continue;
                ++outstandingAlarms;
            }
        }
        catch (Exception exception) {}
        listener = new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                block9: {
                    block10: {
                        block8: {
                            if (n.getCode() != 1004 && n.getCode() != 1005) break block8;
                            AlarmNotifier.processNewAlarm((Alarm)n.getObject());
                            break block9;
                        }
                        if (n.getCode() != 1011 && n.getCode() != 1003) break block10;
                        Alarm a = (Alarm)n.getObject();
                        Integer state = (Integer)alarmStates.get(a.getId());
                        if (state == null) break block9;
                        if (state == 0) {
                            outstandingAlarms = outstandingAlarms - 1;
                        }
                        alarmStates.remove(a.getId());
                        break block9;
                    }
                    if (n.getCode() == 1033) {
                        BulkAlarmStateChangeData d = (BulkAlarmStateChangeData)n.getObject();
                        for (Long id : d.getAlarms()) {
                            Integer state = (Integer)alarmStates.get(id);
                            if (state != null && state == 0) {
                                outstandingAlarms = outstandingAlarms - 1;
                            }
                            alarmStates.put(id, 2);
                        }
                    } else if (n.getCode() == 1032) {
                        BulkAlarmStateChangeData d = (BulkAlarmStateChangeData)n.getObject();
                        for (Long id : d.getAlarms()) {
                            Integer state = (Integer)alarmStates.get(id);
                            if (state == null) continue;
                            if (state == 0) {
                                outstandingAlarms = outstandingAlarms - 1;
                            }
                            alarmStates.remove(id);
                        }
                    }
                }
            }
        };
        session.addListener(listener);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
                    long currTime = System.currentTimeMillis();
                    if (!ps.getBoolean("OUTSTANDING_ALARMS_REMINDER") || outstandingAlarms <= 0 || lastReminderTime + 300000L > currTime) continue;
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            AlarmReminderDialog dlg = new AlarmReminderDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                            dlg.open();
                        }
                    });
                    lastReminderTime = currTime;
                }
            }
        }, "AlarmReminderThread");
        thread.setDaemon(true);
        thread.start();
    }

    private static void checkSounds() {
        int i = 0;
        while (i < 5) {
            AlarmNotifier.getSoundAndDownloadIfRequired(SEVERITY_TEXT[i]);
            ++i;
        }
    }

    private static String getSoundAndDownloadIfRequired(String severity) {
        String soundName;
        block12: {
            soundName = ps.getString("ALARM_NOTIFIER.MELODY." + severity);
            if (!AlarmNotifier.isSoundExist(soundName, workspaceUrl)) {
                try {
                    File fileContent = session.downloadFileFromServer(soundName);
                    if (fileContent == null) break block12;
                    FileInputStream src = null;
                    FileOutputStream dest = null;
                    try {
                        try {
                            src = new FileInputStream(fileContent);
                            File f = new File(workspaceUrl.getPath(), soundName);
                            f.createNewFile();
                            dest = new FileOutputStream(f);
                            FileChannel fcSrc = src.getChannel();
                            dest.getChannel().transferFrom(fcSrc, 0L, fcSrc.size());
                        }
                        catch (IOException e) {
                            Activator.logError("Cannot copy sound file", e);
                            if (src != null) {
                                src.close();
                            }
                            if (dest != null) {
                                dest.close();
                            }
                        }
                    }
                    finally {
                        if (src != null) {
                            src.close();
                        }
                        if (dest != null) {
                            dest.close();
                        }
                    }
                }
                catch (Exception e) {
                    soundName = "";
                    ps.setValue("ALARM_NOTIFIER.MELODY." + severity, "");
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Shell shell = Display.getDefault().getActiveShell();
                            Messages.get();
                            Messages.get();
                            MessageDialogHelper.openError((Shell)shell, (String)Messages.AlarmNotifier_ErrorMelodynotExists, (String)(String.valueOf(Messages.AlarmNotifier_ErrorMelodyNotExistsDescription) + e.getLocalizedMessage()));
                        }
                    });
                }
            }
        }
        return soundName;
    }

    private static boolean isSoundExist(String name, URL workspaceUrl) {
        if (!name.isEmpty() && workspaceUrl != null) {
            File f = new File(workspaceUrl.getPath(), name);
            return f.isFile();
        }
        return true;
    }

    public static void stop() {
        NXCSession session = ConsoleSharedData.getSession();
        if (session != null && listener != null) {
            session.removeListener(listener);
        }
    }

    private static void processNewAlarm(final Alarm alarm) {
        String fileName;
        Integer state = alarmStates.get(alarm.getId());
        if (state != null && state == 0) {
            --outstandingAlarms;
        }
        alarmStates.put(alarm.getId(), alarm.getState());
        if (alarm.getState() != 0) {
            return;
        }
        try {
            fileName = AlarmNotifier.getSoundAndDownloadIfRequired(SEVERITY_TEXT[alarm.getCurrentSeverity().getValue()]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Activator.logError("Invalid alarm severity", e);
            fileName = null;
        }
        if (fileName != null && !fileName.isEmpty()) {
            try {
                Clip sound = (Clip)AudioSystem.getLine(new Line.Info(Clip.class));
                sound.open(AudioSystem.getAudioInputStream(new File(workspaceUrl.getPath(), fileName).getAbsoluteFile()));
                sound.start();
                while (!sound.isRunning()) {
                    Thread.sleep(10L);
                }
                while (sound.isRunning()) {
                    Thread.sleep(10L);
                }
                sound.close();
            }
            catch (Exception e) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = Display.getDefault().getActiveShell();
                        Messages.get();
                        Messages.get();
                        MessageDialogHelper.openError((Shell)shell, (String)Messages.AlarmNotifier_ErrorPlayingSound, (String)(String.valueOf(Messages.AlarmNotifier_ErrorPlayingSoundDescription) + e.getMessage()));
                    }
                });
            }
        }
        if (outstandingAlarms == 0) {
            lastReminderTime = System.currentTimeMillis();
        }
        ++outstandingAlarms;
        if (!Activator.getDefault().getPreferenceStore().getBoolean("SHOW_TRAY_POPUPS")) {
            return;
        }
        final TrayItem trayIcon = ConsoleSharedData.getTrayIcon();
        if (trayIcon != null) {
            new UIJob("Create alarm popup"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    IWorkbenchWindow[] wl;
                    AbstractObject object = session.findObjectById(alarm.getSourceObjectId());
                    int severityFlag = alarm.getCurrentSeverity() == Severity.NORMAL ? 2 : (alarm.getCurrentSeverity() == Severity.CRITICAL ? 1 : 8);
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window == null && (wl = PlatformUI.getWorkbench().getWorkbenchWindows()).length > 0) {
                        window = wl[0];
                    }
                    if (window != null) {
                        ToolTip tip = new ToolTip(window.getShell(), 0x1000 | severityFlag);
                        Messages.get();
                        tip.setText(String.valueOf(Messages.AlarmNotifier_ToolTip_Header) + StatusDisplayInfo.getStatusText((Severity)alarm.getCurrentSeverity()) + ")");
                        tip.setMessage(String.valueOf(object != null ? object.getObjectName() : Long.toString(alarm.getSourceObjectId())) + ": " + alarm.getMessage());
                        tip.setAutoHide(true);
                        trayIcon.setToolTip(tip);
                        tip.setVisible(true);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }
}

