/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Rack;
import org.netxms.ui.eclipse.console.resources.SharedColors;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectContextMenu;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.objectview.widgets.RackWidget;
import org.netxms.ui.eclipse.objectview.widgets.helpers.RackSelectionListener;

public class RackTab
extends ObjectTab
implements ISelectionProvider {
    private ScrolledComposite scroller;
    private Composite content;
    private RackWidget rackWidget;
    private ISelection selection = new StructuredSelection();
    private Set<ISelectionChangedListener> selectionListeners = new HashSet<ISelectionChangedListener>();

    @Override
    protected void createTabContent(Composite parent) {
        this.scroller = new ScrolledComposite(parent, 256);
        this.content = new Composite((Composite)this.scroller, 0);
        this.content.setLayout((Layout)new FillLayout());
        this.content.setBackground(SharedColors.getColor((String)"Rack.Background", (Display)parent.getDisplay()));
        this.scroller.setContent((Control)this.content);
        this.scroller.setExpandHorizontal(true);
        this.scroller.setExpandVertical(true);
        this.scroller.getHorizontalBar().setIncrement(20);
        this.scroller.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                RackTab.this.scroller.setMinSize(RackTab.this.content.computeSize(-1, ((RackTab)RackTab.this).scroller.getSize().y));
            }
        });
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                RackTab.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.rackWidget);
        this.rackWidget.setMenu(menu);
        this.getViewPart().getSite().registerContextMenu(menuMgr, (ISelectionProvider)this);
    }

    private void fillContextMenu(IMenuManager manager) {
        ObjectContextMenu.fill((IMenuManager)manager, (IShellProvider)this.getViewPart().getSite(), (ISelectionProvider)this);
    }

    @Override
    public void currentObjectUpdated(AbstractObject object) {
        this.objectChanged(object);
    }

    @Override
    public void refresh() {
    }

    @Override
    public void objectChanged(AbstractObject object) {
        if (this.rackWidget != null) {
            this.rackWidget.dispose();
            this.rackWidget = null;
        }
        if (object != null) {
            this.rackWidget = new RackWidget(this.content, 0, (Rack)object);
            this.content.layout(true, true);
            this.scroller.setMinSize(this.content.computeSize(-1, this.scroller.getSize().y));
            this.rackWidget.addSelectionListener(new RackSelectionListener(){

                @Override
                public void objectSelected(AbstractObject object) {
                    RackTab.this.selection = (ISelection)(object != null ? new StructuredSelection((Object)object) : new StructuredSelection());
                    for (ISelectionChangedListener listener : RackTab.this.selectionListeners) {
                        listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)RackTab.this, RackTab.this.selection));
                    }
                }
            });
            this.createPopupMenu();
        }
    }

    @Override
    public boolean showForObject(AbstractObject object) {
        return object instanceof Rack;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }
}

