/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.dialogs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.objectbrowser.Activator;
import org.netxms.ui.eclipse.objectbrowser.Messages;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectSelectionFilterFactory;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectTree;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class ObjectSelectionDialog
extends Dialog {
    private NXCSession session;
    private ObjectTree objectTree;
    private long[] rootObjects;
    private long[] selectedObjects;
    private Set<Integer> classFilter;
    private boolean multiSelection;
    private boolean showFilterToolTip = true;
    private boolean showFilterCloseButton = false;
    List<Object> currentObject;

    public static Set<Integer> createNodeSelectionFilter(boolean allowMobileDevices) {
        return ObjectSelectionFilterFactory.getInstance().createNodeSelectionFilter(allowMobileDevices);
    }

    public static Set<Integer> createZoneSelectionFilter() {
        return ObjectSelectionFilterFactory.getInstance().createZoneSelectionFilter();
    }

    public static Set<Integer> createNetworkMapSelectionFilter() {
        return ObjectSelectionFilterFactory.getInstance().createNetworkMapSelectionFilter();
    }

    public static Set<Integer> createNetworkMapGroupsSelectionFilter() {
        return ObjectSelectionFilterFactory.getInstance().createNetworkMapGroupsSelectionFilter();
    }

    public static Set<Integer> createPolicyGroupSelectionFilter() {
        return ObjectSelectionFilterFactory.getInstance().createPolicyGroupSelectionFilter();
    }

    public static Set<Integer> createPolicySelectionFilter() {
        return ObjectSelectionFilterFactory.getInstance().createPolicySelectionFilter();
    }

    public static Set<Integer> createDashboardSelectionFilter() {
        return ObjectSelectionFilterFactory.getInstance().createDashboardSelectionFilter();
    }

    public static Set<Integer> createTemplateSelectionFilter() {
        return ObjectSelectionFilterFactory.getInstance().createTemplateSelectionFilter();
    }

    public static Set<Integer> createTemplateGroupSelectionFilter() {
        return ObjectSelectionFilterFactory.getInstance().createTemplateGroupSelectionFilter();
    }

    public static Set<Integer> createNodeAndTemplateSelectionFilter(boolean allowMobileDevices) {
        return ObjectSelectionFilterFactory.getInstance().createNodeAndTemplateSelectionFilter(allowMobileDevices);
    }

    public static Set<Integer> createContainerSelectionFilter() {
        return ObjectSelectionFilterFactory.getInstance().createContainerSelectionFilter();
    }

    public static Set<Integer> createBusinessServiceSelectionFilter() {
        return ObjectSelectionFilterFactory.getInstance().createBusinessServiceSelectionFilter();
    }

    public static Set<Integer> createDashboardAndNetworkMapSelectionFilter() {
        return ObjectSelectionFilterFactory.getInstance().createDashboardAndNetworkMapSelectionFilter();
    }

    public ObjectSelectionDialog(Shell parentShell, long[] rootObjects, Set<Integer> classFilter) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.rootObjects = rootObjects;
        this.classFilter = classFilter;
        this.multiSelection = true;
        this.session = ConsoleSharedData.getSession();
        this.currentObject = new ArrayList<Object>();
    }

    public ObjectSelectionDialog(Shell parentShell, long[] rootObjects, Set<Integer> classFilter, List<Object> currentObject) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.rootObjects = rootObjects;
        this.classFilter = classFilter;
        this.multiSelection = true;
        this.session = ConsoleSharedData.getSession();
        this.currentObject = currentObject;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.ObjectSelectionDialog_Title);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        try {
            newShell.setSize(settings.getInt("SelectObject.cx"), settings.getInt("SelectObject.cy"));
        }
        catch (NumberFormatException numberFormatException) {
            newShell.setSize(400, 350);
        }
    }

    protected Control createDialogArea(Composite parent) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setLayout((Layout)new FormLayout());
        this.objectTree = new ObjectTree(dialogArea, 0, this.multiSelection ? 2 : 0, this.rootObjects, this.classFilter, this.showFilterToolTip, this.showFilterCloseButton);
        String text = settings.get("SelectObject.Filter");
        if (text != null) {
            this.objectTree.setFilter(text);
        }
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.objectTree.setLayoutData(fd);
        return dialogArea;
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void okPressed() {
        if (this.multiSelection) {
            Long[] objects = this.objectTree.getSelectedObjects();
            this.selectedObjects = new long[objects.length];
            int i = 0;
            while (i < objects.length) {
                this.selectedObjects[i] = objects[i];
                ++i;
            }
        } else {
            long objectId = this.objectTree.getFirstSelectedObject();
            if (objectId != 0L) {
                this.selectedObjects = new long[1];
                this.selectedObjects[0] = objectId;
                int i = 0;
                while (i < this.currentObject.size()) {
                    if (((AbstractObject)this.currentObject.get(i)).getObjectId() == objectId) {
                        Shell shell = this.getShell();
                        Messages.get();
                        Messages.get();
                        MessageDialogHelper.openWarning((Shell)shell, (String)Messages.ObjectSelectionDialog_Warning, (String)Messages.ObjectSelectionDialog_SameObjecsAstargetAndSourceWarning);
                        return;
                    }
                    ++i;
                }
            } else {
                Shell shell = this.getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openWarning((Shell)shell, (String)Messages.ObjectSelectionDialog_Warning, (String)Messages.ObjectSelectionDialog_WarningText);
                return;
            }
        }
        this.saveSettings();
        super.okPressed();
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put("SelectObject.cx", size.x);
        settings.put("SelectObject.cy", size.y);
        settings.put("SelectObject.Filter", this.objectTree.getFilter());
    }

    public List<AbstractObject> getSelectedObjects() {
        if (this.selectedObjects == null) {
            return new ArrayList<AbstractObject>(0);
        }
        return this.session.findMultipleObjects(this.selectedObjects, false);
    }

    public AbstractObject[] getSelectedObjects(Class<? extends AbstractObject> classFilter) {
        if (this.selectedObjects == null) {
            return new AbstractObject[0];
        }
        HashSet<AbstractObject> resultSet = new HashSet<AbstractObject>(this.selectedObjects.length);
        int i = 0;
        while (i < this.selectedObjects.length) {
            AbstractObject object = this.session.findObjectById(this.selectedObjects[i]);
            if (classFilter.isInstance(object)) {
                resultSet.add(object);
            }
            ++i;
        }
        return resultSet.toArray(new AbstractObject[resultSet.size()]);
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelection;
    }

    public void enableMultiSelection(boolean enable) {
        this.multiSelection = enable;
    }

    public void showFilterToolTip(boolean showFilterToolTip) {
        this.showFilterToolTip = showFilterToolTip;
    }

    public void showFilterCloseButton(boolean showFilterCloseButton) {
        this.showFilterCloseButton = showFilterCloseButton;
    }
}

