/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.api;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.GraphSettings;
import org.netxms.client.objects.AbstractNode;
import org.netxms.ui.eclipse.objects.ObjectContext;
import org.netxms.ui.eclipse.perfview.Activator;
import org.netxms.ui.eclipse.perfview.Messages;
import org.netxms.ui.eclipse.perfview.views.HistoricalGraphView;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class GraphTemplateCache {
    private static GraphTemplateCache instance = null;
    private NXCSession session = null;
    private List<GraphSettings> templateList = new ArrayList<GraphSettings>();

    public GraphTemplateCache(NXCSession session) {
        this.session = session;
        this.reload();
        session.addListener(new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                block0 : switch (n.getCode()) {
                    case 1028: {
                        int i = 0;
                        while (i < GraphTemplateCache.this.templateList.size()) {
                            if (((GraphSettings)GraphTemplateCache.this.templateList.get(i)).getId() == n.getSubCode()) {
                                Object o = GraphTemplateCache.this.templateList.get(i);
                                GraphTemplateCache.this.templateList.remove(o);
                                break block0;
                            }
                            ++i;
                        }
                        break;
                    }
                    case 1012: {
                        if (!(n.getObject() instanceof GraphSettings) || !((GraphSettings)n.getObject()).isTemplate()) {
                            return;
                        }
                        boolean objectUpdated = false;
                        int i = 0;
                        while (i < GraphTemplateCache.this.templateList.size()) {
                            if (((GraphSettings)GraphTemplateCache.this.templateList.get(i)).getId() == n.getSubCode()) {
                                GraphTemplateCache.this.templateList.set(i, (GraphSettings)n.getObject());
                                objectUpdated = true;
                                break;
                            }
                            ++i;
                        }
                        if (objectUpdated) break;
                        GraphTemplateCache.this.templateList.add((GraphSettings)n.getObject());
                    }
                }
            }
        });
    }

    public static void attachSession(NXCSession session) {
        instance = new GraphTemplateCache(session);
    }

    public static GraphTemplateCache getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload() {
        try {
            List<GraphSettings> list = this.templateList;
            synchronized (list) {
                this.templateList.clear();
                this.templateList = this.session.getPredefinedGraphs(true);
            }
        }
        catch (Exception e) {
            Activator.logError("Exception in ObjectToolsCache.reload()", e);
        }
    }

    public GraphSettings[] getGraphTemplates() {
        GraphSettings[] graphs = this.templateList.toArray(new GraphSettings[this.templateList.size()]);
        Arrays.sort(graphs, new Comparator<GraphSettings>(){

            @Override
            public int compare(GraphSettings arg0, GraphSettings arg1) {
                return arg0.getName().replace("&", "").compareToIgnoreCase(arg1.getName().replace("&", ""));
            }
        });
        return graphs;
    }

    public static void execute(AbstractNode node, GraphSettings data, DciValue[] values) {
        ObjectContext ctx = new ObjectContext(node, null);
        String name = ctx.substituteMacros(data.getTitle(), null);
        GraphSettings result = new GraphSettings(data, name);
        ChartDciConfig[] conf = result.getDciList();
        ArrayList<ChartDciConfig> newList = new ArrayList<ChartDciConfig>();
        int foundByDescription = -1;
        int foundDCICount = 0;
        int i = 0;
        while (i < conf.length) {
            Pattern namePattern = Pattern.compile(conf[i].dciName);
            Pattern descriptionPattern = Pattern.compile(conf[i].dciDescription);
            int j = 0;
            while (j < values.length) {
                if (!conf[i].dciName.isEmpty() && namePattern.matcher(values[j].getName()).find()) {
                    newList.add(new ChartDciConfig(values[j]));
                    ++foundDCICount;
                    if (!conf[i].multiMatch) break;
                }
                if (!conf[i].dciDescription.isEmpty() && descriptionPattern.matcher(values[j].getDescription()).find()) {
                    foundByDescription = j;
                }
                ++j;
            }
            if (j == values.length && foundByDescription >= 0) {
                ++foundDCICount;
                newList.add(new ChartDciConfig(values[foundByDescription]));
            }
            ++i;
        }
        if (foundDCICount > 0) {
            result.setDciList(newList.toArray(new ChartDciConfig[newList.size()]));
            GraphTemplateCache.showPredefinedGraph(result);
        } else {
            MessageDialogHelper.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Graph creation from template error", (String)"None of template graphs DCI were found on a node.");
        }
    }

    private static void showPredefinedGraph(GraphSettings gs) {
        String encodedName;
        try {
            encodedName = URLEncoder.encode(gs.getName(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            encodedName = "___ERROR___";
        }
        String id = "org.netxms.ui.eclipse.charts.predefinedGraph&" + encodedName;
        try {
            HistoricalGraphView g = (HistoricalGraphView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.netxms.ui.eclipse.perfview.views.HistoryGraph", id, 1);
            if (g != null) {
                g.initPredefinedGraph(gs);
            }
        }
        catch (PartInitException e) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.PredefinedGraphTree_Error, (String)String.format(Messages.PredefinedGraphTree_ErrorOpeningView, e.getLocalizedMessage()));
        }
    }
}

