/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.util;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.DataPointComponent;
import org.eclipse.birt.chart.model.attribute.DataPointComponentType;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.impl.DataPointComponentImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.CurveFitting;
import org.eclipse.birt.chart.model.component.DialRegion;
import org.eclipse.birt.chart.model.component.MarkerLine;
import org.eclipse.birt.chart.model.component.MarkerRange;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.layout.TitleBlock;
import org.eclipse.birt.chart.model.type.GanttSeries;
import org.eclipse.birt.chart.model.type.StockSeries;
import org.eclipse.birt.chart.model.util.BaseChartValueUpdater;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.birt.chart.model.util.DefaultValueProvider;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class ChartValueUpdater
extends BaseChartValueUpdater {
    protected Chart chart;

    public void update(Chart eObj, Chart eRefObj) {
        this.chart = eObj;
        this.beforeUpdate(eObj, eRefObj, true);
        super.update(eObj, eRefObj);
        this.revise(eObj, eRefObj, true);
        this.chart = null;
    }

    public void update(Chart eObj, Chart eRefObj, boolean checkVisible) {
        this.chart = eObj;
        if (eObj != null) {
            this.beforeUpdate(eObj, eRefObj, checkVisible);
            this.updateChart(eObj.eClass().getName(), null, eObj, eRefObj, true, checkVisible);
        }
        this.revise(eObj, eRefObj, checkVisible);
        this.chart = null;
    }

    protected void beforeUpdate(Chart eObj, Chart eRefObj, boolean checkVisible) {
        if (eObj.getEmptyMessage() != null && ChartUtil.isEmpty(eObj.getEmptyMessage().getCaption().getValue())) {
            eObj.getEmptyMessage().getCaption().setValue(null);
        }
    }

    protected void revise(Chart eObj, Chart eRefObj, boolean checkVisible) {
        boolean[] hasSeries = this.hasSpecificSeries(eObj);
        if (hasSeries[0]) {
            ((ChartWithAxes)eObj).unsetOrientation();
        }
        if (hasSeries[1]) {
            ((ChartWithAxes)eObj).setOrientation(Orientation.HORIZONTAL_LITERAL);
        }
        if (eObj != null && eObj instanceof ChartWithAxes && eObj.getDimension() != ChartDimension.THREE_DIMENSIONAL_LITERAL) {
            this.rotateAxesTitle((ChartWithAxes)eObj);
        }
    }

    protected boolean[] hasSpecificSeries(Chart eObj) {
        boolean[] hasSeries = new boolean[2];
        if (eObj instanceof ChartWithAxes) {
            ChartWithAxes cwa = (ChartWithAxes)eObj;
            for (Axis axis : ((Axis)cwa.getAxes().get(0)).getAssociatedAxes()) {
                for (SeriesDefinition sd : axis.getSeriesDefinitions()) {
                    for (Series s : sd.getSeries()) {
                        if (!hasSeries[0] && s instanceof StockSeries) {
                            hasSeries[0] = true;
                            return hasSeries;
                        }
                        if (hasSeries[1] || !(s instanceof GanttSeries)) continue;
                        hasSeries[1] = true;
                        return hasSeries;
                    }
                }
            }
        }
        return hasSeries;
    }

    protected void rotateAxesTitle(ChartWithAxes cwa) {
        boolean isHorizontal = cwa.getOrientation() == Orientation.HORIZONTAL_LITERAL;
        Axis aX = (Axis)cwa.getAxes().get(0);
        if (aX.getTitle().isSetVisible() && aX.getTitle().isVisible() && !aX.getTitle().getCaption().getFont().isSetRotation()) {
            if (isHorizontal) {
                aX.getTitle().getCaption().getFont().setRotation(90.0);
            } else {
                aX.getTitle().getCaption().getFont().setRotation(0.0);
            }
        }
        EList<Axis> aYs = aX.getAssociatedAxes();
        int i = 0;
        while (i < aYs.size()) {
            Axis aY = (Axis)aYs.get(i);
            if (aY.getTitle().isSetVisible() && aY.getTitle().isVisible() && !aY.getTitle().getCaption().getFont().isSetRotation()) {
                if (isHorizontal) {
                    aY.getTitle().getCaption().getFont().setRotation(0.0);
                } else {
                    aY.getTitle().getCaption().getFont().setRotation(90.0);
                }
            }
            ++i;
        }
    }

    public void updateCurveFitting(String name, EObject eParentObj, CurveFitting eObj, CurveFitting eRefObj, CurveFitting eDefObj, boolean eDefOverride, boolean checkVisible) {
        if (eObj == null && eRefObj != null) {
            eObj = eRefObj.copyInstance();
            ChartElementUtil.setEObjectAttribute(eParentObj, name, eObj, false);
            eRefObj = null;
        }
        if (eObj == null || eRefObj == null && eDefObj == null) {
            return;
        }
        super.updateCurveFitting(name, eParentObj, eObj, eRefObj, eDefObj, eDefOverride, checkVisible);
    }

    public void updateMarkerLine(String name, EObject eParentObj, MarkerLine eObj, MarkerLine eRefObj, MarkerLine eDefObj, boolean eDefOverride, boolean checkVisible) {
        if (eObj == null && eRefObj != null) {
            eObj = eRefObj.copyInstance();
            ChartElementUtil.setEObjectAttribute(eParentObj, name, eObj, false);
            eRefObj = null;
        }
        if (eObj == null || eRefObj == null && eDefObj == null) {
            return;
        }
        super.updateMarkerLine(name, eParentObj, eObj, eRefObj, eDefObj, eDefOverride, checkVisible);
    }

    public void updateMarkerRange(String name, EObject eParentObj, MarkerRange eObj, MarkerRange eRefObj, MarkerRange eDefObj, boolean eDefOverride, boolean checkVisible) {
        if (eObj == null && eRefObj != null) {
            eObj = eRefObj.copyInstance();
            ChartElementUtil.setEObjectAttribute(eParentObj, name, eObj, false);
            eRefObj = null;
        }
        if (eObj == null || eRefObj == null && eDefObj == null) {
            return;
        }
        super.updateMarkerRange(name, eParentObj, eObj, eRefObj, eDefObj, eDefOverride, checkVisible);
    }

    protected void updateDialRegion(String name, EObject eParentObj, DialRegion eObj, DialRegion eRefObj, DialRegion eDefObj, boolean eDefOverride, boolean checkVisible) {
        if (eObj == null && eRefObj != null) {
            eObj = eRefObj.copyInstance();
            ChartElementUtil.setEObjectAttribute(eParentObj, name, eObj, false);
            eRefObj = null;
        }
        if (eObj == null || eRefObj == null && eDefObj == null) {
            return;
        }
        super.updateDialRegion(name, eParentObj, eObj, eRefObj, eDefObj, eDefOverride, checkVisible);
    }

    protected void updateMarkerRangeImpl(String name, EObject eParentObj, MarkerRange eObj, MarkerRange eRefObj, MarkerRange eDefObj, boolean eDefOverride, boolean checkVisible) {
        if (eObj == null && eRefObj != null) {
            eObj = eRefObj.copyInstance();
            ChartElementUtil.setEObjectAttribute(eParentObj, name, eObj, false);
            eRefObj = null;
        }
        if (eObj == null || eRefObj == null && eDefObj == null) {
            return;
        }
        super.updateMarkerRangeImpl(name, eParentObj, eObj, eRefObj, eDefObj, eDefOverride, checkVisible);
    }

    protected void updateTitleBlock(String name, EObject eParentObj, TitleBlock eObj, TitleBlock eRefObj, TitleBlock eDefObj, boolean eDefOverride, boolean checkVisible) {
        if (eObj != null && eObj.eContainer() != null && eObj.eContainer().eContainer() instanceof Chart && ChartUtil.isEmpty(eObj.getLabel().getCaption().getValue())) {
            eObj.getLabel().getCaption().setValue(ChartUtil.getDefaultChartTitle(this.chart));
        }
        super.updateTitleBlock(name, eParentObj, eObj, eRefObj, eDefObj, eDefOverride, checkVisible);
    }

    public void updateDataPointComponent(String name, EObject eParentObj, DataPointComponent eObj, DataPointComponent eRefObj, DataPointComponent eDefObj, boolean eDefOverride, boolean checkVisible) {
        DataPointComponent eTmpDefObj = eDefObj;
        if (eObj != null && eObj.getType() == DataPointComponentType.PERCENTILE_ORTHOGONAL_VALUE_LITERAL && (eDefObj == null || eDefObj.getFormatSpecifier() == null)) {
            if (eDefObj == null) {
                eTmpDefObj = DataPointComponentImpl.create(DataPointComponentType.PERCENTILE_ORTHOGONAL_VALUE_LITERAL, DefaultValueProvider.defPercentileValueFormatSpecifier());
            } else if (eDefObj.getFormatSpecifier() == null) {
                eTmpDefObj = eDefObj.copyInstance();
                eTmpDefObj.setFormatSpecifier(DefaultValueProvider.defPercentileValueFormatSpecifier());
            }
        }
        super.updateDataPointComponent(name, eParentObj, eObj, eRefObj, eTmpDefObj, eDefOverride, checkVisible);
    }
}

