/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ICMP
extends PropertyPage {
    private AbstractNode node;
    private ObjectSelector icmpProxy;

    protected Control createContents(Composite parent) {
        this.node = (AbstractNode)this.getElement().getAdapter(AbstractNode.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout dialogLayout = new GridLayout();
        dialogLayout.marginWidth = 0;
        dialogLayout.marginHeight = 0;
        dialogArea.setLayout((Layout)dialogLayout);
        this.icmpProxy = new ObjectSelector(dialogArea, 0, true);
        Messages.get();
        this.icmpProxy.setLabel(Messages.Communication_Proxy);
        this.icmpProxy.setObjectId(this.node.getIcmpProxyId());
        this.icmpProxy.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return dialogArea;
    }

    protected boolean applyChanges(final boolean isApply) {
        final NXCObjectModificationData md = new NXCObjectModificationData(this.node.getObjectId());
        if (isApply) {
            this.setValid(false);
        }
        md.setIcmpProxy(this.icmpProxy.getObjectId());
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob(String.format("Updating ICMP settings for node %s", this.node.getObjectName()), null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected String getErrorMessage() {
                return String.format("Cannot update ICMP settings for node %s", ICMP.this.node.getObjectName());
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            ICMP.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.icmpProxy.setObjectId(0L);
    }
}

