/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.layouts.algorithms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef4.zest.layouts.LayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.dataStructures.DisplayIndependentRectangle;
import org.eclipse.gef4.zest.layouts.interfaces.LayoutContext;
import org.eclipse.gef4.zest.layouts.interfaces.NodeLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SugiyamaLayoutAlgorithm
implements LayoutAlgorithm {
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    private static final int MAX_LAYERS = 10;
    private static final int MAX_SWEEPS = 35;
    private static final int PADDING = -1;
    private final List<ArrayList<NodeWrapper>> layers = new ArrayList<ArrayList<NodeWrapper>>(10);
    private final Map<NodeLayout, NodeWrapper> map = new IdentityHashMap<NodeLayout, NodeWrapper>();
    private final int direction;
    private final Dimension dimension;
    private LayoutContext context;
    private int last;

    public SugiyamaLayoutAlgorithm(int dir, Dimension dim) {
        this.direction = dir == 1 ? 1 : 2;
        this.dimension = dim;
    }

    public SugiyamaLayoutAlgorithm(int dir) {
        this(dir, null);
    }

    public SugiyamaLayoutAlgorithm() {
        this(2, null);
    }

    @Override
    public void setLayoutContext(LayoutContext context) {
        this.context = context;
    }

    @Override
    public void applyLayout(boolean clean) {
        if (!clean) {
            return;
        }
        this.layers.clear();
        this.map.clear();
        this.createLayers();
        this.padLayers();
        int i = 0;
        while (i < this.layers.size()) {
            this.reduceCrossings();
            this.refineLayers();
            ++i;
        }
        this.reduceCrossings();
        this.calculatePositions();
    }

    private void createLayers() {
        LinkedList<NodeLayout> nodes = new LinkedList<NodeLayout>(Arrays.asList(this.context.getNodes()));
        List<NodeLayout> predecessors = SugiyamaLayoutAlgorithm.findRoots(nodes);
        nodes.removeAll(predecessors);
        this.addLayer(predecessors);
        int level = 1;
        while (!nodes.isEmpty()) {
            if (level > 10) {
                throw new RuntimeException("Graphical tree exceeds maximum depth of 10! (Graph not directed? Cycles?)");
            }
            ArrayList<NodeLayout> layer = new ArrayList<NodeLayout>();
            for (NodeLayout item : nodes) {
                if (!predecessors.containsAll(Arrays.asList(item.getPredecessingNodes()))) continue;
                layer.add(item);
            }
            nodes.removeAll(layer);
            predecessors.addAll(layer);
            this.addLayer(layer);
            ++level;
        }
    }

    private void addLayer(List<NodeLayout> list) {
        ArrayList<NodeWrapper> layer = new ArrayList<NodeWrapper>(list.size());
        for (NodeLayout node : list) {
            NodeWrapper nw = new NodeWrapper(node, this.layers.size());
            this.map.put(node, nw);
            layer.add(nw);
            NodeLayout[] nodeLayoutArray = node.getPredecessingNodes();
            int n = nodeLayoutArray.length;
            int n2 = 0;
            while (n2 < n) {
                NodeLayout node_predecessor = nodeLayoutArray[n2];
                NodeWrapper nw_predecessor = this.map.get(node_predecessor);
                int level = nw_predecessor.layer + 1;
                while (level < nw.layer) {
                    NodeWrapper nw_dummy = new NodeWrapper(level);
                    nw_dummy.addPredecessor(nw_predecessor);
                    nw_predecessor.addSuccessor(nw_dummy);
                    nw_predecessor = nw_dummy;
                    this.layers.get(level).add(nw_dummy);
                    ++level;
                }
                nw.addPredecessor(nw_predecessor);
                nw_predecessor.addSuccessor(nw);
                ++n2;
            }
        }
        this.layers.add(layer);
        SugiyamaLayoutAlgorithm.updateIndex(layer);
    }

    private void reduceCrossings() {
        int round = 0;
        while (round < 35) {
            int index;
            if ((round & 1) == 0) {
                index = 1;
                while (index < this.layers.size()) {
                    SugiyamaLayoutAlgorithm.reduceCrossingsDown(this.layers.get(index));
                    ++index;
                }
            } else {
                index = this.layers.size() - 2;
                while (index >= 0) {
                    SugiyamaLayoutAlgorithm.reduceCrossingsUp(this.layers.get(index));
                    --index;
                }
            }
            ++round;
        }
    }

    private static void reduceCrossingsDown(ArrayList<NodeWrapper> layer) {
        for (NodeWrapper node : layer) {
            node.index = node.getBaryCenter(node.pred);
        }
        Collections.sort(layer, new Comparator<NodeWrapper>(){

            @Override
            public int compare(NodeWrapper node1, NodeWrapper node2) {
                return node1.index - node2.index;
            }
        });
        SugiyamaLayoutAlgorithm.updateIndex(layer);
    }

    private static void reduceCrossingsUp(ArrayList<NodeWrapper> layer) {
        for (NodeWrapper node : layer) {
            node.index = node.getBaryCenter(node.succ);
        }
        Collections.sort(layer, new Comparator<NodeWrapper>(){

            @Override
            public int compare(NodeWrapper node1, NodeWrapper node2) {
                return node1.index - node2.index;
            }
        });
        SugiyamaLayoutAlgorithm.updateIndex(layer);
    }

    private void padLayers() {
        this.last = 0;
        for (List list : this.layers) {
            if (list.size() <= this.last) continue;
            this.last = list.size();
        }
        --this.last;
        for (List list : this.layers) {
            int i = list.size();
            while (i <= this.last) {
                list.add(new NodeWrapper());
                ++i;
            }
            SugiyamaLayoutAlgorithm.updateIndex(list);
        }
    }

    private void refineLayers() {
        int index = 1;
        while (index < this.layers.size()) {
            this.refineLayersDown((List<NodeWrapper>)this.layers.get(index));
            ++index;
        }
        index = this.layers.size() - 2;
        while (index >= 0) {
            this.refineLayersUp((List<NodeWrapper>)this.layers.get(index));
            --index;
        }
        index = 1;
        while (index < this.layers.size()) {
            this.refineLayersDown((List<NodeWrapper>)this.layers.get(index));
            ++index;
        }
    }

    private void refineLayersDown(List<NodeWrapper> layer) {
        ArrayList<NodeWrapper> list = new ArrayList<NodeWrapper>(layer);
        Collections.sort(list, new Comparator<NodeWrapper>(){

            @Override
            public int compare(NodeWrapper node1, NodeWrapper node2) {
                return node2.getPriorityDown() - node1.getPriorityDown();
            }
        });
        for (NodeWrapper iter : list) {
            if (iter.isPadding()) break;
            int delta = iter.getBaryCenter(iter.pred) - iter.index;
            int i = 0;
            while (i < delta) {
                layer.add(iter.index, layer.remove(this.last));
                ++i;
            }
        }
        SugiyamaLayoutAlgorithm.updateIndex(layer);
    }

    private void refineLayersUp(List<NodeWrapper> layer) {
        ArrayList<NodeWrapper> list = new ArrayList<NodeWrapper>(layer);
        Collections.sort(list, new Comparator<NodeWrapper>(){

            @Override
            public int compare(NodeWrapper node1, NodeWrapper node2) {
                return node2.getPriorityUp() - node1.getPriorityUp();
            }
        });
        for (NodeWrapper iter : list) {
            if (iter.isPadding()) break;
            int delta = iter.getBaryCenter(iter.succ) - iter.index;
            int i = 0;
            while (i < delta) {
                layer.add(iter.index, layer.remove(this.last));
                ++i;
            }
        }
        SugiyamaLayoutAlgorithm.updateIndex(layer);
    }

    private void calculatePositions() {
        DisplayIndependentRectangle boundary = this.context.getBounds();
        if (this.dimension != null) {
            boundary = new DisplayIndependentRectangle(0.0, 0.0, this.dimension.preciseWidth(), this.dimension.preciseHeight());
        }
        double dx = boundary.width / (double)this.layers.size();
        double dy = boundary.height / (double)(this.last + 1);
        if (this.direction == 1) {
            NodeLayout[] nodeLayoutArray = this.context.getNodes();
            int n = nodeLayoutArray.length;
            int n2 = 0;
            while (n2 < n) {
                NodeLayout node = nodeLayoutArray[n2];
                NodeWrapper nw = this.map.get(node);
                node.setLocation(((double)nw.layer + 0.5) * dx, ((double)nw.index + 0.5) * dy);
                ++n2;
            }
        } else {
            NodeLayout[] nodeLayoutArray = this.context.getNodes();
            int n = nodeLayoutArray.length;
            int n3 = 0;
            while (n3 < n) {
                NodeLayout node = nodeLayoutArray[n3];
                NodeWrapper nw = this.map.get(node);
                node.setLocation(((double)nw.index + 0.5) * dx, ((double)nw.layer + 0.5) * dy);
                ++n3;
            }
        }
    }

    private static List<NodeLayout> findRoots(List<NodeLayout> list) {
        ArrayList<NodeLayout> roots = new ArrayList<NodeLayout>();
        for (NodeLayout iter : list) {
            if (iter.getPredecessingNodes().length != 0) continue;
            roots.add(iter);
        }
        return roots;
    }

    private static void updateIndex(List<NodeWrapper> list) {
        int index = 0;
        while (index < list.size()) {
            list.get((int)index).index = index;
            ++index;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeWrapper {
        int index;
        final int layer;
        final NodeLayout node;
        final List<NodeWrapper> pred = new LinkedList<NodeWrapper>();
        final List<NodeWrapper> succ = new LinkedList<NodeWrapper>();

        NodeWrapper(NodeLayout n, int l) {
            this.node = n;
            this.layer = l;
        }

        NodeWrapper(int l) {
            this(null, l);
        }

        NodeWrapper() {
            this(null, -1);
        }

        void addPredecessor(NodeWrapper node) {
            this.pred.add(node);
        }

        void addSuccessor(NodeWrapper node) {
            this.succ.add(node);
        }

        boolean isDummy() {
            return this.node == null && this.layer != -1;
        }

        boolean isPadding() {
            return this.node == null && this.layer == -1;
        }

        int getBaryCenter(List<NodeWrapper> list) {
            if (list.isEmpty()) {
                return this.index;
            }
            if (list.size() == 1) {
                return list.get((int)0).index;
            }
            double barycenter = 0.0;
            for (NodeWrapper node : list) {
                barycenter += (double)node.index;
            }
            return (int)(barycenter / (double)list.size());
        }

        int getPriorityDown() {
            if (this.isPadding()) {
                return 0;
            }
            if (this.isDummy()) {
                if (this.succ.get(0).isDummy()) {
                    return Integer.MAX_VALUE;
                }
                return 0x3FFFFFFF;
            }
            return this.pred.size();
        }

        int getPriorityUp() {
            if (this.isPadding()) {
                return 0;
            }
            if (this.isDummy()) {
                if (this.pred.get(0).isDummy()) {
                    return Integer.MAX_VALUE;
                }
                return 0x3FFFFFFF;
            }
            return this.succ.size();
        }
    }
}

