/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCSession;
import org.netxms.client.events.AlarmCategory;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class General
extends PropertyPage {
    private Text textName;
    private Text textDescription;
    private String categoryName;
    private String categoryDescription;
    private AlarmCategory object;
    private NXCSession session = ConsoleSharedData.getSession();
    private boolean applyPressed = false;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (AlarmCategory)this.getElement().getAdapter(AlarmCategory.class);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        dialogArea.setLayout((Layout)layout);
        WidgetHelper.createLabeledText((Composite)dialogArea, (int)2060, (int)-1, (String)"Category ID", (String)Long.toString(this.object.getId()), (Object)"WidgetHelper::default_layout_data");
        this.categoryName = this.object.getName();
        this.textName = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2052, (int)-1, (String)"Category name", (String)this.categoryName, (Object)"WidgetHelper::default_layout_data");
        this.categoryDescription = this.object.getDescription();
        this.textDescription = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2050, (int)-1, (String)"Description", (String)this.categoryDescription, (Object)"WidgetHelper::default_layout_data");
        this.textDescription.setTextLimit(255);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.heightHint = 100;
        gd.verticalAlignment = 4;
        this.textDescription.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        final String newName = this.textName.getText();
        final String newDescription = this.textDescription.getText();
        if (newName.equals(this.categoryName) && newDescription.equals(this.categoryDescription) && this.applyPressed) {
            return;
        }
        if (isApply) {
            this.setValid(false);
        }
        new ConsoleJob("Update alarm category database", null, "org.netxms.ui.eclipse.alarmviewer", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                General.this.object.setName(newName);
                General.this.object.setDescription(newDescription);
                General.this.session.modifyAlarmCategory(General.this.object, 1);
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            General.this.setValid(true);
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                return "Cannot update alarm category database entry";
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
        this.applyPressed = true;
    }
}

