/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.netxms.ui.eclipse.tools.ColorConverter;

public class ServerNameStatusLineItem
extends ContributionItem {
    private static final int DEFAULT_CHAR_WIDTH = 40;
    public static final int CALC_TRUE_WIDTH = -1;
    private int charWidth;
    private int widthHint = -1;
    private int heightHint = -1;
    private CLabel label;
    private Font font;
    private Color bgColor = null;
    private Composite statusLine = null;
    private String serverName = "";
    private RGB serverColor = null;

    public ServerNameStatusLineItem(String id) {
        this(id, 40);
    }

    public ServerNameStatusLineItem(String id, int charWidth) {
        super(id);
        this.charWidth = charWidth;
        this.setVisible(false);
    }

    public void fill(Composite parent) {
        this.statusLine = parent;
        FontData fd = JFaceResources.getDialogFont().getFontData()[0];
        fd.setStyle(1);
        this.font = new Font((Device)Display.getCurrent(), fd);
        Label sep = new Label(parent, 2);
        this.label = new CLabel(this.statusLine, 0x1000810);
        this.label.setFont(this.font);
        this.label.setText(this.serverName);
        this.setColors();
        this.label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ServerNameStatusLineItem.this.font.dispose();
                if (ServerNameStatusLineItem.this.bgColor != null) {
                    ServerNameStatusLineItem.this.bgColor.dispose();
                }
            }
        });
        if (this.charWidth == -1) {
            Point preferredSize = this.label.computeSize(-1, -1);
            this.widthHint = preferredSize.x;
            this.heightHint = preferredSize.y;
        } else if (this.widthHint < 0) {
            GC gc = new GC((Drawable)this.statusLine);
            gc.setFont(this.statusLine.getFont());
            FontMetrics fm = gc.getFontMetrics();
            this.widthHint = fm.getAverageCharWidth() * this.charWidth;
            this.heightHint = fm.getHeight();
            gc.dispose();
        }
        StatusLineLayoutData data = new StatusLineLayoutData();
        data.widthHint = this.widthHint;
        this.label.setLayoutData((Object)data);
        data = new StatusLineLayoutData();
        data.heightHint = this.heightHint;
        sep.setLayoutData((Object)data);
    }

    public Point getDisplayLocation() {
        if (this.label != null && this.statusLine != null) {
            return this.statusLine.toDisplay(this.label.getLocation());
        }
        return null;
    }

    public void setServerInfo(String name, String color) {
        this.serverName = name;
        RGB rGB = this.serverColor = color != null ? ColorConverter.parseColorDefinition(color) : null;
        if (this.label != null && !this.label.isDisposed()) {
            this.label.setText(this.serverName);
            this.setColors();
        }
        if (!this.isVisible() || this.charWidth == -1) {
            this.setVisible(true);
            IContributionManager contributionManager = this.getParent();
            if (contributionManager != null) {
                contributionManager.update(true);
            }
        }
    }

    private void setColors() {
        if (this.bgColor != null) {
            this.bgColor.dispose();
        }
        this.bgColor = this.serverColor != null ? new Color((Device)Display.getCurrent(), this.serverColor) : null;
        this.label.setBackground(this.bgColor);
    }
}

