/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.tools;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.netxms.ui.eclipse.tools.ColorCache;

public class ColorConverter {
    private static final Map<String, RGB> colorNames = new HashMap<String, RGB>();

    static {
        colorNames.put("aliceblue", new RGB(240, 248, 255));
        colorNames.put("antiquewhite", new RGB(250, 235, 215));
        colorNames.put("aqua", new RGB(0, 255, 255));
        colorNames.put("aquamarine", new RGB(127, 255, 212));
        colorNames.put("azure", new RGB(240, 255, 255));
        colorNames.put("beige", new RGB(245, 245, 220));
        colorNames.put("bisque", new RGB(255, 228, 196));
        colorNames.put("black", new RGB(0, 0, 0));
        colorNames.put("blanchedalmond", new RGB(255, 235, 205));
        colorNames.put("blue", new RGB(0, 0, 255));
        colorNames.put("blueviolet", new RGB(138, 43, 226));
        colorNames.put("brown", new RGB(165, 42, 42));
        colorNames.put("burlywood", new RGB(222, 184, 135));
        colorNames.put("cadetblue", new RGB(95, 158, 160));
        colorNames.put("chartreuse", new RGB(127, 255, 0));
        colorNames.put("chocolate", new RGB(210, 105, 30));
        colorNames.put("coral", new RGB(255, 127, 80));
        colorNames.put("cornflowerblue", new RGB(100, 149, 237));
        colorNames.put("cornsilk", new RGB(255, 248, 220));
        colorNames.put("crimson", new RGB(220, 20, 60));
        colorNames.put("cyan", new RGB(0, 255, 255));
        colorNames.put("darkblue", new RGB(0, 0, 139));
        colorNames.put("darkcyan", new RGB(0, 139, 139));
        colorNames.put("darkgoldenrod", new RGB(184, 134, 11));
        colorNames.put("darkgray", new RGB(169, 169, 169));
        colorNames.put("darkgrey", new RGB(169, 169, 169));
        colorNames.put("darkgreen", new RGB(0, 100, 0));
        colorNames.put("darkkhaki", new RGB(189, 183, 107));
        colorNames.put("darkmagenta", new RGB(139, 0, 139));
        colorNames.put("darkolivegreen", new RGB(85, 107, 47));
        colorNames.put("darkorange", new RGB(255, 140, 0));
        colorNames.put("darkorchid", new RGB(153, 50, 204));
        colorNames.put("darkred", new RGB(139, 0, 0));
        colorNames.put("darksalmon", new RGB(233, 150, 122));
        colorNames.put("darkseagreen", new RGB(143, 188, 143));
        colorNames.put("darkslateblue", new RGB(72, 61, 139));
        colorNames.put("darkslategray", new RGB(47, 79, 79));
        colorNames.put("darkslategrey", new RGB(47, 79, 79));
        colorNames.put("darkturquoise", new RGB(0, 206, 209));
        colorNames.put("darkviolet", new RGB(148, 0, 211));
        colorNames.put("deeppink", new RGB(255, 20, 147));
        colorNames.put("deepskyblue", new RGB(0, 191, 255));
        colorNames.put("dimgray", new RGB(105, 105, 105));
        colorNames.put("dimgrey", new RGB(105, 105, 105));
        colorNames.put("dodgerblue", new RGB(30, 144, 255));
        colorNames.put("firebrick", new RGB(178, 34, 34));
        colorNames.put("floralwhite", new RGB(255, 250, 240));
        colorNames.put("forestgreen", new RGB(34, 139, 34));
        colorNames.put("fuchsia", new RGB(255, 0, 255));
        colorNames.put("gainsboro", new RGB(220, 220, 220));
        colorNames.put("ghostwhite", new RGB(248, 248, 255));
        colorNames.put("gold", new RGB(255, 215, 0));
        colorNames.put("goldenrod", new RGB(218, 165, 32));
        colorNames.put("gray", new RGB(128, 128, 128));
        colorNames.put("grey", new RGB(128, 128, 128));
        colorNames.put("green", new RGB(0, 128, 0));
        colorNames.put("greenyellow", new RGB(173, 255, 47));
        colorNames.put("honeydew", new RGB(240, 255, 240));
        colorNames.put("hotpink", new RGB(255, 105, 180));
        colorNames.put("indianred", new RGB(205, 92, 92));
        colorNames.put("indigo", new RGB(75, 0, 130));
        colorNames.put("ivory", new RGB(255, 255, 240));
        colorNames.put("khaki", new RGB(240, 230, 140));
        colorNames.put("lavender", new RGB(230, 230, 250));
        colorNames.put("lavenderblush", new RGB(255, 240, 245));
        colorNames.put("lawngreen", new RGB(124, 252, 0));
        colorNames.put("lemonchiffon", new RGB(255, 250, 205));
        colorNames.put("lightblue", new RGB(173, 216, 230));
        colorNames.put("lightcoral", new RGB(240, 128, 128));
        colorNames.put("lightcyan", new RGB(224, 255, 255));
        colorNames.put("lightgoldenrodyellow", new RGB(250, 250, 210));
        colorNames.put("lightgray", new RGB(211, 211, 211));
        colorNames.put("lightgrey", new RGB(211, 211, 211));
        colorNames.put("lightgreen", new RGB(144, 238, 144));
        colorNames.put("lightpink", new RGB(255, 182, 193));
        colorNames.put("lightsalmon", new RGB(255, 160, 122));
        colorNames.put("lightseagreen", new RGB(32, 178, 170));
        colorNames.put("lightskyblue", new RGB(135, 206, 250));
        colorNames.put("lightslategray", new RGB(119, 136, 153));
        colorNames.put("lightslategrey", new RGB(119, 136, 153));
        colorNames.put("lightsteelblue", new RGB(176, 196, 222));
        colorNames.put("lightyellow", new RGB(255, 255, 224));
        colorNames.put("lime", new RGB(0, 255, 0));
        colorNames.put("limegreen", new RGB(50, 205, 50));
        colorNames.put("linen", new RGB(250, 240, 230));
        colorNames.put("magenta", new RGB(255, 0, 255));
        colorNames.put("maroon", new RGB(128, 0, 0));
        colorNames.put("mediumaquamarine", new RGB(102, 205, 170));
        colorNames.put("mediumblue", new RGB(0, 0, 205));
        colorNames.put("mediumorchid", new RGB(186, 85, 211));
        colorNames.put("mediumpurple", new RGB(147, 112, 219));
        colorNames.put("mediumseagreen", new RGB(60, 179, 113));
        colorNames.put("mediumslateblue", new RGB(123, 104, 238));
        colorNames.put("mediumspringgreen", new RGB(0, 250, 154));
        colorNames.put("mediumturquoise", new RGB(72, 209, 204));
        colorNames.put("mediumvioletred", new RGB(199, 21, 133));
        colorNames.put("midnightblue", new RGB(25, 25, 112));
        colorNames.put("mintcream", new RGB(245, 255, 250));
        colorNames.put("mistyrose", new RGB(255, 228, 225));
        colorNames.put("moccasin", new RGB(255, 228, 181));
        colorNames.put("navajowhite", new RGB(255, 222, 173));
        colorNames.put("navy", new RGB(0, 0, 128));
        colorNames.put("oldlace", new RGB(253, 245, 230));
        colorNames.put("olive", new RGB(128, 128, 0));
        colorNames.put("olivedrab", new RGB(107, 142, 35));
        colorNames.put("orange", new RGB(255, 165, 0));
        colorNames.put("orangered", new RGB(255, 69, 0));
        colorNames.put("orchid", new RGB(218, 112, 214));
        colorNames.put("palegoldenrod", new RGB(238, 232, 170));
        colorNames.put("palegreen", new RGB(152, 251, 152));
        colorNames.put("paleturquoise", new RGB(175, 238, 238));
        colorNames.put("palevioletred", new RGB(219, 112, 147));
        colorNames.put("papayawhip", new RGB(255, 239, 213));
        colorNames.put("peachpuff", new RGB(255, 218, 185));
        colorNames.put("peru", new RGB(205, 133, 63));
        colorNames.put("pink", new RGB(255, 192, 203));
        colorNames.put("plum", new RGB(221, 160, 221));
        colorNames.put("powderblue", new RGB(176, 224, 230));
        colorNames.put("purple", new RGB(128, 0, 128));
        colorNames.put("rebeccapurple", new RGB(102, 51, 153));
        colorNames.put("red", new RGB(255, 0, 0));
        colorNames.put("rosybrown", new RGB(188, 143, 143));
        colorNames.put("royalblue", new RGB(65, 105, 225));
        colorNames.put("saddlebrown", new RGB(139, 69, 19));
        colorNames.put("salmon", new RGB(250, 128, 114));
        colorNames.put("sandybrown", new RGB(244, 164, 96));
        colorNames.put("seagreen", new RGB(46, 139, 87));
        colorNames.put("seashell", new RGB(255, 245, 238));
        colorNames.put("sienna", new RGB(160, 82, 45));
        colorNames.put("silver", new RGB(192, 192, 192));
        colorNames.put("skyblue", new RGB(135, 206, 235));
        colorNames.put("slateblue", new RGB(106, 90, 205));
        colorNames.put("slategray", new RGB(112, 128, 144));
        colorNames.put("slategrey", new RGB(112, 128, 144));
        colorNames.put("snow", new RGB(255, 250, 250));
        colorNames.put("springgreen", new RGB(0, 255, 127));
        colorNames.put("steelblue", new RGB(70, 130, 180));
        colorNames.put("tan", new RGB(210, 180, 140));
        colorNames.put("teal", new RGB(0, 128, 128));
        colorNames.put("thistle", new RGB(216, 191, 216));
        colorNames.put("tomato", new RGB(255, 99, 71));
        colorNames.put("turquoise", new RGB(64, 224, 208));
        colorNames.put("violet", new RGB(238, 130, 238));
        colorNames.put("wheat", new RGB(245, 222, 179));
        colorNames.put("white", new RGB(255, 255, 255));
        colorNames.put("whitesmoke", new RGB(245, 245, 245));
        colorNames.put("yellow", new RGB(255, 255, 0));
        colorNames.put("yellowgreen", new RGB(154, 205, 50));
    }

    public static int rgbToInt(RGB rgb) {
        return rgb.red | rgb.green << 8 | rgb.blue << 16;
    }

    public static RGB rgbFromInt(int color) {
        return new RGB(color & 0xFF, color >> 8 & 0xFF, color >> 16 & 0xFF);
    }

    public static Color colorFromInt(int rgb, ColorCache cache) {
        return cache.create(rgb & 0xFF, rgb >> 8 & 0xFF, rgb >> 16 & 0xFF);
    }

    public static Color getColorFromPreferences(IPreferenceStore store, String name, ColorCache cache) {
        return cache.create(PreferenceConverter.getColor((IPreferenceStore)store, (String)name));
    }

    public static int getColorFromPreferencesAsInt(IPreferenceStore store, String name) {
        return ColorConverter.rgbToInt(PreferenceConverter.getColor((IPreferenceStore)store, (String)name));
    }

    private static float lerp(float start, float end, float amount) {
        float difference = end - start;
        float adjusted = difference * amount;
        return start + adjusted;
    }

    public static Color adjustColor(Color color, RGB direction, float amount, ColorCache cache) {
        float sr = color.getRed();
        float sg = color.getGreen();
        float sb = color.getBlue();
        float dr = direction.red;
        float dg = direction.green;
        float db = direction.blue;
        return cache.create((int)ColorConverter.lerp(sr, dr, amount), (int)ColorConverter.lerp(sg, dg, amount), (int)ColorConverter.lerp(sb, db, amount));
    }

    public static RGB parseColorDefinition(String cdef) {
        if (cdef == null || cdef.isEmpty()) {
            return null;
        }
        if (cdef.charAt(0) == '#') {
            try {
                int v = Integer.parseInt(cdef.substring(1), 16) & 0xFFFFFF;
                return new RGB(v >> 16, v >> 8 & 0xFF, v & 0xFF);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (cdef.startsWith("rgb(")) {
            int b;
            int g;
            int r;
            block10: {
                int i = cdef.indexOf(41);
                if (i == -1) {
                    return null;
                }
                String[] parts = cdef.substring(4, i).split(",");
                if (parts.length != 3) {
                    return null;
                }
                try {
                    r = Integer.parseInt(parts[0]);
                    g = Integer.parseInt(parts[1]);
                    b = Integer.parseInt(parts[2]);
                    if (r >= 0 && r <= 255 && g >= 0 && g <= 255 && b >= 0 && b <= 255) break block10;
                    return null;
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            return new RGB(r, g, b);
        }
        return colorNames.get(cdef.toLowerCase());
    }
}

