/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.server;

import java.util.HashMap;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.ServerVariableDataType;

public final class ServerVariable {
    private String name;
    private String value;
    private String description;
    private ServerVariableDataType dataType;
    private HashMap<String, String> values = new HashMap();
    private boolean isServerRestartNeeded;

    public ServerVariable(String name, String value, boolean isServerRestartNeeded, ServerVariableDataType dataType, String description) {
        this.name = name;
        this.value = value;
        this.description = description;
        this.dataType = dataType;
        this.isServerRestartNeeded = isServerRestartNeeded;
    }

    public ServerVariable(NXCPMessage msg, long baseId) {
        this.name = msg.getFieldAsString(baseId);
        this.value = msg.getFieldAsString(baseId + 1L);
        this.isServerRestartNeeded = msg.getFieldAsBoolean(baseId + 2L);
        String code = msg.getFieldAsString(baseId + 3L);
        this.dataType = ServerVariableDataType.getByCode(code != null && !code.isEmpty() ? code.charAt(0) : (char)'S');
        this.description = msg.getFieldAsString(baseId + 4L);
    }

    public void addPossibleValue(NXCPMessage msg, long baseId) {
        this.values.put(msg.getFieldAsString(baseId), msg.getFieldAsString(baseId + 1L));
    }

    public String getName() {
        return this.name;
    }

    public String getValueDescription() {
        return this.values.get(this.value);
    }

    public String getValue() {
        return this.value != null ? this.value : "";
    }

    public boolean getValueAsBoolean() {
        try {
            return Integer.parseInt(this.value) != 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public int getValueAsInt() {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public ServerVariableDataType getDataType() {
        return this.dataType;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isServerRestartNeeded() {
        return this.isServerRestartNeeded;
    }

    public HashMap<String, String> getPossibleValues() {
        return this.values;
    }
}

