/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.actions;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.topology.dialogs.EnterPrimaryHostnameDlg;

public class FindNodeByPrimaryHostname
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;

    public void run(IAction action) {
        final EnterPrimaryHostnameDlg dlg = new EnterPrimaryHostnameDlg(this.window.getShell());
        if (dlg.open() != 0) {
            return;
        }
        final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Searching for hostname" + dlg.getHostname() + "in the network", null, "org.netxms.ui.eclipse.topology", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List nodes = session.findNodesByHostname((int)dlg.getZoneId(), dlg.getHostname());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (nodes != null && !nodes.isEmpty()) {
                            StringBuilder sb = new StringBuilder();
                            sb.append("The following nodes matching the criteria have been found: ");
                            int i = 0;
                            while (i < nodes.size()) {
                                sb.append("\n" + ((AbstractNode)nodes.get(i)).getPrimaryName());
                                ++i;
                            }
                            MessageDialogHelper.openInformation((Shell)shell, (String)"Result", (String)sb.toString());
                        } else {
                            MessageDialogHelper.openInformation((Shell)shell, (String)"Result", (String)"No nodes found!");
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                return "Search for hostname" + dlg.getHostname() + "failed.";
            }
        }.start();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }
}

