/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class SSH
extends PropertyPage {
    private AbstractNode node;
    private ObjectSelector sshProxy;
    private LabeledText sshLogin;
    private LabeledText sshPassword;

    protected Control createContents(Composite parent) {
        this.node = (AbstractNode)this.getElement().getAdapter(AbstractNode.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout dialogLayout = new GridLayout();
        dialogLayout.marginWidth = 0;
        dialogLayout.marginHeight = 0;
        dialogLayout.numColumns = 2;
        dialogLayout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)dialogLayout);
        this.sshLogin = new LabeledText(dialogArea, 0);
        this.sshLogin.setLabel("Login");
        this.sshLogin.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.sshLogin.setText(this.node.getSshLogin());
        this.sshPassword = new LabeledText(dialogArea, 0);
        this.sshPassword.setLabel("Password");
        this.sshPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.sshPassword.setText(this.node.getSshPassword());
        this.sshProxy = new ObjectSelector(dialogArea, 0, true);
        Messages.get();
        this.sshProxy.setLabel(Messages.Communication_Proxy);
        this.sshProxy.setEmptySelectionName("<default>");
        this.sshProxy.setObjectId(this.node.getSshProxyId());
        this.sshProxy.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        return dialogArea;
    }

    protected boolean applyChanges(final boolean isApply) {
        final NXCObjectModificationData md = new NXCObjectModificationData(this.node.getObjectId());
        if (isApply) {
            this.setValid(false);
        }
        md.setSshProxy(this.sshProxy.getObjectId());
        md.setSshLogin(this.sshLogin.getText().trim());
        md.setSshPassword(this.sshPassword.getText());
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob(String.format("Updating SSH settings for node %s", this.node.getObjectName()), null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected String getErrorMessage() {
                return String.format("Cannot update SSH settings for node %s", SSH.this.node.getObjectName());
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            SSH.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.sshProxy.setObjectId(0L);
        this.sshLogin.setText("netxms");
        this.sshPassword.setText("");
    }
}

