/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.osm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Point;
import org.netxms.base.GeoLocation;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.osm.GeoLocationCacheListener;
import org.netxms.ui.eclipse.osm.tools.Area;
import org.netxms.ui.eclipse.osm.tools.QuadTree;

public class GeoLocationCache
implements SessionListener {
    public static final int CENTER = 0;
    public static final int TOP_LEFT = 1;
    public static final int BOTTOM_RIGHT = 2;
    private static final int TILE_SIZE = 256;
    private static GeoLocationCache instance = new GeoLocationCache();
    private Map<Long, AbstractObject> objects = new HashMap<Long, AbstractObject>();
    private QuadTree<Long> locationTree = new QuadTree();
    private NXCSession session;
    private Set<GeoLocationCacheListener> listeners = new HashSet<GeoLocationCacheListener>();

    public void notificationHandler(SessionNotification n) {
        if (n.getCode() == 4) {
            this.onObjectChange((AbstractObject)n.getObject());
        } else if (n.getCode() == 2001) {
            this.internalInitialize();
        }
    }

    void initialize(NXCSession session) {
        this.session = session;
        if (session.isObjectsSynchronized()) {
            this.internalInitialize();
        }
        session.addListener((SessionListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalInitialize() {
        QuadTree<Long> quadTree = this.locationTree;
        synchronized (quadTree) {
            this.locationTree.removeAll();
            this.objects.clear();
            for (AbstractObject object : this.session.getAllObjects()) {
                GeoLocation gl;
                if (object.getObjectClass() != 2 && object.getObjectClass() != 31 && object.getObjectClass() != 14 && object.getObjectClass() != 5 && object.getObjectClass() != 32 || (gl = object.getGeolocation()).getType() == 0) continue;
                this.objects.put(object.getObjectId(), object);
                this.locationTree.insert(gl.getLatitude(), gl.getLongitude(), object.getObjectId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onObjectChange(AbstractObject object) {
        if (object.getObjectClass() != 2 && object.getObjectClass() != 31 && object.getObjectClass() != 14 && object.getObjectClass() != 5 && object.getObjectClass() != 32) {
            return;
        }
        GeoLocation prevLocation = null;
        boolean cacheChanged = false;
        Object object2 = this.locationTree;
        synchronized (object2) {
            GeoLocation gl = object.getGeolocation();
            if (gl.getType() == 0) {
                AbstractObject prevObject = this.objects.remove(object.getObjectId());
                if (prevObject != null) {
                    prevLocation = prevObject.getGeolocation();
                }
                cacheChanged = this.locationTree.remove(object.getObjectId());
            } else {
                if (!this.objects.containsKey(object.getObjectId())) {
                    this.locationTree.insert(gl.getLatitude(), gl.getLongitude(), object.getObjectId());
                    cacheChanged = true;
                } else {
                    prevLocation = this.objects.get(object.getObjectId()).getGeolocation();
                    if (!gl.equals((Object)prevLocation)) {
                        this.locationTree.remove(object.getObjectId());
                        this.locationTree.insert(gl.getLatitude(), gl.getLongitude(), object.getObjectId());
                        cacheChanged = true;
                    }
                }
                this.objects.put(object.getObjectId(), object);
            }
        }
        if (cacheChanged) {
            object2 = this.listeners;
            synchronized (object2) {
                for (GeoLocationCacheListener l : this.listeners) {
                    l.geoLocationCacheChanged(object, prevLocation);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbstractObject> getObjectsInArea(Area area) {
        ArrayList<AbstractObject> list = null;
        QuadTree<Long> quadTree = this.locationTree;
        synchronized (quadTree) {
            List<Long> idList = this.locationTree.query(area);
            list = new ArrayList<AbstractObject>(idList.size());
            for (Long id : idList) {
                AbstractObject o = this.objects.get(id);
                if (o == null) continue;
                list.add(o);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(GeoLocationCacheListener listener) {
        Set<GeoLocationCacheListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(GeoLocationCacheListener listener) {
        Set<GeoLocationCacheListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    public static Point coordinateToDisplay(GeoLocation location, int zoom) {
        double numberOfTiles = Math.pow(2.0, zoom);
        double x = (location.getLongitude() + 180.0) * (numberOfTiles * 256.0) / 360.0;
        double y = 1.0 - Math.log(Math.tan(0.7853981633974483 + Math.toRadians(location.getLatitude()) / 2.0)) / Math.PI;
        y = y / 2.0 * (numberOfTiles * 256.0);
        return new Point((int)x, (int)y);
    }

    public static GeoLocation displayToCoordinates(Point point, int zoom) {
        double longitude = (double)point.x * (360.0 / (Math.pow(2.0, zoom) * 256.0)) - 180.0;
        double latitude = (1.0 - (double)point.y * (2.0 / (Math.pow(2.0, zoom) * 256.0))) * Math.PI;
        if ((latitude = Math.toDegrees(Math.atan(Math.sinh(latitude)))) <= -89.998) {
            latitude = -89.997;
        }
        return new GeoLocation(latitude, longitude);
    }

    public static Area calculateCoverage(Point mapSize, GeoLocation basePoint, int pointLocation, int zoom) {
        Point bp = GeoLocationCache.coordinateToDisplay(basePoint, zoom);
        GeoLocation topLeft = null;
        GeoLocation bottomRight = null;
        switch (pointLocation) {
            case 0: {
                topLeft = GeoLocationCache.displayToCoordinates(new Point(bp.x - mapSize.x / 2, bp.y - mapSize.y / 2), zoom);
                bottomRight = GeoLocationCache.displayToCoordinates(new Point(bp.x + mapSize.x / 2, bp.y + mapSize.y / 2), zoom);
                break;
            }
            case 1: {
                topLeft = GeoLocationCache.displayToCoordinates(new Point(bp.x, bp.y), zoom);
                bottomRight = GeoLocationCache.displayToCoordinates(new Point(bp.x + mapSize.x, bp.y + mapSize.y), zoom);
                break;
            }
            case 2: {
                topLeft = GeoLocationCache.displayToCoordinates(new Point(bp.x - mapSize.x, bp.y - mapSize.y), zoom);
                bottomRight = GeoLocationCache.displayToCoordinates(new Point(bp.x, bp.y), zoom);
                break;
            }
            default: {
                throw new IllegalArgumentException("pointLocation=" + pointLocation);
            }
        }
        return new Area(topLeft.getLatitude(), topLeft.getLongitude(), bottomRight.getLatitude(), bottomRight.getLongitude());
    }

    public static GeoLocationCache getInstance() {
        return instance;
    }
}

