/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views.helpers;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.JFaceResources;
import org.netxms.client.MacAddress;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapLabelProvider;
import org.netxms.ui.eclipse.networkmaps.views.helpers.NodeLastValuesFigure;
import org.netxms.ui.eclipse.networkmaps.views.helpers.ObjectFigure;

public class ObjectFigureLargeLabel
extends ObjectFigure {
    private static final int BORDER_WIDTH = 2;
    private Label icon;
    private Label name;
    private Label additionalInfo;
    private NodeLastValuesFigure lastValuesFigure;

    public ObjectFigureLargeLabel(NetworkMapObject element, MapLabelProvider labelProvider) {
        super(element, labelProvider);
        DciValue[] values;
        this.setOpaque(true);
        this.setBorder((Border)new MarginBorder(3));
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        layout.numColumns = 2;
        this.setLayoutManager((LayoutManager)layout);
        this.icon = new Label(labelProvider.getImage(element));
        this.icon.setFont(JFaceResources.getDefaultFont());
        this.add((IFigure)this.icon);
        GridData gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.verticalAlignment = 128;
        gd.verticalSpan = 3;
        this.setConstraint((IFigure)this.icon, gd);
        this.name = new Label(this.object.getObjectName());
        this.name.setFont(JFaceResources.getDefaultFont());
        this.name.setLabelAlignment(1);
        this.add((IFigure)this.name);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        gd.grabExcessHorizontalSpace = true;
        this.setConstraint((IFigure)this.name, gd);
        this.additionalInfo = new Label(this.object.getObjectName());
        this.additionalInfo.setLabelAlignment(1);
        this.additionalInfo.setFont(labelProvider.getLabelFont());
        this.add((IFigure)this.additionalInfo);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        gd.grabExcessHorizontalSpace = true;
        this.setConstraint((IFigure)this.additionalInfo, gd);
        StringBuilder sb = new StringBuilder();
        if (this.object instanceof Node && ((Node)this.object).getPrimaryIP().isValidAddress() && !((Node)this.object).getPrimaryIP().getAddress().isAnyLocalAddress()) {
            sb.append(((Node)this.object).getPrimaryIP().getHostAddress());
            MacAddress mac = ((Node)this.object).getPrimaryMAC();
            if (mac != null) {
                sb.append(" (");
                sb.append(mac.toString());
                sb.append(')');
            }
        }
        this.additionalInfo.setText(sb.toString());
        if (this.object instanceof Node && (values = labelProvider.getNodeLastValues(this.object.getObjectId())) != null && values.length > 0) {
            this.lastValuesFigure = new NodeLastValuesFigure(values);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 128;
            gd.grabExcessHorizontalSpace = true;
            this.add((IFigure)this.lastValuesFigure, gd);
        }
        Dimension ls = this.getPreferredSize(-1, -1);
        this.setSize(ls.width, ls.height);
    }

    protected void paintFigure(Graphics gc) {
        gc.setAntialias(1);
        Rectangle rect = new Rectangle(this.getBounds());
        ++rect.x;
        ++rect.y;
        rect.width -= 2;
        rect.height -= 2;
        gc.setLineWidth(2);
        gc.setBackgroundColor(this.isElementSelected() ? SELECTION_COLOR : StatusDisplayInfo.getStatusColor((ObjectStatus)this.object.getStatus()));
        gc.setAlpha(32);
        gc.fillRoundRectangle(rect, 8, 8);
        gc.setAlpha(255);
        gc.setForegroundColor(this.isElementSelected() ? SELECTION_COLOR : StatusDisplayInfo.getStatusColor((ObjectStatus)this.object.getStatus()));
        gc.setLineStyle(this.labelProvider.isElementSelected((NetworkMapElement)this.element) ? 3 : 1);
        gc.drawRoundRectangle(rect, 8, 8);
    }
}

