/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IViewPart;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.client.objects.Subnet;
import org.netxms.ui.eclipse.actions.ExportToCsvAction;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectContextMenu;
import org.netxms.ui.eclipse.objectview.Activator;
import org.netxms.ui.eclipse.objectview.Messages;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.objectview.objecttabs.helpers.NodeListComparator;
import org.netxms.ui.eclipse.objectview.objecttabs.helpers.NodeListLabelProvider;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class NodesTab
extends ObjectTab {
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_IP_ADDRESS = 2;
    public static final int COLUMN_RACK = 3;
    public static final int COLUMN_PLATFORM = 4;
    public static final int COLUMN_AGENT_VERSION = 5;
    public static final int COLUMN_SYS_DESCRIPTION = 6;
    public static final int COLUMN_STATUS = 7;
    private SortableTableViewer viewer;
    private Action actionExportToCsv;

    @Override
    protected void createTabContent(Composite parent) {
        String[] stringArray = new String[8];
        Messages.get();
        stringArray[0] = Messages.NodesTab_ColId;
        Messages.get();
        stringArray[1] = Messages.NodesTab_ColName;
        Messages.get();
        stringArray[2] = Messages.NodesTab_ColPrimaryIP;
        Messages.get();
        stringArray[3] = Messages.NodesTab_ColRack;
        Messages.get();
        stringArray[4] = Messages.NodesTab_ColPlatform;
        Messages.get();
        stringArray[5] = Messages.NodesTab_ColAgentVersion;
        Messages.get();
        stringArray[6] = Messages.NodesTab_ColSysDescr;
        Messages.get();
        stringArray[7] = Messages.NodesTab_ColStatus;
        String[] names = stringArray;
        int[] widths = new int[]{60, 150, 100, 150, 150, 100, 300, 100};
        this.viewer = new SortableTableViewer(parent, names, widths, 1, 128, 65538);
        this.viewer.setLabelProvider((IBaseLabelProvider)new NodeListLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new NodeListComparator());
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"NodeTable.V2");
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveColumnSettings((Table)NodesTab.this.viewer.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"NodeTable.V2");
            }
        });
        this.createActions();
        this.createPopupMenu();
    }

    private void createActions() {
        this.actionExportToCsv = new ExportToCsvAction((IViewPart)this.getViewPart(), (ColumnViewer)this.viewer, true);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                NodesTab.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        if (this.getViewPart() != null) {
            this.getViewPart().getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExportToCsv);
        manager.add((IContributionItem)new Separator());
        ObjectContextMenu.fill((IMenuManager)manager, (IShellProvider)this.getViewPart().getSite(), (ISelectionProvider)this.viewer);
    }

    @Override
    public void currentObjectUpdated(AbstractObject object) {
        this.objectChanged(object);
    }

    @Override
    public void refresh() {
        if (this.getObject() != null) {
            if (this.getObject() instanceof Subnet) {
                this.viewer.setInput((Object)this.getObject().getChildsAsArray());
            } else {
                ArrayList<AbstractObject> list = new ArrayList<AbstractObject>();
                AbstractObject[] abstractObjectArray = this.getObject().getChildsAsArray();
                int n = abstractObjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    AbstractObject o = abstractObjectArray[n2];
                    if (o instanceof AbstractNode) {
                        list.add(o);
                    }
                    ++n2;
                }
                this.viewer.setInput((Object)list.toArray());
            }
        } else {
            this.viewer.setInput((Object)new AbstractNode[0]);
        }
    }

    @Override
    public void objectChanged(AbstractObject object) {
        this.refresh();
    }

    @Override
    public boolean showForObject(AbstractObject object) {
        return object instanceof Subnet || object instanceof Cluster || object instanceof Container || object instanceof ServiceRoot || object instanceof Rack;
    }
}

