/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.format;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.util.Date;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.IFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.core.format.StringFormatter;

public class AutoFormatter
implements IFormatter {
    private String pattern;
    private ULocale locale;
    private TimeZone timeZone;
    private IFormatter directFormatter = null;
    private DateFormatter defaultDateFormatter;

    public AutoFormatter(String pattern, ULocale locale, TimeZone timeZone) {
        this.pattern = pattern;
        this.locale = locale;
        this.timeZone = timeZone;
    }

    public AutoFormatter(String pattern, ULocale locale, TimeZone timeZone, DateFormatter defaultDateFormatter) {
        this(pattern, locale, timeZone);
        this.defaultDateFormatter = defaultDateFormatter;
    }

    public String formatValue(Object value) throws BirtException {
        if (this.directFormatter == null) {
            this.directFormatter = value instanceof Date ? (this.pattern != null || this.defaultDateFormatter == null ? new DateFormatter(this.pattern, this.locale, this.timeZone) : this.defaultDateFormatter) : (value instanceof Number ? new NumberFormatter(this.pattern, this.locale) : (this.pattern != null && value instanceof String ? new StringFormatter(this.pattern, this.locale) : new IFormatter.DefaultFormatter(this.locale)));
        }
        return this.directFormatter.formatValue(value);
    }
}

