/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.python.core.AbstractDict;
import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinClassMethodNarrow;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyDataDescr;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyIterator;
import org.python.core.PyList;
import org.python.core.PyMapEntrySet;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyStringMap$viewitems_exposer;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.ThreadState;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@ExposedType(name="stringmap", base=PyObject.class, isBaseType=false)
public class PyStringMap
extends AbstractDict
implements Traverseproc {
    private static PyType lazyType;
    private final ConcurrentMap<Object, PyObject> table;

    public ConcurrentMap<Object, PyObject> getMap() {
        return this.table;
    }

    public PyStringMap() {
        this(4);
    }

    public PyStringMap(int capacity) {
        super(PyStringMap.getLazyType());
        this.table = new ConcurrentHashMap<Object, PyObject>(capacity, 0.75f, 2);
    }

    public PyStringMap(Map<Object, PyObject> map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16));
        this.table.putAll(map);
    }

    public PyStringMap(PyObject[] elements) {
        this(elements.length);
        for (int i = 0; i < elements.length; i += 2) {
            this.__setitem__(elements[i], elements[i + 1]);
        }
    }

    private static PyType getLazyType() {
        if (lazyType == null) {
            lazyType = PyType.fromClass(PyStringMap.class);
        }
        return lazyType;
    }

    @ExposedNew
    static final PyObject stringmap_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        PyStringMap map = new PyStringMap();
        map.stringmap_update(args, keywords);
        return map;
    }

    public static PyObject fromkeys(PyObject keys) {
        return PyStringMap.fromkeys(keys, Py.None);
    }

    public static PyObject fromkeys(PyObject keys, PyObject value) {
        return PyStringMap.stringmap_fromkeys(TYPE, keys, value);
    }

    static PyObject stringmap_fromkeys(PyType type, PyObject keys, PyObject value) {
        PyObject d = type.__call__();
        for (PyObject o : keys.asIterable()) {
            d.__setitem__(o, value);
        }
        return d;
    }

    @Override
    public int __len__() {
        return this.stringmap___len__();
    }

    final int stringmap___len__() {
        return this.table.size();
    }

    @Override
    public boolean __nonzero__() {
        return this.table.size() != 0;
    }

    @Override
    public PyObject __finditem__(String key) {
        if (key == null) {
            return null;
        }
        return (PyObject)this.table.get(key);
    }

    @Override
    public PyObject __finditem__(PyObject key) {
        if (key instanceof PyString) {
            return this.__finditem__(((PyString)key).internedString());
        }
        return (PyObject)this.table.get(key);
    }

    public PyObject __getitem__(String key) {
        PyObject o = this.__finditem__(key);
        if (null == o) {
            throw Py.KeyError(key);
        }
        return o;
    }

    @Override
    public PyObject __getitem__(PyObject key) {
        return this.stringmap___getitem__(key);
    }

    final PyObject stringmap___getitem__(PyObject key) {
        if (key instanceof PyString) {
            return this.__getitem__(((PyString)key).internedString());
        }
        PyObject o = this.__finditem__(key);
        if (null == o) {
            throw Py.KeyError(key);
        }
        return o;
    }

    @Override
    public PyObject __iter__() {
        return this.stringmap___iter__();
    }

    final PyObject stringmap___iter__() {
        return this.stringmap_iterkeys();
    }

    @Override
    public void __setitem__(String key, PyObject value) {
        if (value == null) {
            this.table.remove(key);
        } else {
            this.table.put(key, value);
        }
    }

    @Override
    public void __setitem__(PyObject key, PyObject value) {
        this.stringmap___setitem__(key, value);
    }

    final void stringmap___setitem__(PyObject key, PyObject value) {
        if (value == null) {
            this.table.remove(PyStringMap.pyToKey(key));
        } else if (key instanceof PyString) {
            this.__setitem__(((PyString)key).internedString(), value);
        } else {
            this.table.put(key, value);
        }
    }

    @Override
    public void __delitem__(String key) {
        Object ret = this.table.remove(key);
        if (ret == null) {
            throw Py.KeyError(key);
        }
    }

    @Override
    public void __delitem__(PyObject key) {
        this.stringmap___delitem__(key);
    }

    final void stringmap___delitem__(PyObject key) {
        if (key instanceof PyString) {
            this.__delitem__(((PyString)key).internedString());
        } else {
            Object ret = this.table.remove(key);
            if (ret == null) {
                throw Py.KeyError(key);
            }
        }
    }

    @Override
    public void clear() {
        this.stringmap_clear();
    }

    final void stringmap_clear() {
        this.table.clear();
    }

    @Override
    public String toString() {
        return this.stringmap_toString();
    }

    final String stringmap_toString() {
        ThreadState ts = Py.getThreadState();
        if (!ts.enterRepr(this)) {
            return "{...}";
        }
        StringBuilder buf = new StringBuilder("{");
        for (Map.Entry entry : this.table.entrySet()) {
            Object key = entry.getKey();
            if (key instanceof String) {
                buf.append(new PyString((String)key).__repr__().toString());
            } else {
                buf.append(((PyObject)key).__repr__().toString());
            }
            buf.append(": ");
            buf.append(((PyObject)entry.getValue()).__repr__().toString());
            buf.append(", ");
        }
        if (buf.length() > 1) {
            buf.delete(buf.length() - 2, buf.length());
        }
        buf.append("}");
        ts.exitRepr(this);
        return buf.toString();
    }

    @Override
    public int __cmp__(PyObject other) {
        return this.stringmap___cmp__(other);
    }

    final int stringmap___cmp__(PyObject other) {
        int bn;
        if (!(other instanceof PyStringMap) && !(other instanceof PyDictionary)) {
            return -2;
        }
        int an = this.__len__();
        if (an < (bn = other.__len__())) {
            return -1;
        }
        if (an > bn) {
            return 1;
        }
        PyList akeys = this.keys();
        PyList bkeys = null;
        bkeys = other instanceof PyStringMap ? ((PyStringMap)other).keys() : ((PyDictionary)other).keys();
        akeys.sort();
        bkeys.sort();
        for (int i = 0; i < bn; ++i) {
            PyObject bvalue;
            PyObject bkey;
            PyObject akey = akeys.pyget(i);
            int c = akey._cmp(bkey = bkeys.pyget(i));
            if (c != 0) {
                return c;
            }
            PyObject avalue = this.__finditem__(akey);
            c = avalue._cmp(bvalue = other.__finditem__(bkey));
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    public boolean has_key(String key) {
        return this.table.containsKey(key);
    }

    @Override
    public boolean has_key(PyObject key) {
        return this.stringmap_has_key(key);
    }

    final boolean stringmap_has_key(PyObject key) {
        return this.table.containsKey(PyStringMap.pyToKey(key));
    }

    @Override
    public boolean __contains__(PyObject o) {
        return this.stringmap___contains__(o);
    }

    final boolean stringmap___contains__(PyObject o) {
        return this.stringmap_has_key(o);
    }

    @Override
    public PyObject get(PyObject key, PyObject defaultObj) {
        return this.stringmap_get(key, defaultObj);
    }

    final PyObject stringmap_get(PyObject key, PyObject defaultObj) {
        PyObject obj = this.__finditem__(key);
        return obj == null ? defaultObj : obj;
    }

    @Override
    public PyObject get(PyObject key) {
        return this.stringmap_get(key, Py.None);
    }

    @Override
    public PyStringMap copy() {
        return this.stringmap_copy();
    }

    final PyStringMap stringmap_copy() {
        return new PyStringMap(this.table);
    }

    @Override
    public void update(PyObject other) {
        this.stringmap_update(new PyObject[]{other}, Py.NoKeywords);
    }

    final void stringmap_update(PyObject[] args, String[] keywords) {
        int nargs = args.length - keywords.length;
        if (nargs > 1) {
            throw PyBuiltinCallable.DefaultInfo.unexpectedCall(nargs, false, "update", 0, 1);
        }
        if (nargs == 1) {
            PyObject arg = args[0];
            if (arg.__findattr__("keys") != null) {
                this.merge(arg);
            } else {
                this.mergeFromSeq(arg);
            }
        }
        for (int i = 0; i < keywords.length; ++i) {
            this.__setitem__(keywords[i], args[nargs + i]);
        }
    }

    private void merge(PyObject other) {
        if (other instanceof PyStringMap) {
            this.table.putAll(((PyStringMap)other).table);
        } else if (other instanceof PyDictionary) {
            this.mergeFromKeys(other, ((PyDictionary)other).keys());
        } else {
            this.mergeFromKeys(other, other.invoke("keys"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(PyObject other, boolean override) {
        ConcurrentMap<Object, PyObject> concurrentMap = this.table;
        synchronized (concurrentMap) {
            if (override) {
                this.merge(other);
            } else if (other instanceof PyStringMap) {
                Set entrySet = ((PyStringMap)other).table.entrySet();
                for (Map.Entry ent : entrySet) {
                    if (this.table.containsKey(ent.getKey())) continue;
                    this.table.put(ent.getKey(), (PyObject)ent.getValue());
                }
            } else if (other instanceof PyDictionary) {
                this.mergeFromKeys(other, ((PyDictionary)other).keys(), override);
            } else {
                this.mergeFromKeys(other, other.invoke("keys"), override);
            }
        }
    }

    private void mergeFromKeys(PyObject other, PyObject keys) {
        for (PyObject key : keys.asIterable()) {
            this.__setitem__(key, other.__getitem__(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeFromKeys(PyObject other, PyObject keys, boolean override) {
        ConcurrentMap<Object, PyObject> concurrentMap = this.table;
        synchronized (concurrentMap) {
            if (override) {
                this.mergeFromKeys(other, keys);
            } else {
                for (PyObject key : keys.asIterable()) {
                    if (this.__contains__(key)) continue;
                    this.__setitem__(key, other.__getitem__(key));
                }
            }
        }
    }

    private void mergeFromSeq(PyObject other) {
        PyObject pair;
        PyObject pairs = other.__iter__();
        int i = 0;
        while ((pair = pairs.__iternext__()) != null) {
            try {
                pair = PySequence.fastSequence(pair, "");
            }
            catch (PyException pye) {
                if (pye.match(Py.TypeError)) {
                    throw Py.TypeError(String.format("cannot convert dictionary update sequence element #%d to a sequence", i));
                }
                throw pye;
            }
            int n = pair.__len__();
            if (n != 2) {
                throw Py.ValueError(String.format("dictionary update sequence element #%d has length %d; 2 is required", i, n));
            }
            this.__setitem__(pair.__getitem__(0), pair.__getitem__(1));
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeFromSeq(PyObject other, boolean override) {
        ConcurrentMap<Object, PyObject> concurrentMap = this.table;
        synchronized (concurrentMap) {
            if (override) {
                this.mergeFromSeq(other);
            } else {
                PyObject pair;
                PyObject pairs = other.__iter__();
                int i = 0;
                while ((pair = pairs.__iternext__()) != null) {
                    try {
                        pair = PySequence.fastSequence(pair, "");
                    }
                    catch (PyException pye) {
                        if (pye.match(Py.TypeError)) {
                            throw Py.TypeError(String.format("cannot convert dictionary update sequence element #%d to a sequence", i));
                        }
                        throw pye;
                    }
                    int n = pair.__len__();
                    if (n != 2) {
                        throw Py.ValueError(String.format("dictionary update sequence element #%d has length %d; 2 is required", i, n));
                    }
                    if (!this.__contains__(pair.__getitem__(0))) {
                        this.__setitem__(pair.__getitem__(0), pair.__getitem__(1));
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public PyObject setdefault(PyObject key) {
        return this.setdefault(key, Py.None);
    }

    @Override
    public PyObject setdefault(PyObject key, PyObject failobj) {
        return this.stringmap_setdefault(key, failobj);
    }

    final PyObject stringmap_setdefault(PyObject key, PyObject failobj) {
        PyObject internedKey = key instanceof PyString ? ((PyString)key).internedString() : key;
        PyObject oldValue = this.table.putIfAbsent(internedKey, failobj);
        return oldValue == null ? failobj : oldValue;
    }

    @Override
    public PyObject popitem() {
        return this.stringmap_popitem();
    }

    final PyObject stringmap_popitem() {
        Iterator it = this.table.entrySet().iterator();
        if (!it.hasNext()) {
            throw Py.KeyError("popitem(): dictionary is empty");
        }
        PyTuple tuple = this.itemTuple(it.next());
        it.remove();
        return tuple;
    }

    @Override
    public PyObject pop(PyObject key) {
        if (this.table.size() == 0) {
            throw Py.KeyError("pop(): dictionary is empty");
        }
        return this.stringmap_pop(key, null);
    }

    @Override
    public PyObject pop(PyObject key, PyObject failobj) {
        return this.stringmap_pop(key, failobj);
    }

    final PyObject stringmap_pop(PyObject key, PyObject failobj) {
        PyObject value = (PyObject)this.table.remove(PyStringMap.pyToKey(key));
        if (value == null) {
            if (failobj == null) {
                throw Py.KeyError(key);
            }
            return failobj;
        }
        return value;
    }

    @Override
    public PyList items() {
        return this.stringmap_items();
    }

    final PyList stringmap_items() {
        return new PyList(this.stringmap_iteritems());
    }

    private PyTuple itemTuple(Map.Entry<Object, PyObject> entry) {
        return new PyTuple(PyStringMap.keyToPy(entry.getKey()), entry.getValue());
    }

    @Override
    public PyList keys() {
        return this.stringmap_keys();
    }

    final PyList stringmap_keys() {
        PyObject[] keyArray = new PyObject[this.table.size()];
        int i = 0;
        for (Object key : this.table.keySet()) {
            keyArray[i++] = PyStringMap.keyToPy(key);
        }
        return new PyList(keyArray);
    }

    public PyList values() {
        return this.stringmap_values();
    }

    final PyList stringmap_values() {
        return new PyList(this.table.values());
    }

    @Override
    public PyObject iteritems() {
        return this.stringmap_iteritems();
    }

    final PyObject stringmap_iteritems() {
        return new ItemsIter(this.table.entrySet());
    }

    @Override
    public PyObject iterkeys() {
        return this.stringmap_iterkeys();
    }

    final PyObject stringmap_iterkeys() {
        return new KeysIter(this.table.keySet());
    }

    @Override
    public PyObject itervalues() {
        return this.stringmap_itervalues();
    }

    final PyObject stringmap_itervalues() {
        return new StringMapValuesIter(this.table.values());
    }

    @Override
    public int hashCode() {
        return this.stringmap___hash__();
    }

    final int stringmap___hash__() {
        throw Py.TypeError(String.format("unhashable type: '%.200s'", this.getType().fastGetName()));
    }

    @Override
    public boolean isMappingType() {
        return true;
    }

    @Override
    public boolean isSequenceType() {
        return false;
    }

    private static PyObject keyToPy(Object objKey) {
        if (objKey instanceof String) {
            return PyString.fromInterned((String)objKey);
        }
        return (PyObject)objKey;
    }

    private static Object pyToKey(PyObject pyKey) {
        if (pyKey instanceof PyString) {
            return ((PyString)pyKey).internedString();
        }
        return pyKey;
    }

    @Override
    public Set<PyObject> pyKeySet() {
        return new PyStringMapKeySetWrapper(this.table.keySet());
    }

    @Override
    public Set entrySet() {
        return new PyMapEntrySet(this.getMap().entrySet());
    }

    @Override
    public PyObject viewkeys() {
        return super.viewkeys();
    }

    @Override
    public PyObject viewitems() {
        return super.viewitems();
    }

    @Override
    public PyObject viewvalues() {
        return super.viewvalues();
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        for (Map.Entry ent : this.table.entrySet()) {
            int retVal;
            Object key = ent.getKey();
            PyObject value = (PyObject)ent.getValue();
            if (key instanceof PyObject && (retVal = visit.visit((PyObject)key, arg)) != 0) {
                return retVal;
            }
            if (value == null || (retVal = visit.visit(value, arg)) == 0) continue;
            return retVal;
        }
        return 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && (this.table.containsKey(ob) || this.table.containsValue(ob));
    }

    static {
        PyType.addBuilder(PyStringMap.class, new PyStringMap$PyExposer());
    }

    private static class PyStringMapKeySetWrapper
    extends AbstractSet<PyObject> {
        Set<Object> backend;

        PyStringMapKeySetWrapper(Set<Object> backend) {
            this.backend = backend;
        }

        @Override
        public Iterator<PyObject> iterator() {
            return new PyStringMapKeySetIter(this.backend.iterator());
        }

        @Override
        public int size() {
            return this.backend.size();
        }

        class PyStringMapKeySetIter
        implements Iterator<PyObject> {
            Iterator<Object> itr;

            PyStringMapKeySetIter(Iterator<Object> itr) {
                this.itr = itr;
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public PyObject next() {
                return PyStringMap.keyToPy(this.itr.next());
            }

            @Override
            public void remove() {
                this.itr.remove();
            }
        }
    }

    private class ItemsIter
    extends StringMapIter<Map.Entry<Object, PyObject>> {
        public ItemsIter(Set<Map.Entry<Object, PyObject>> s) {
            super(s);
        }

        @Override
        public PyObject stringMapNext() {
            return PyStringMap.this.itemTuple((Map.Entry)this.iterator.next());
        }
    }

    private class KeysIter
    extends StringMapIter<Object> {
        public KeysIter(Set<Object> s) {
            super(s);
        }

        @Override
        protected PyObject stringMapNext() {
            return PyStringMap.keyToPy(this.iterator.next());
        }
    }

    private class StringMapValuesIter
    extends StringMapIter<PyObject> {
        public StringMapValuesIter(Collection<PyObject> c) {
            super(c);
        }

        @Override
        public PyObject stringMapNext() {
            return (PyObject)this.iterator.next();
        }
    }

    private abstract class StringMapIter<T>
    extends PyIterator {
        protected final Iterator<T> iterator;
        private final int size;

        public StringMapIter(Collection<T> c) {
            this.iterator = c.iterator();
            this.size = c.size();
        }

        @Override
        public PyObject __iternext__() {
            if (PyStringMap.this.table.size() != this.size) {
                throw Py.RuntimeError("dictionary changed size during iteration");
            }
            if (!this.iterator.hasNext()) {
                return null;
            }
            return this.stringMapNext();
        }

        protected abstract PyObject stringMapNext();
    }

    public class PyStringMap$stringmap_fromkeys_exposer
    extends PyBuiltinClassMethodNarrow {
        public PyStringMap$stringmap_fromkeys_exposer(String string2) {
            super(string2, 2, 3);
            this.doc = "dict.fromkeys(S[,v]) -> New dict with keys from S and values equal to v.\nv defaults to None.";
        }

        public PyStringMap$stringmap_fromkeys_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "dict.fromkeys(S[,v]) -> New dict with keys from S and values equal to v.\nv defaults to None.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyStringMap$stringmap_fromkeys_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return PyStringMap.stringmap_fromkeys((PyType)this.self, pyObject, pyObject2);
        }

        public PyObject __call__(PyObject pyObject) {
            return PyStringMap.stringmap_fromkeys((PyType)this.self, pyObject, Py.None);
        }
    }

    public class PyStringMap$stringmap___len___exposer
    extends PyBuiltinMethodNarrow {
        public PyStringMap$stringmap___len___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__len__() <==> len(x)";
        }

        public PyStringMap$stringmap___len___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__len__() <==> len(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyStringMap$stringmap___len___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newInteger(((PyStringMap)this.self).stringmap___len__());
        }
    }

    public class PyStringMap$stringmap___getitem___exposer
    extends PyBuiltinMethodNarrow {
        public PyStringMap$stringmap___getitem___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__getitem__(y) <==> x[y]";
        }

        public PyStringMap$stringmap___getitem___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getitem__(y) <==> x[y]";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyStringMap$stringmap___getitem___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyStringMap)this.self).stringmap___getitem__(pyObject);
        }
    }

    public class PyStringMap$stringmap___iter___exposer
    extends PyBuiltinMethodNarrow {
        public PyStringMap$stringmap___iter___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__iter__() <==> iter(x)";
        }

        public PyStringMap$stringmap___iter___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__iter__() <==> iter(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyStringMap$stringmap___iter___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyStringMap)this.self).stringmap___iter__();
        }
    }

    public class PyStringMap$stringmap___setitem___exposer
    extends PyBuiltinMethodNarrow {
        public PyStringMap$stringmap___setitem___exposer(String string2) {
            super(string2, 3, 3);
            this.doc = "x.__setitem__(i, y) <==> x[i]=y";
        }

        public PyStringMap$stringmap___setitem___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__setitem__(i, y) <==> x[i]=y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyStringMap$stringmap___setitem___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            ((PyStringMap)this.self).stringmap___setitem__(pyObject, pyObject2);
            return Py.None;
        }
    }

    public class PyStringMap$stringmap___delitem___exposer
    extends PyBuiltinMethodNarrow {
        public PyStringMap$stringmap___delitem___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__delitem__(y) <==> del x[y]";
        }

        public PyStringMap$stringmap___delitem___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__delitem__(y) <==> del x[y]";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyStringMap$stringmap___delitem___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyStringMap)this.self).stringmap___delitem__(pyObject);
            return Py.None;
        }
    }

    public class PyStringMap$stringmap_clear_exposer
    extends PyBuiltinMethodNarrow {
        public PyStringMap$stringmap_clear_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "D.clear() -> None.  Remove all items from D.";
        }

        public PyStringMap$stringmap_clear_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "D.clear() -> None.  Remove all items from D.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyStringMap$stringmap_clear_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            ((PyStringMap)this.self).stringmap_clear();
            return Py.None;
        }
    }

    public class PyStringMap$stringmap_toString_exposer
    extends PyBuiltinMethodNarrow {
        public PyStringMap$stringmap_toString_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "x.__str__() <==> str(x)";
        }

        public PyStringMap$stringmap_toString_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__str__() <==> str(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyStringMap$stringmap_toString_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            String string2 = ((PyStringMap)this.self).stringmap_toString();
            return string2 == null ? Py.None : Py.newString(string2);
        }
    }

    public class PyStringMap$stringmap___cmp___exposer
    extends PyBuiltinMethodNarrow {
        public PyStringMap$stringmap___cmp___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "x.__cmp__(y) <==> cmp(x,y)";
        }

        public PyStringMap$stringmap___cmp___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__cmp__(y) <==> cmp(x,y)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyStringMap$stringmap___cmp___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            int n = ((PyStringMap)this.self).stringmap___cmp__(pyObject);
            if (n == -2) {
                throw Py.TypeError("stringmap.__cmp__(x,y) requires y to be 'stringmap', not a '" + pyObject.getType().fastGetName() + "'");
            }
            return Py.newInteger(n);
        }
    }

    public class PyStringMap$stringmap_has_key_exposer
    extends PyBuiltinMethodNarrow {
        public PyStringMap$stringmap_has_key_exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "D.has_key(k) -> True if D has a key k, else False";
        }

        public PyStringMap$stringmap_has_key_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "D.has_key(k) -> True if D has a key k, else False";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyStringMap$stringmap_has_key_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newBoolean(((PyStringMap)this.self).stringmap_has_key(pyObject));
        }
    }

    public class PyStringMap$stringmap___contains___exposer
    extends PyBuiltinMethodNarrow {
        public PyStringMap$stringmap___contains___exposer(String string2) {
            super(string2, 2, 2);
            this.doc = "D.__contains__(k) -> True if D has a key k, else False";
        }

        public PyStringMap$stringmap___contains___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "D.__contains__(k) -> True if D has a key k, else False";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyStringMap$stringmap___contains___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newBoolean(((PyStringMap)this.self).stringmap___contains__(pyObject));
        }
    }

    public class PyStringMap$stringmap_get_exposer
    extends PyBuiltinMethodNarrow {
        public PyStringMap$stringmap_get_exposer(String string2) {
            super(string2, 2, 3);
            this.doc = "D.get(k[,d]) -> D[k] if k in D, else d.  d defaults to None.";
        }

        public PyStringMap$stringmap_get_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "D.get(k[,d]) -> D[k] if k in D, else d.  d defaults to None.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyStringMap$stringmap_get_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((PyStringMap)this.self).stringmap_get(pyObject, pyObject2);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyStringMap)this.self).stringmap_get(pyObject, Py.None);
        }
    }

    public class PyStringMap$stringmap_copy_exposer
    extends PyBuiltinMethodNarrow {
        public PyStringMap$stringmap_copy_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "D.copy() -> a shallow copy of D";
        }

        public PyStringMap$stringmap_copy_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "D.copy() -> a shallow copy of D";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyStringMap$stringmap_copy_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyStringMap)this.self).stringmap_copy();
        }
    }

    public class PyStringMap$stringmap_update_exposer
    extends PyBuiltinMethod {
        public PyStringMap$stringmap_update_exposer(String string2) {
            super(string2);
            this.doc = "D.update(E, **F) -> None.  Update D from dict/iterable E and F.\nIf E has a .keys() method, does:     for k in E: D[k] = E[k]\nIf E lacks .keys() method, does:     for (k, v) in E: D[k] = v\nIn either case, this is followed by: for k in F: D[k] = F[k]";
        }

        public PyStringMap$stringmap_update_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "D.update(E, **F) -> None.  Update D from dict/iterable E and F.\nIf E has a .keys() method, does:     for k in E: D[k] = E[k]\nIf E lacks .keys() method, does:     for (k, v) in E: D[k] = v\nIn either case, this is followed by: for k in F: D[k] = F[k]";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyStringMap$stringmap_update_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            ((PyStringMap)this.self).stringmap_update(pyObjectArray, stringArray);
            return Py.None;
        }
    }

    public class PyStringMap$stringmap_setdefault_exposer
    extends PyBuiltinMethodNarrow {
        public PyStringMap$stringmap_setdefault_exposer(String string2) {
            super(string2, 2, 3);
            this.doc = "D.setdefault(k[,d]) -> D.get(k,d), also set D[k]=d if k not in D";
        }

        public PyStringMap$stringmap_setdefault_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "D.setdefault(k[,d]) -> D.get(k,d), also set D[k]=d if k not in D";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyStringMap$stringmap_setdefault_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((PyStringMap)this.self).stringmap_setdefault(pyObject, pyObject2);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyStringMap)this.self).stringmap_setdefault(pyObject, Py.None);
        }
    }

    public class PyStringMap$stringmap_popitem_exposer
    extends PyBuiltinMethodNarrow {
        public PyStringMap$stringmap_popitem_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "D.popitem() -> (k, v), remove and return some (key, value) pair as a\n2-tuple; but raise KeyError if D is empty.";
        }

        public PyStringMap$stringmap_popitem_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "D.popitem() -> (k, v), remove and return some (key, value) pair as a\n2-tuple; but raise KeyError if D is empty.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyStringMap$stringmap_popitem_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyStringMap)this.self).stringmap_popitem();
        }
    }

    public class PyStringMap$stringmap_pop_exposer
    extends PyBuiltinMethodNarrow {
        public PyStringMap$stringmap_pop_exposer(String string2) {
            super(string2, 2, 3);
            this.doc = "D.pop(k[,d]) -> v, remove specified key and return the corresponding value.\nIf key is not found, d is returned if given, otherwise KeyError is raised";
        }

        public PyStringMap$stringmap_pop_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "D.pop(k[,d]) -> v, remove specified key and return the corresponding value.\nIf key is not found, d is returned if given, otherwise KeyError is raised";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyStringMap$stringmap_pop_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((PyStringMap)this.self).stringmap_pop(pyObject, pyObject2);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyStringMap)this.self).stringmap_pop(pyObject, null);
        }
    }

    public class PyStringMap$stringmap_items_exposer
    extends PyBuiltinMethodNarrow {
        public PyStringMap$stringmap_items_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "D.items() -> list of D's (key, value) pairs, as 2-tuples";
        }

        public PyStringMap$stringmap_items_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "D.items() -> list of D's (key, value) pairs, as 2-tuples";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyStringMap$stringmap_items_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyStringMap)this.self).stringmap_items();
        }
    }

    public class PyStringMap$stringmap_keys_exposer
    extends PyBuiltinMethodNarrow {
        public PyStringMap$stringmap_keys_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "D.keys() -> list of D's keys";
        }

        public PyStringMap$stringmap_keys_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "D.keys() -> list of D's keys";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyStringMap$stringmap_keys_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyStringMap)this.self).stringmap_keys();
        }
    }

    public class PyStringMap$stringmap_values_exposer
    extends PyBuiltinMethodNarrow {
        public PyStringMap$stringmap_values_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "D.values() -> list of D's values";
        }

        public PyStringMap$stringmap_values_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "D.values() -> list of D's values";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyStringMap$stringmap_values_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyStringMap)this.self).stringmap_values();
        }
    }

    public class PyStringMap$stringmap_iteritems_exposer
    extends PyBuiltinMethodNarrow {
        public PyStringMap$stringmap_iteritems_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "D.iteritems() -> an iterator over the (key, value) items of D";
        }

        public PyStringMap$stringmap_iteritems_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "D.iteritems() -> an iterator over the (key, value) items of D";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyStringMap$stringmap_iteritems_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyStringMap)this.self).stringmap_iteritems();
        }
    }

    public class PyStringMap$stringmap_iterkeys_exposer
    extends PyBuiltinMethodNarrow {
        public PyStringMap$stringmap_iterkeys_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "D.iterkeys() -> an iterator over the keys of D";
        }

        public PyStringMap$stringmap_iterkeys_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "D.iterkeys() -> an iterator over the keys of D";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyStringMap$stringmap_iterkeys_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyStringMap)this.self).stringmap_iterkeys();
        }
    }

    public class PyStringMap$stringmap_itervalues_exposer
    extends PyBuiltinMethodNarrow {
        public PyStringMap$stringmap_itervalues_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "D.itervalues() -> an iterator over the values of D";
        }

        public PyStringMap$stringmap_itervalues_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "D.itervalues() -> an iterator over the values of D";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyStringMap$stringmap_itervalues_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyStringMap)this.self).stringmap_itervalues();
        }
    }

    public class PyStringMap$stringmap___hash___exposer
    extends PyBuiltinMethodNarrow {
        public PyStringMap$stringmap___hash___exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "";
        }

        public PyStringMap$stringmap___hash___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyStringMap$stringmap___hash___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newInteger(((PyStringMap)this.self).stringmap___hash__());
        }
    }

    public class PyStringMap$viewkeys_exposer
    extends PyBuiltinMethodNarrow {
        public PyStringMap$viewkeys_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "D.viewkeys() -> a set-like object providing a view on D's keys";
        }

        public PyStringMap$viewkeys_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "D.viewkeys() -> a set-like object providing a view on D's keys";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyStringMap$viewkeys_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyStringMap)this.self).viewkeys();
        }
    }

    public class PyStringMap$viewvalues_exposer
    extends PyBuiltinMethodNarrow {
        public PyStringMap$viewvalues_exposer(String string2) {
            super(string2, 1, 1);
            this.doc = "D.viewvalues() -> an object providing a view on D's values";
        }

        public PyStringMap$viewvalues_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "D.viewvalues() -> an object providing a view on D's values";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyStringMap$viewvalues_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyStringMap)this.self).viewvalues();
        }
    }

    public class PyStringMap$exposed___new__
    extends PyNewWrapper {
        public PyObject new_impl(boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
            return PyStringMap.stringmap_new(this, bl, pyType, pyObjectArray, stringArray);
        }
    }

    public class PyStringMap$PyExposer
    extends BaseTypeBuilder {
        public PyStringMap$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PyStringMap$stringmap_fromkeys_exposer("fromkeys"), new PyStringMap$stringmap___len___exposer("__len__"), new PyStringMap$stringmap___getitem___exposer("__getitem__"), new PyStringMap$stringmap___iter___exposer("__iter__"), new PyStringMap$stringmap___setitem___exposer("__setitem__"), new PyStringMap$stringmap___delitem___exposer("__delitem__"), new PyStringMap$stringmap_clear_exposer("clear"), new PyStringMap$stringmap_toString_exposer("__repr__"), new PyStringMap$stringmap_toString_exposer("__str__"), new PyStringMap$stringmap___cmp___exposer("__cmp__"), new PyStringMap$stringmap_has_key_exposer("has_key"), new PyStringMap$stringmap___contains___exposer("__contains__"), new PyStringMap$stringmap_get_exposer("get"), new PyStringMap$stringmap_copy_exposer("copy"), new PyStringMap$stringmap_update_exposer("update"), new PyStringMap$stringmap_setdefault_exposer("setdefault"), new PyStringMap$stringmap_popitem_exposer("popitem"), new PyStringMap$stringmap_pop_exposer("pop"), new PyStringMap$stringmap_items_exposer("items"), new PyStringMap$stringmap_keys_exposer("keys"), new PyStringMap$stringmap_values_exposer("values"), new PyStringMap$stringmap_iteritems_exposer("iteritems"), new PyStringMap$stringmap_iterkeys_exposer("iterkeys"), new PyStringMap$stringmap_itervalues_exposer("itervalues"), new PyStringMap$stringmap___hash___exposer("__hash__"), new PyStringMap$viewkeys_exposer("viewkeys"), new PyStringMap$viewitems_exposer("viewitems"), new PyStringMap$viewvalues_exposer("viewvalues")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
            super("stringmap", PyStringMap.class, PyObject.class, false, null, pyBuiltinMethodArray, pyDataDescrArray, new PyStringMap$exposed___new__());
        }
    }
}

