/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl.coll;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.MissingResourceException;
import org.python.icu.impl.ICUBinary;
import org.python.icu.impl.coll.CollationData;
import org.python.icu.impl.coll.CollationDataReader;
import org.python.icu.impl.coll.CollationSettings;
import org.python.icu.impl.coll.CollationTailoring;

public final class CollationRoot {
    private static final CollationTailoring rootSingleton;
    private static final RuntimeException exception;

    public static final CollationTailoring getRoot() {
        if (exception != null) {
            throw exception;
        }
        return rootSingleton;
    }

    public static final CollationData getData() {
        CollationTailoring root = CollationRoot.getRoot();
        return root.data;
    }

    static final CollationSettings getSettings() {
        CollationTailoring root = CollationRoot.getRoot();
        return root.settings.readOnly();
    }

    static {
        CollationTailoring t = null;
        RuntimeException e2 = null;
        try {
            ByteBuffer bytes = ICUBinary.getRequiredData("coll/ucadata.icu");
            CollationTailoring t2 = new CollationTailoring(null);
            CollationDataReader.read(null, bytes, t2);
            t = t2;
        }
        catch (IOException e) {
            e2 = new MissingResourceException("IOException while reading CLDR root data", "CollationRoot", "data/icudt56b/coll/ucadata.icu");
        }
        catch (RuntimeException e) {
            e2 = e;
        }
        rootSingleton = t;
        exception = e2;
    }
}

