/**
 * NetXMS - open source network management system
 * Copyright (C) 2003-2011 Victor Kirhenshtein
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package org.netxms.client.topology;

/**
 * Objects of this class represents physical switch ports
 */
public class Port
{
	private long objectId;
	private long ifIndex;
	private int slot;
	private int port;

	/**
	 *
	 * @param objectId object id
	 * @param ifIndex interface index
	 * @param slot slot
	 * @param port port
	 */
	public Port(long objectId, long ifIndex, int slot, int port)
	{
		this.objectId = objectId;
		this.ifIndex = ifIndex;
		this.slot = slot;
		this.port = port;
	}
	
	/**
	 * @return the slot
	 */
	public int getSlot()
	{
		return slot;
	}
	
	/**
	 * @return the port
	 */
	public int getPort()
	{
		return port;
	}
	
	/**
	 * @return the objectId
	 */
	public long getObjectId()
	{
		return objectId;
	}
	
	/**
	 * @return the ifIndex
	 */
	public long getIfIndex()
	{
		return ifIndex;
	}
}
