/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.io.StringWriter;
import java.util.Set;
import java.util.regex.Pattern;
import org.netxms.base.Glob;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;

@Root(name="objectMenuFilter")
public class ObjectMenuFilter {
    @Element(required=false, name="toolOS")
    public String toolNodeOS = "";
    @Element(required=false)
    public String toolWorkstationOS = "";
    @Element(required=false)
    public String toolTemplate = "";
    @Element(required=false)
    public String toolCustomAttributes = "";
    @Element(required=false)
    public String snmpOid = "";
    @Element(required=false)
    public int flags;
    public static final int REQUIRES_SNMP = 1;
    public static final int REQUIRES_AGENT = 2;
    public static final int REQUIRES_OID_MATCH = 4;
    public static final int REQUIRES_NODE_OS_MATCH = 8;
    public static final int REQUIRES_TEMPLATE_MATCH = 16;
    public static final int REQUIRES_WORKSTATION_OS_MATCH = 32;
    public static final int REQUIRES_CUSTOM_ATTRIBUTE_MATCH = 64;

    public static ObjectMenuFilter createFromXml(String xml) throws Exception {
        Persister serializer = new Persister();
        return (ObjectMenuFilter)((Object)serializer.read(ObjectMenuFilter.class, xml));
    }

    public String createXml() throws Exception {
        Persister serializer = new Persister();
        StringWriter writer = new StringWriter();
        serializer.write((Object)this, writer);
        return ((Object)writer).toString();
    }

    public boolean isApplicableForNode(AbstractNode node) {
        int i;
        String[] substrings;
        boolean match;
        if ((this.flags & 1) != 0 && (node.getFlags() & 1) == 0) {
            return false;
        }
        if ((this.flags & 2) != 0 && (node.getFlags() & 2) == 0) {
            return false;
        }
        if ((this.flags & 4) != 0 && !Glob.matchIgnoreCase(this.snmpOid, node.getSnmpOID())) {
            return false;
        }
        if ((this.flags & 8) != 0) {
            match = false;
            substrings = this.toolNodeOS.split(",");
            for (i = 0; i < substrings.length; ++i) {
                if (!Pattern.matches(substrings[i], node.getPlatformName())) continue;
                match = true;
                break;
            }
            if (!match) {
                return false;
            }
        }
        if ((this.flags & 0x20) != 0) {
            match = false;
            substrings = this.toolWorkstationOS.split(",");
            for (i = 0; i < substrings.length; ++i) {
                if (!Pattern.matches(substrings[i], System.getProperty("os.name"))) continue;
                match = true;
                break;
            }
            if (!match) {
                return false;
            }
        }
        if ((this.flags & 0x10) != 0) {
            match = false;
            substrings = this.toolTemplate.split(",");
            Set<AbstractObject> parents = node.getAllParents(8);
            for (AbstractObject parent : parents) {
                for (int i2 = 0; i2 < substrings.length; ++i2) {
                    if (!Pattern.matches(substrings[i2], parent.getObjectName())) continue;
                    match = true;
                    break;
                }
                if (!match) continue;
                break;
            }
            if (!match) {
                return false;
            }
        }
        if ((this.flags & 0x40) != 0) {
            match = false;
            substrings = this.toolCustomAttributes.split(",");
            for (String attr : node.getCustomAttributes().keySet()) {
                for (int i3 = 0; i3 < substrings.length; ++i3) {
                    if (!Pattern.matches(substrings[i3], attr)) continue;
                    match = true;
                    break;
                }
                if (!match) continue;
                break;
            }
            if (!match) {
                return false;
            }
        }
        return true;
    }

    public void setFilter(String filterText, int filterType) {
        switch (filterType) {
            case 64: {
                this.toolCustomAttributes = filterText;
                break;
            }
            case 8: {
                this.toolNodeOS = filterText;
                break;
            }
            case 4: {
                this.snmpOid = filterText;
                break;
            }
            case 16: {
                this.toolTemplate = filterText;
                break;
            }
            case 32: {
                this.toolWorkstationOS = filterText;
                break;
            }
        }
    }
}

