/*
 * Decompiled with CFR 0.152.
 */
package com.radensolutions.reporting.service.impl;

import com.radensolutions.reporting.ThreadLocalReportInfo;
import com.radensolutions.reporting.model.Notification;
import com.radensolutions.reporting.model.ReportDefinition;
import com.radensolutions.reporting.model.ReportParameter;
import com.radensolutions.reporting.model.ReportResult;
import com.radensolutions.reporting.service.DateParameterParser;
import com.radensolutions.reporting.service.NotificationService;
import com.radensolutions.reporting.service.ReportManager;
import com.radensolutions.reporting.service.ReportResultService;
import com.radensolutions.reporting.service.Session;
import com.radensolutions.reporting.service.SmtpSender;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.sql.DataSource;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.util.JRLoader;
import org.netxms.client.reporting.ReportRenderFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="reportManager")
public class FileSystemReportManager
implements ReportManager {
    private static final String SUBREPORT_DIR_KEY = "SUBREPORT_DIR";
    private static final String DEFINITIONS_DIRECTORY = "definitions";
    private static final String FILE_SUFIX_DEFINITION = ".jrxml";
    private static final String FILE_SUFIX_COMPILED = ".jasper";
    private static final String MAIN_REPORT_COMPILED = "main.jasper";
    private static final String FILE_SUFIX_FILLED = ".jrprint";
    private static final Logger log = LoggerFactory.getLogger(FileSystemReportManager.class);
    @Value(value="#{serverSettings.workspace}")
    private String workspace;
    @Autowired
    private Session session;
    @Autowired
    private ReportResultService reportResultService;
    @Autowired
    private NotificationService notificationService;
    @Autowired
    private SmtpSender smtpSender;
    private Map<UUID, String> reportMap = new HashMap<UUID, String>();
    @Autowired
    private ApplicationContext applicationContext;

    @Override
    public List<UUID> listReports() {
        ArrayList<UUID> li = new ArrayList<UUID>(this.reportMap.keySet());
        System.out.println(li);
        return li;
    }

    @Override
    public ReportDefinition getReportDefinition(UUID reportId, Locale locale) {
        ReportDefinition definition = null;
        JasperReport jasperReport = this.loadReport(reportId);
        if (jasperReport != null) {
            File reportDirectory = this.getReportDirectory(reportId);
            ResourceBundle labels = this.loadReportTranslation(reportDirectory, locale);
            definition = new ReportDefinition();
            definition.setName(jasperReport.getName());
            int numberOfColumns = this.getPropertyFromMap(jasperReport.getPropertiesMap(), "numberOfColumns", 1);
            definition.setNumberOfColumns(numberOfColumns);
            JRParameter[] parameters = jasperReport.getParameters();
            int index = 0;
            for (JRParameter jrParameter : parameters) {
                if (jrParameter.isSystemDefined() || !jrParameter.isForPrompting()) continue;
                JRPropertiesMap propertiesMap = jrParameter.getPropertiesMap();
                String type = jrParameter.getValueClass().getName();
                String logicalType = this.getPropertyFromMap(propertiesMap, "logicalType", type);
                index = this.getPropertyFromMap(propertiesMap, "index", index);
                JRExpression defaultValue = jrParameter.getDefaultValueExpression();
                String dependsOn = this.getPropertyFromMap(propertiesMap, "dependsOn", "");
                int span = this.getPropertyFromMap(propertiesMap, "span", 1);
                if (span < 1) {
                    span = 1;
                }
                ReportParameter parameter = new ReportParameter();
                String name = jrParameter.getName();
                parameter.setName(name);
                parameter.setType(logicalType);
                parameter.setIndex(index);
                parameter.setDescription(this.getTranslation(labels, name));
                parameter.setDefaultValue(defaultValue == null ? null : defaultValue.getText());
                parameter.setDependsOn(dependsOn);
                parameter.setSpan(span);
                definition.putParameter(parameter);
                ++index;
            }
        }
        return definition;
    }

    private JasperReport loadReport(UUID uuid) {
        JasperReport jasperReport = null;
        File reportDirectory = this.getReportDirectory(uuid);
        File reportFile = new File(reportDirectory, MAIN_REPORT_COMPILED);
        try {
            jasperReport = (JasperReport)JRLoader.loadObject((File)reportFile);
        }
        catch (JRException e) {
            log.error("Can't load compiled report", (Throwable)e);
        }
        return jasperReport;
    }

    @Override
    public void deploy() {
        File definitionsDirectory = this.getDefinitionsDirectory();
        log.info("Deploying *.jar/*.zip in " + definitionsDirectory.getAbsolutePath());
        String[] files = definitionsDirectory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String normalizedName = name.toLowerCase();
                return normalizedName.endsWith(".jar") || normalizedName.endsWith(".zip");
            }
        });
        if (files != null) {
            for (String archiveName : files) {
                log.debug("Deploying " + archiveName);
                try {
                    String deployedName = archiveName.split("\\.(?=[^\\.]+$)")[0];
                    File destination = new File(definitionsDirectory, deployedName);
                    this.deleteFolder(destination);
                    UUID bundleId = this.unpackJar(destination, new File(definitionsDirectory, archiveName));
                    this.reportMap.put(bundleId, deployedName);
                    this.compileReport(destination);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            log.info("No files found");
        }
    }

    private void deleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    this.deleteFolder(f);
                    continue;
                }
                f.delete();
            }
        }
        folder.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UUID unpackJar(File destination, File archive) throws IOException {
        JarFile jarFile = new JarFile(archive);
        try {
            JarEntry jarEntry;
            Manifest manifest = jarFile.getManifest();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                File destDir;
                jarEntry = entries.nextElement();
                if (!jarEntry.isDirectory() || (destDir = new File(destination, jarEntry.getName())).mkdirs()) continue;
                log.error("Can't create directory " + destDir.getAbsolutePath());
            }
            entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                jarEntry = entries.nextElement();
                File destinationFile = new File(destination, jarEntry.getName());
                InputStream inputStream = null;
                FileOutputStream outputStream = null;
                if (jarEntry.isDirectory()) continue;
                try {
                    int len;
                    inputStream = jarFile.getInputStream(jarEntry);
                    outputStream = new FileOutputStream(destinationFile);
                    byte[] buffer = new byte[1024];
                    assert (inputStream != null);
                    while ((len = inputStream.read(buffer)) > 0) {
                        outputStream.write(buffer, 0, len);
                    }
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (outputStream == null) continue;
                    outputStream.close();
                }
            }
            UUID uUID = UUID.fromString(manifest.getMainAttributes().getValue("Build-Id"));
            return uUID;
        }
        finally {
            jarFile.close();
        }
    }

    private void compileReport(File reportDirectory) {
        String[] list;
        for (String fileName : list = reportDirectory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(FileSystemReportManager.FILE_SUFIX_DEFINITION);
            }
        })) {
            File file = new File(reportDirectory, fileName);
            try {
                String sourceFileName = file.getAbsolutePath();
                String destinationFileName = sourceFileName.substring(0, sourceFileName.length() - FILE_SUFIX_DEFINITION.length()) + FILE_SUFIX_COMPILED;
                JasperCompileManager.compileReportToFile((String)sourceFileName, (String)destinationFileName);
            }
            catch (JRException e) {
                log.error("Can't compile report " + file.getAbsoluteFile(), (Throwable)e);
            }
        }
    }

    private File getDefinitionsDirectory() {
        return new File(this.workspace, DEFINITIONS_DIRECTORY);
    }

    private File getReportDirectory(UUID reportId) {
        String path = this.reportMap.get(reportId);
        File file = null;
        if (path != null) {
            file = new File(this.getDefinitionsDirectory(), path);
        }
        return file;
    }

    private File getOutputDirectory(UUID reportId) {
        File file;
        File output = new File(this.workspace, "output");
        if (!output.exists()) {
            output.mkdirs();
        }
        if (!(file = new File(output, reportId.toString())).exists()) {
            file.mkdirs();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(int userId, UUID reportId, UUID jobId, Map<String, String> parameters, Locale locale) {
        String name;
        boolean ret = false;
        DataSource dataSource = null;
        JasperReport report = this.loadReport(reportId);
        if (report != null && (name = report.getPropertiesMap().getProperty("datasource")) != null) {
            dataSource = (DataSource)this.applicationContext.getBean(name);
        }
        if (dataSource == null) {
            dataSource = (DataSource)this.applicationContext.getBean("report");
        }
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            ret = this.realExecute(report, userId, reportId, jobId, parameters, locale, connection);
        }
        catch (SQLException e) {
            log.error("Can't get report connection", (Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return ret;
    }

    private boolean realExecute(JasperReport report, int userId, UUID reportId, UUID jobId, Map<String, String> parameters, Locale locale, Connection connection) {
        boolean ret = false;
        if (connection != null && report != null) {
            File reportDirectory = this.getReportDirectory(reportId);
            ResourceBundle translations = this.loadReportTranslation(reportDirectory, locale);
            HashMap<String, Object> localParameters = new HashMap<String, Object>(parameters);
            localParameters.put("REPORT_LOCALE", (String)((Object)locale));
            localParameters.put("REPORT_RESOURCE_BUNDLE", (String)((Object)translations));
            String subrepoDirectory = reportDirectory.getPath() + File.separatorChar;
            localParameters.put(SUBREPORT_DIR_KEY, subrepoDirectory);
            localParameters.put("REPORT_CLASS_LOADER", (String)((Object)new URLClassLoader(new URL[0], this.getClass().getClassLoader())));
            this.prepareParameters(parameters, report, localParameters);
            ThreadLocalReportInfo.setReportLocation(subrepoDirectory);
            File outputDirectory = this.getOutputDirectory(reportId);
            String outputFile = new File(outputDirectory, jobId.toString() + FILE_SUFIX_FILLED).getPath();
            try {
                DefaultJasperReportsContext reportsContext = DefaultJasperReportsContext.getInstance();
                reportsContext.setProperty("net.sf.jasperreports.query.executer.factory.nxcl", "com.radensolutions.reporting.custom.NXCLQueryExecutorFactory");
                JasperFillManager manager = JasperFillManager.getInstance((JasperReportsContext)reportsContext);
                manager.fillToFile(report, outputFile, localParameters, connection);
                this.reportResultService.save(new ReportResult(new Date(), reportId, jobId, userId));
                ret = true;
                this.session.sendNotify(3001, 0);
                List<Notification> notify = this.notificationService.load(jobId);
                this.sendMailNotification(notify);
            }
            catch (JRException e) {
                log.error("Can't execute report", (Throwable)e);
            }
        }
        return ret;
    }

    private void prepareParameters(Map<String, String> parameters, JasperReport report, HashMap<String, Object> localParameters) {
        JRParameter[] jrParameters;
        for (JRParameter jrParameter : jrParameters = report.getParameters()) {
            if (!jrParameter.isForPrompting() || jrParameter.isSystemDefined()) continue;
            String jrName = jrParameter.getName();
            String input = parameters.get(jrName);
            Class valueClass = jrParameter.getValueClass();
            String logicalType = jrParameter.getPropertiesMap().getProperty("logicalType");
            if ("START_DATE".equalsIgnoreCase(logicalType)) {
                Date date = DateParameterParser.getDateTime(input, false);
                localParameters.put(jrName, date.getTime() / 1000L);
                continue;
            }
            if ("END_DATE".equalsIgnoreCase(logicalType)) {
                Date date = DateParameterParser.getDateTime(input, true);
                localParameters.put(jrName, date.getTime() / 1000L);
                continue;
            }
            if ("SEVERITY_LIST".equalsIgnoreCase(logicalType)) {
                localParameters.put(jrName, this.convertCommaSeparatedToIntList(input));
                continue;
            }
            if ("OBJECT_ID_LIST".equalsIgnoreCase(logicalType)) {
                localParameters.put(jrName, this.convertCommaSeparatedToIntList(input));
                continue;
            }
            if ("EVENT_CODE".equalsIgnoreCase(logicalType)) {
                if ("0".equals(input)) {
                    localParameters.put(jrName, new ArrayList(0));
                    continue;
                }
                localParameters.put(jrName, this.convertCommaSeparatedToIntList(input));
                continue;
            }
            if (Boolean.class.equals((Object)valueClass)) {
                localParameters.put(jrName, Boolean.parseBoolean(input));
                continue;
            }
            if (Date.class.equals((Object)valueClass)) {
                long timestamp = 0L;
                try {
                    timestamp = Long.parseLong(input);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                localParameters.put(jrName, new Date(timestamp));
                continue;
            }
            if (Double.class.equals((Object)valueClass)) {
                double value = 0.0;
                try {
                    value = Double.parseDouble(input);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                localParameters.put(jrName, value);
                continue;
            }
            if (Float.class.equals((Object)valueClass)) {
                float value = 0.0f;
                try {
                    value = Float.parseFloat(input);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                localParameters.put(jrName, Float.valueOf(value));
                continue;
            }
            if (Integer.class.equals((Object)valueClass)) {
                int value = 0;
                try {
                    value = Integer.parseInt(input);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                localParameters.put(jrName, value);
                continue;
            }
            if (Long.class.equals((Object)valueClass)) {
                long value = 0L;
                try {
                    value = Long.parseLong(input);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                localParameters.put(jrName, value);
                continue;
            }
            if (Short.class.equals((Object)valueClass)) {
                short value = 0;
                try {
                    value = Short.parseShort(input);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                localParameters.put(jrName, value);
                continue;
            }
            if (BigDecimal.class.equals((Object)valueClass)) {
                BigDecimal value = BigDecimal.valueOf(0L);
                try {
                    value = new BigDecimal(input);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                localParameters.put(jrName, value);
                continue;
            }
            if (!Collection.class.equals((Object)valueClass) && !List.class.equals((Object)valueClass)) continue;
            List<String> list = Arrays.asList(input.trim().split("\\t"));
            localParameters.put(jrName, list);
        }
    }

    private List<Integer> convertCommaSeparatedToIntList(String input) {
        if (input == null) {
            return null;
        }
        String[] strings = input.split(",");
        ArrayList<Integer> ret = new ArrayList<Integer>(strings.length);
        for (String s : strings) {
            try {
                ret.add(Integer.parseInt(s));
            }
            catch (NumberFormatException e) {
                log.error("Invalid ID in comma separated list: " + input);
            }
        }
        return ret;
    }

    @Override
    public List<ReportResult> listResults(UUID reportId, int userId) {
        return this.reportResultService.list(reportId, userId);
    }

    @Override
    public boolean deleteResult(UUID reportId, UUID jobId) {
        this.reportResultService.delete(jobId);
        File reportDirectory = this.getOutputDirectory(reportId);
        File file = new File(reportDirectory, jobId.toString() + FILE_SUFIX_FILLED);
        return file.delete();
    }

    @Override
    public File renderResult(UUID reportId, UUID jobId, ReportRenderFormat format) {
        File outputDirectory = this.getOutputDirectory(reportId);
        File dataFile = new File(outputDirectory, jobId.toString() + FILE_SUFIX_FILLED);
        File outputFile = new File(outputDirectory, jobId.toString() + "." + System.currentTimeMillis() + ".render");
        JRPdfExporter exporter = null;
        switch (format) {
            case PDF: {
                exporter = new JRPdfExporter();
                break;
            }
            case XLS: {
                exporter = new JRXlsExporter();
                JasperReport jasperReport = this.loadReport(reportId);
                if (jasperReport != null) {
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.SHEET_NAMES, (Object)new String[]{this.prepareXlsSheetName(jasperReport.getName())});
                }
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_IGNORE_CELL_BORDER, (Object)false);
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)false);
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)true);
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_COLLAPSE_ROW_SPAN, (Object)true);
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS, (Object)true);
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)false);
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)true);
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_IMAGE_BORDER_FIX_ENABLED, (Object)true);
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_FONT_SIZE_FIX_ENABLED, (Object)true);
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_IGNORE_GRAPHICS, (Object)false);
                break;
            }
        }
        exporter.setParameter(JRExporterParameter.INPUT_FILE, (Object)dataFile);
        try {
            exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)new FileOutputStream(outputFile));
            exporter.exportReport();
        }
        catch (Exception e) {
            log.error("Failed to render report", (Throwable)e);
            outputFile.delete();
            outputFile = null;
        }
        return outputFile;
    }

    private String prepareXlsSheetName(String sheetName) {
        int length = Math.min(31, sheetName.length());
        StringBuilder stringBuilder = new StringBuilder(sheetName.substring(0, length));
        block4: for (int i = 0; i < length; ++i) {
            char ch = stringBuilder.charAt(i);
            switch (ch) {
                case '*': 
                case '/': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': {
                    stringBuilder.setCharAt(i, ' ');
                    continue block4;
                }
                case '\'': {
                    if (i != 0 && i != length - 1) continue block4;
                    stringBuilder.setCharAt(i, ' ');
                    continue block4;
                }
            }
        }
        return stringBuilder.toString();
    }

    private String getTranslation(ResourceBundle bundle, String name) {
        if (bundle.containsKey(name)) {
            return bundle.getString(name);
        }
        return name;
    }

    private int getPropertyFromMap(JRPropertiesMap map, String key, int defaultValue) {
        if (map.containsProperty(key)) {
            try {
                return Integer.parseInt(map.getProperty(key));
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private String getPropertyFromMap(JRPropertiesMap map, String key, String defaultValue) {
        if (map.containsProperty(key)) {
            return map.getProperty(key);
        }
        return defaultValue;
    }

    private ResourceBundle loadReportTranslation(File directory, Locale locale) {
        ResourceBundle labels = null;
        try {
            URLClassLoader classLoader = URLClassLoader.newInstance(new URL[]{directory.toURI().toURL()});
            labels = ResourceBundle.getBundle("i18n", locale, classLoader);
        }
        catch (Exception e) {
            log.error("Can't load language bundle for report", (Throwable)e);
            labels = new ListResourceBundle(){

                @Override
                protected Object[][] getContents() {
                    return new Object[0][];
                }
            };
        }
        return labels;
    }

    private void sendMailNotification(List<Notification> notify) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        Date today = Calendar.getInstance().getTime();
        String reportDate = df.format(today);
        for (Notification notification : notify) {
            String text = String.format("Report \"%s\" successfully generated on %s and can be accessed using management console.", notification.getReportName(), reportDate);
            String fileName = null;
            File renderResult = null;
            if (notification.getAttachFormatCode() != 0) {
                ReportRenderFormat formatCode = ReportRenderFormat.valueOf((Integer)notification.getAttachFormatCode());
                UUID jobId = notification.getJobId();
                UUID reportId = this.reportResultService.findReportId(jobId);
                if (reportId != null) {
                    renderResult = this.renderResult(reportId, jobId, formatCode);
                    String time = new SimpleDateFormat("dd-MM-yyyy").format(new Date());
                    fileName = String.format("%s %s.%s", notification.getReportName(), time, formatCode == ReportRenderFormat.PDF ? "pdf" : "xls");
                    text = text + "\n\nPlease find attached copy of the report.";
                } else {
                    log.error("Cannot find report by guid");
                }
            }
            text = text + "\n\nThis message is generated automatically by NetXMS.";
            if (renderResult == null) continue;
            this.smtpSender.mail(notification.getMail(), "New report is available", text, fileName, renderResult);
            renderResult.delete();
        }
    }
}

