/*
 * Decompiled with CFR 0.152.
 */
package com.radensolutions.reporting.service.impl;

import com.radensolutions.reporting.job.GeneratorJob;
import com.radensolutions.reporting.service.NotificationService;
import com.radensolutions.reporting.service.ReportScheduler;
import com.radensolutions.reporting.service.Session;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.Matcher;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.matchers.KeyMatcher;
import org.quartz.utils.Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;
import org.springframework.scheduling.quartz.SimpleTriggerFactoryBean;
import org.springframework.stereotype.Service;

@Service(value="reportScheduler")
public class QuartzReportScheduler
implements ReportScheduler {
    public static final String SYSTEM_USER_NAME = "SYSTEM";
    public static final int TYPE_ONCE = 0;
    public static final int TYPE_DAILY = 1;
    public static final int TYPE_WEEKLY = 2;
    public static final int TYPE_MONTHLY = 3;
    private static final Logger log = LoggerFactory.getLogger(QuartzReportScheduler.class);
    public static String[] dayOfWeekNames = new String[]{"MON", "TUE", "WED", "THU", "FRI", "SAT", "SUN"};
    @Autowired
    private NotificationService notificationService;
    @Autowired
    private Session session;
    @Autowired
    private Scheduler scheduler;

    @Override
    public UUID execute(UUID jobId, int userId, UUID reportUuid, Map<String, Object> parameters) {
        if (jobId == null) {
            jobId = UUID.randomUUID();
        }
        log.debug("New job " + jobId + " for report " + reportUuid);
        String groupName = reportUuid.toString();
        JobDetailFactoryBean jobDetailFactory = new JobDetailFactoryBean();
        jobDetailFactory.setName(jobId.toString());
        jobDetailFactory.setGroup(groupName);
        jobDetailFactory.setJobClass(GeneratorJob.class);
        jobDetailFactory.afterPropertiesSet();
        JobDetail jobDetail = jobDetailFactory.getObject();
        JobDataMap dataMap = jobDetail.getJobDataMap();
        dataMap.put("jobId", (Object)jobId);
        dataMap.put("reportId", (Object)reportUuid);
        dataMap.put("parameters", parameters);
        dataMap.put("userId", userId);
        SimpleTriggerFactoryBean triggerFactoryBean = new SimpleTriggerFactoryBean();
        triggerFactoryBean.setName(jobId.toString() + "_trigger");
        triggerFactoryBean.setGroup(groupName);
        triggerFactoryBean.setJobDetail(jobDetail);
        triggerFactoryBean.setRepeatCount(0);
        triggerFactoryBean.afterPropertiesSet();
        SimpleTrigger trigger = triggerFactoryBean.getObject();
        try {
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (SchedulerException e) {
            log.error("Can't schedule job", (Throwable)e);
            jobId = null;
        }
        return jobId;
    }

    @Override
    public UUID addRecurrent(UUID jobId, UUID reportUuid, int jobType, int daysOfWeek, int daysOfMonth, Date startTime, Map<String, Object> parameters, int userId) {
        SimpleTrigger trigger;
        Calendar dateTime = Calendar.getInstance();
        dateTime.setTime(startTime);
        int hours = dateTime.get(11);
        int minutes = dateTime.get(12);
        log.debug(String.format("reportId=%1$s, hours=%2$d, minutes=%3$d, dow=%4$d, dom=%5$d", reportUuid, hours, minutes, daysOfWeek, daysOfMonth));
        if (jobId == null) {
            jobId = UUID.randomUUID();
        }
        String reportKey = reportUuid.toString();
        JobDetailFactoryBean jobDetailFactory = new JobDetailFactoryBean();
        jobDetailFactory.setJobClass(GeneratorJob.class);
        jobDetailFactory.setName(jobId.toString());
        jobDetailFactory.setGroup(reportKey);
        jobDetailFactory.afterPropertiesSet();
        JobDetail job = jobDetailFactory.getObject();
        JobDataMap dataMap = job.getJobDataMap();
        dataMap.put("jobId", (Object)jobId);
        dataMap.put("jobType", jobType);
        dataMap.put("reportId", (Object)reportUuid);
        dataMap.put("userId", userId);
        dataMap.put("parameters", parameters);
        dataMap.put("startDate", (Object)startTime);
        dataMap.put("daysOfWeek", daysOfWeek);
        dataMap.put("daysOfMonth", daysOfMonth);
        if (jobType == 0) {
            SimpleTriggerFactoryBean triggerFactoryBean = new SimpleTriggerFactoryBean();
            triggerFactoryBean.setName(jobId.toString() + "_trigger");
            triggerFactoryBean.setGroup(reportKey);
            triggerFactoryBean.setJobDetail(job);
            triggerFactoryBean.setRepeatCount(0);
            triggerFactoryBean.setStartTime(startTime);
            triggerFactoryBean.afterPropertiesSet();
            trigger = triggerFactoryBean.getObject();
        } else {
            String cronExpression = null;
            switch (jobType) {
                case 1: {
                    cronExpression = "0 " + minutes + " " + hours + " * * ?";
                    break;
                }
                case 2: {
                    String sDays = "";
                    for (int i = 0; i < 7; ++i) {
                        if ((daysOfWeek >> i & 1) == 0) continue;
                        sDays = sDays + (sDays.length() > 0 ? "," : "") + dayOfWeekNames[7 - i - 1];
                    }
                    if (sDays.length() <= 0) break;
                    cronExpression = "0 " + minutes + " " + hours + " ? * " + sDays;
                    break;
                }
                case 3: {
                    String sDayOfM = "";
                    for (int i = 0; i < 31; ++i) {
                        if ((daysOfMonth >> i & 1) == 0) continue;
                        sDayOfM = sDayOfM + (sDayOfM.length() > 0 ? "," : "") + String.valueOf(31 - i);
                    }
                    if (sDayOfM.length() <= 0) break;
                    cronExpression = "0 " + minutes + " " + hours + " " + sDayOfM + " * ?";
                }
            }
            CronTriggerFactoryBean cronTriggerFactoryBean = new CronTriggerFactoryBean();
            cronTriggerFactoryBean.setJobDetail(job);
            cronTriggerFactoryBean.setName(jobId.toString() + "_trigger");
            cronTriggerFactoryBean.setGroup(reportKey);
            cronTriggerFactoryBean.setCronExpression(cronExpression);
            try {
                cronTriggerFactoryBean.afterPropertiesSet();
            }
            catch (ParseException e) {
                log.error("Can't parse cron expression " + cronExpression, (Throwable)e);
            }
            trigger = cronTriggerFactoryBean.getObject();
        }
        try {
            this.scheduler.getListenerManager().addJobListener((JobListener)new ReportingJobListener(jobId, jobType), (Matcher)KeyMatcher.keyEquals((Key)job.getKey()));
            this.scheduler.scheduleJob(job, (Trigger)trigger);
        }
        catch (SchedulerException e) {
            log.error("Can't schedule job", (Throwable)e);
            jobId = null;
        }
        return jobId;
    }

    @Override
    public List<JobDetail> getSchedules(UUID reportUuid) {
        ArrayList<JobDetail> jobDetailsList = new ArrayList<JobDetail>(0);
        try {
            for (String groupName : this.scheduler.getJobGroupNames()) {
                for (JobKey jobKey : this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)groupName))) {
                    jobDetailsList.add(this.scheduler.getJobDetail(jobKey));
                }
            }
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
        return jobDetailsList;
    }

    @Override
    public boolean deleteScheduleJob(UUID reportId, UUID jobId) {
        try {
            Set jobKeys = this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)reportId.toString()));
            for (JobKey key : jobKeys) {
                if (!key.getName().equalsIgnoreCase(jobId.toString())) continue;
                this.scheduler.deleteJob(key);
            }
        }
        catch (SchedulerException e) {
            this.session.sendNotify(3000, 0);
            this.notificationService.delete(jobId);
            log.error("Can't find or remove old triggers", (Throwable)e);
            return false;
        }
        return true;
    }

    public class ReportingJobListener
    implements JobListener {
        UUID jobId;
        int jobType;

        public ReportingJobListener(UUID jobId, int jobType) {
            this.jobId = jobId;
            this.jobType = jobType;
        }

        public String getName() {
            return "reportingJobListener";
        }

        public void jobToBeExecuted(JobExecutionContext context) {
        }

        public void jobExecutionVetoed(JobExecutionContext context) {
        }

        public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
            if (this.jobType == 0) {
                QuartzReportScheduler.this.notificationService.delete(this.jobId);
            }
        }
    }
}

