/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.format;

import org.apache.poi.ss.format.CellDateFormatter;
import org.apache.poi.ss.format.CellElapsedFormatter;
import org.apache.poi.ss.format.CellFormatter;
import org.apache.poi.ss.format.CellGeneralFormatter;
import org.apache.poi.ss.format.CellNumberFormatter;
import org.apache.poi.ss.format.CellTextFormatter;

public enum CellFormatType {
    GENERAL{

        @Override
        CellFormatter formatter(String pattern) {
            return new CellGeneralFormatter();
        }

        @Override
        boolean isSpecial(char ch) {
            return false;
        }
    }
    ,
    NUMBER{

        @Override
        boolean isSpecial(char ch) {
            return false;
        }

        @Override
        CellFormatter formatter(String pattern) {
            return new CellNumberFormatter(pattern);
        }
    }
    ,
    DATE{

        @Override
        boolean isSpecial(char ch) {
            return ch == '\'' || ch <= '\u007f' && Character.isLetter(ch);
        }

        @Override
        CellFormatter formatter(String pattern) {
            return new CellDateFormatter(pattern);
        }
    }
    ,
    ELAPSED{

        @Override
        boolean isSpecial(char ch) {
            return false;
        }

        @Override
        CellFormatter formatter(String pattern) {
            return new CellElapsedFormatter(pattern);
        }
    }
    ,
    TEXT{

        @Override
        boolean isSpecial(char ch) {
            return false;
        }

        @Override
        CellFormatter formatter(String pattern) {
            return new CellTextFormatter(pattern);
        }
    };


    abstract boolean isSpecial(char var1);

    abstract CellFormatter formatter(String var1);
}

