/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.items;

import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.items.Item;
import net.sf.jasperreports.components.items.ItemData;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.design.JRVerifier;

public class ItemCompiler {
    public static void collectExpressions(ItemData data, JRExpressionCollector collector) {
        if (data != null) {
            List<Item> items;
            JRDatasetRun datasetRun;
            JRExpressionCollector datasetCollector = collector;
            JRElementDataset dataset = data.getDataset();
            JRDatasetRun jRDatasetRun = datasetRun = dataset == null ? null : dataset.getDatasetRun();
            if (datasetRun != null) {
                collector.collect(datasetRun);
                datasetCollector = collector.getDatasetCollector(datasetRun.getDatasetName());
            }
            if ((items = data.getItems()) != null && !items.isEmpty()) {
                for (Item item : items) {
                    List<ItemProperty> itemProperties = item.getProperties();
                    if (itemProperties == null) continue;
                    for (ItemProperty property : itemProperties) {
                        datasetCollector.addExpression(property.getValueExpression());
                    }
                }
            }
        }
    }

    public static void verifyItemData(JRVerifier verifier, ItemData itemData, String itemName, String[] requiredNames, Map<String, String> alternativeNamesMap) {
        List<Item> items;
        if (itemData.getDataset() != null) {
            verifier.verifyElementDataset(itemData.getDataset());
        }
        if ((items = itemData.getItems()) != null) {
            for (Item item : items) {
                ItemCompiler.verifyItem(verifier, item, itemName, requiredNames, alternativeNamesMap);
            }
        }
    }

    public static void verifyItem(JRVerifier verifier, Item item, String itemName, String[] requiredNames, Map<String, String> alternativeNamesMap) {
        List<ItemProperty> itemProperties;
        if (requiredNames != null && requiredNames.length > 0 && (itemProperties = item.getProperties()) != null && !itemProperties.isEmpty()) {
            for (String reqName : requiredNames) {
                boolean hasProperty = false;
                for (ItemProperty itemProperty : itemProperties) {
                    if (!itemProperty.getName().equals(reqName) && (alternativeNamesMap == null || !itemProperty.getName().equals(alternativeNamesMap.get(reqName)))) continue;
                    hasProperty = true;
                    break;
                }
                if (hasProperty) continue;
                verifier.addBrokenRule("No '" + reqName + "' property set for the " + itemName + " item.", itemProperties);
            }
        }
    }
}

