/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRAbstractTextDataSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractXmlDataSource<T extends AbstractXmlDataSource<?>>
extends JRAbstractTextDataSource
implements JRRewindableDataSource {
    public static final String PROPERTY_FIELD_EXPRESSION = "net.sf.jasperreports.xpath.field.expression";
    private Map<String, String> fieldExpressions = new HashMap<String, String>();

    public abstract Node getCurrentNode();

    public abstract Object getSelectObject(Node var1, String var2) throws JRException;

    @Override
    public Object getFieldValue(JRField jrField) throws JRException {
        if (this.getCurrentNode() == null) {
            return null;
        }
        String expression = null;
        if (this.fieldExpressions.containsKey(jrField.getName())) {
            expression = this.fieldExpressions.get(jrField.getName());
        } else {
            expression = this.getFieldExpression(jrField);
            this.fieldExpressions.put(jrField.getName(), expression);
        }
        if (expression == null || expression.length() == 0) {
            return null;
        }
        Object value = null;
        Class<?> valueClass = jrField.getValueClass();
        Object selectedObject = this.getSelectObject(this.getCurrentNode(), expression);
        if (Object.class != valueClass) {
            if (selectedObject != null) {
                if (selectedObject instanceof Node) {
                    String text = this.getText((Node)selectedObject);
                    if (text != null) {
                        value = this.convertStringValue(text, valueClass);
                    }
                } else if (selectedObject instanceof Boolean && valueClass.equals(Boolean.class)) {
                    value = selectedObject;
                } else if (selectedObject instanceof Number && Number.class.isAssignableFrom(valueClass)) {
                    value = this.convertNumber((Number)selectedObject, valueClass);
                } else {
                    String text = selectedObject.toString();
                    value = this.convertStringValue(text, valueClass);
                }
            }
        } else {
            value = selectedObject;
        }
        return value;
    }

    public abstract T subDataSource(String var1) throws JRException;

    public T subDataSource() throws JRException {
        return this.subDataSource(".");
    }

    public abstract Document subDocument() throws JRException;

    public abstract T dataSource(String var1) throws JRException;

    public T dataSource() throws JRException {
        return this.dataSource(".");
    }

    public String getText(Node node) {
        if (!node.hasChildNodes()) {
            return node.getNodeValue();
        }
        StringBuilder result = new StringBuilder();
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            String value;
            Node subnode = list.item(i);
            if (subnode.getNodeType() == 3) {
                value = subnode.getNodeValue();
                if (value == null) continue;
                result.append(value);
                continue;
            }
            if (subnode.getNodeType() == 4) {
                value = subnode.getNodeValue();
                if (value == null) continue;
                result.append(value);
                continue;
            }
            if (subnode.getNodeType() != 5 || (value = this.getText(subnode)) == null) continue;
            result.append(value);
        }
        return result.toString();
    }

    protected String getFieldExpression(JRField field) {
        String fieldExpression = null;
        if (field.hasProperties()) {
            fieldExpression = field.getPropertiesMap().getProperty(PROPERTY_FIELD_EXPRESSION);
        }
        if (!(fieldExpression != null && fieldExpression.length() != 0 || (fieldExpression = field.getDescription()) != null && fieldExpression.length() != 0)) {
            fieldExpression = field.getName();
        }
        return fieldExpression;
    }
}

