/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBoxPen;
import net.sf.jasperreports.engine.export.Cut;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.ElementGridCell;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.HyperlinkUtil;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.OccupiedGridCell;
import net.sf.jasperreports.engine.export.XlsRowLevelInfo;
import net.sf.jasperreports.engine.export.oasis.ContentBuilder;
import net.sf.jasperreports.engine.export.oasis.DocumentBuilder;
import net.sf.jasperreports.engine.export.oasis.FileBufferedOasisZip;
import net.sf.jasperreports.engine.export.oasis.GenericElementOdsHandler;
import net.sf.jasperreports.engine.export.oasis.InternalImageProcessor;
import net.sf.jasperreports.engine.export.oasis.InternalImageProcessorResult;
import net.sf.jasperreports.engine.export.oasis.JROdsExporterContext;
import net.sf.jasperreports.engine.export.oasis.JROdsExporterNature;
import net.sf.jasperreports.engine.export.oasis.OasisZip;
import net.sf.jasperreports.engine.export.oasis.StyleBuilder;
import net.sf.jasperreports.engine.export.oasis.StyleCache;
import net.sf.jasperreports.engine.export.oasis.TableBuilder;
import net.sf.jasperreports.engine.export.oasis.WriterHelper;
import net.sf.jasperreports.engine.export.zip.ExportZipEntry;
import net.sf.jasperreports.engine.export.zip.FileBufferedZipEntry;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.export.OdsExporterConfiguration;
import net.sf.jasperreports.export.OdsReportConfiguration;
import net.sf.jasperreports.export.XlsReportConfiguration;
import net.sf.jasperreports.renderers.Renderable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JROdsExporter
extends JRXlsAbstractExporter<OdsReportConfiguration, OdsExporterConfiguration, JROdsExporterContext> {
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    protected static final String DEFAULT_COLUMN = "A";
    protected static final String DEFAULT_ADDRESS = "$A$1";
    protected OasisZip oasisZip;
    protected ExportZipEntry tempBodyEntry;
    protected ExportZipEntry tempStyleEntry;
    protected WriterHelper tempBodyWriter;
    protected WriterHelper tempStyleWriter;
    protected WriterHelper stylesWriter;
    protected StyleCache styleCache;
    protected DocumentBuilder documentBuilder;
    protected TableBuilder tableBuilder;
    protected StyleBuilder styleBuilder;
    protected boolean startPage;
    protected PrintPageFormat oldPageFormat;
    protected int pageFormatIndex;
    protected StringBuilder namedExpressions;
    protected Map<Integer, String> rowStyles = new HashMap<Integer, String>();
    protected Map<Integer, String> columnStyles = new HashMap<Integer, String>();
    private static final Log log = LogFactory.getLog(JROdsExporter.class);
    protected static final String ODS_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.ods.";
    public static final String ODS_EXPORTER_KEY = "net.sf.jasperreports.ods";

    @Override
    protected void openWorkbook(OutputStream os) throws JRException, IOException {
        this.oasisZip = new FileBufferedOasisZip("spreadsheet");
        this.tempBodyEntry = new FileBufferedZipEntry(null);
        this.tempStyleEntry = new FileBufferedZipEntry(null);
        this.tempBodyWriter = new WriterHelper(this.jasperReportsContext, this.tempBodyEntry.getWriter());
        this.tempStyleWriter = new WriterHelper(this.jasperReportsContext, this.tempStyleEntry.getWriter());
        this.rowStyles.clear();
        this.columnStyles.clear();
        this.documentBuilder = new OdsDocumentBuilder(this.oasisZip);
        this.styleCache = new StyleCache(this.jasperReportsContext, this.tempStyleWriter, this.getExporterKey());
        this.stylesWriter = new WriterHelper(this.jasperReportsContext, this.oasisZip.getStylesEntry().getWriter());
        this.styleBuilder = new StyleBuilder(this.stylesWriter);
        this.styleBuilder.buildBeforeAutomaticStyles(this.jasperPrint);
        this.namedExpressions = new StringBuilder("<table:named-expressions>\n");
        this.pageFormatIndex = -1;
        this.maxColumnIndex = 1023;
    }

    @Override
    protected int exportPage(JRPrintPage page, CutsInfo xCuts, int startRow, String defaultSheetName) throws JRException {
        if (this.oldPageFormat != this.pageFormat) {
            this.styleBuilder.buildPageLayout(++this.pageFormatIndex, this.pageFormat);
            this.oldPageFormat = this.pageFormat;
        }
        return super.exportPage(page, xCuts, startRow, defaultSheetName);
    }

    @Override
    protected void createSheet(CutsInfo xCuts, JRXlsAbstractExporter.SheetInfo sheetInfo) {
        this.startPage = true;
        this.tableBuilder = new OdsTableBuilder(this.documentBuilder, this.jasperPrint, this.pageFormatIndex, this.pageIndex, this.tempBodyWriter, this.tempStyleWriter, this.styleCache, this.rowStyles, this.columnStyles, sheetInfo.sheetName, sheetInfo.tabColor);
        this.tableBuilder.buildTableStyle(xCuts.getLastCutOffset());
        this.tableBuilder.buildTableHeader();
    }

    @Override
    protected void closeSheet() {
        if (this.tableBuilder != null) {
            this.tableBuilder.buildRowFooter();
            this.tableBuilder.buildTableFooter();
        }
    }

    @Override
    protected void closeWorkbook(OutputStream os) throws JRException, IOException {
        this.styleBuilder.buildMasterPages(this.pageFormatIndex);
        this.stylesWriter.flush();
        this.tempBodyWriter.flush();
        this.tempStyleWriter.flush();
        this.stylesWriter.close();
        this.tempBodyWriter.close();
        this.tempStyleWriter.close();
        this.namedExpressions.append("</table:named-expressions>\n");
        ContentBuilder contentBuilder = new ContentBuilder(this.oasisZip.getContentEntry(), this.tempStyleEntry, this.tempBodyEntry, this.styleCache.getFontFaces(), "spreadsheet", this.namedExpressions);
        contentBuilder.build();
        this.tempStyleEntry.dispose();
        this.tempBodyEntry.dispose();
        this.oasisZip.zipEntries(os);
        this.oasisZip.dispose();
    }

    @Override
    protected void setColumnWidth(int col, int width, boolean autoFit) {
        this.tableBuilder.buildColumnStyle(col - 1, width);
        this.tableBuilder.buildColumnHeader(width);
        this.tableBuilder.buildColumnFooter();
    }

    @Override
    protected void setRowHeight(int rowIndex, int lastRowHeight, Cut yCut, XlsRowLevelInfo levelInfo) throws JRException {
        boolean isFlexibleRowHeight = ((OdsReportConfiguration)this.getCurrentItemConfiguration()).isFlexibleRowHeight();
        this.tableBuilder.buildRowStyle(rowIndex, isFlexibleRowHeight ? -1 : lastRowHeight);
        this.tableBuilder.buildRow(rowIndex, isFlexibleRowHeight ? -1 : lastRowHeight);
    }

    @Override
    protected void addRowBreak(int rowIndex) {
    }

    @Override
    protected void addBlankCell(JRExporterGridCell gridCell, int colIndex, int rowIndex) {
        this.tempBodyWriter.write("<table:table-cell");
        if (gridCell == null) {
            this.tempBodyWriter.write(" table:style-name=\"empty-cell\"");
        } else {
            this.tempBodyWriter.write(" table:style-name=\"" + this.styleCache.getCellStyle(gridCell) + "\"");
        }
        this.tempBodyWriter.write("/>\n");
    }

    @Override
    protected void addOccupiedCell(OccupiedGridCell occupiedGridCell, int colIndex, int rowIndex) throws JRException {
        ElementGridCell elementGridCell = (ElementGridCell)occupiedGridCell.getOccupier();
        this.addBlankCell(elementGridCell, colIndex, rowIndex);
    }

    @Override
    public void exportText(JRPrintText text, JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        this.tableBuilder.exportText(text, gridCell, this.isShrinkToFit(text), this.isWrapText(text), this.isIgnoreTextFormatting(text));
        XlsReportConfiguration configuration = (XlsReportConfiguration)this.getCurrentItemConfiguration();
        if (!configuration.isIgnoreAnchors().booleanValue() && text.getAnchorName() != null) {
            String cellAddress = "$&apos;" + this.tableBuilder.getTableName() + "&apos;." + this.getCellAddress(rowIndex, colIndex);
            int lastCol = Math.max(0, colIndex + gridCell.getColSpan() - 1);
            String cellRangeAddress = this.getCellAddress(rowIndex + gridCell.getRowSpan() - 1, lastCol);
            this.namedExpressions.append("<table:named-range table:name=\"" + JRStringUtil.xmlEncode(text.getAnchorName()) + "\" table:base-cell-address=\"" + cellAddress + "\" table:cell-range-address=\"" + cellAddress + ":" + cellRangeAddress + "\"/>\n");
        }
    }

    @Override
    public void exportImage(JRPrintImage image, JRExporterGridCell gridCell, int colIndex, int rowIndex, int emptyCols, int yCutsRow, JRGridLayout layout) throws JRException {
        int topPadding = Math.max(image.getLineBox().getTopPadding(), Math.round(image.getLineBox().getTopPen().getLineWidth().floatValue()));
        int leftPadding = Math.max(image.getLineBox().getLeftPadding(), Math.round(image.getLineBox().getLeftPen().getLineWidth().floatValue()));
        int bottomPadding = Math.max(image.getLineBox().getBottomPadding(), Math.round(image.getLineBox().getBottomPen().getLineWidth().floatValue()));
        int rightPadding = Math.max(image.getLineBox().getRightPadding(), Math.round(image.getLineBox().getRightPen().getLineWidth().floatValue()));
        int availableImageWidth = image.getWidth() - leftPadding - rightPadding;
        availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
        int availableImageHeight = image.getHeight() - topPadding - bottomPadding;
        availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        this.tableBuilder.buildCellHeader(this.styleCache.getCellStyle(gridCell), gridCell.getColSpan(), gridCell.getRowSpan());
        Renderable renderer = image.getRenderer();
        if (renderer != null && availableImageWidth > 0 && availableImageHeight > 0) {
            InternalImageProcessorResult imageProcessorResult;
            block6: {
                InternalImageProcessor imageProcessor = new InternalImageProcessor(image, gridCell, availableImageWidth, availableImageHeight, this.documentBuilder, this.jasperReportsContext);
                imageProcessorResult = null;
                try {
                    imageProcessorResult = imageProcessor.process(renderer);
                }
                catch (Exception e) {
                    Renderable onErrorRenderer = this.getRendererUtil().handleImageError(e, image.getOnErrorTypeValue());
                    if (onErrorRenderer == null) break block6;
                    imageProcessorResult = imageProcessor.process(onErrorRenderer);
                }
            }
            if (imageProcessorResult != null) {
                XlsReportConfiguration configuration = (XlsReportConfiguration)this.getCurrentItemConfiguration();
                boolean isOnePagePerSheet = configuration.isOnePagePerSheet();
                this.documentBuilder.insertPageAnchor(this.tableBuilder);
                if (!configuration.isIgnoreAnchors().booleanValue() && image.getAnchorName() != null) {
                    this.tableBuilder.exportAnchor(JRStringUtil.xmlEncode(image.getAnchorName()));
                    String cellAddress = "$&apos;" + this.tableBuilder.getTableName() + "&apos;." + this.getCellAddress(rowIndex, colIndex);
                    int lastCol = Math.max(0, colIndex + gridCell.getColSpan() - 1);
                    String cellRangeAddress = this.getCellAddress(rowIndex + gridCell.getRowSpan() - 1, lastCol);
                    this.namedExpressions.append("<table:named-range table:name=\"" + image.getAnchorName() + "\" table:base-cell-address=\"" + cellAddress + "\" table:cell-range-address=\"" + cellAddress + ":" + cellRangeAddress + "\"/>\n");
                }
                boolean startedHyperlink = this.tableBuilder.startHyperlink(image, false, isOnePagePerSheet);
                String cellAddress = this.getCellAddress(rowIndex + gridCell.getRowSpan(), colIndex + gridCell.getColSpan());
                cellAddress = cellAddress == null ? "" : "table:end-cell-address=\"" + cellAddress + "\" ";
                this.tempBodyWriter.write("<draw:frame text:anchor-type=\"paragraph\" draw:style-name=\"" + this.styleCache.getGraphicStyle(image, imageProcessorResult.cropTop, imageProcessorResult.cropLeft, imageProcessorResult.cropBottom, imageProcessorResult.cropRight) + "\" " + "svg:x=\"" + LengthUtil.inch((double)leftPadding + (double)imageProcessorResult.xoffset / 1.33) + "in\" " + "svg:y=\"" + LengthUtil.inch(topPadding + imageProcessorResult.yoffset) + "in\" " + "svg:width=\"" + LengthUtil.inch(imageProcessorResult.width) + "in\" " + "svg:height=\"" + LengthUtil.inch(imageProcessorResult.height) + "in\">");
                this.tempBodyWriter.write("<draw:image ");
                this.tempBodyWriter.write(" xlink:href=\"" + JRStringUtil.xmlEncode(imageProcessorResult.imagePath) + "\"");
                this.tempBodyWriter.write(" xlink:type=\"simple\"");
                this.tempBodyWriter.write(" xlink:show=\"embed\"");
                this.tempBodyWriter.write(" xlink:actuate=\"onLoad\"");
                this.tempBodyWriter.write("/>\n");
                this.tempBodyWriter.write("</draw:frame>");
                if (startedHyperlink) {
                    this.tableBuilder.endHyperlink(false);
                }
            }
        }
        this.tableBuilder.buildCellFooter();
    }

    protected String getCellAddress(int row, int col) {
        String address = null;
        if (row > -1 && row < 0x100001 && col > -1 && col < this.maxColumnIndex) {
            address = "$" + JROdsExporter.getColumIndexName(col, this.maxColumnIndex) + "$" + (row + 1);
        }
        return address == null ? DEFAULT_ADDRESS : address;
    }

    @Override
    protected void exportRectangle(JRPrintGraphicElement rectangle, JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        this.tableBuilder.exportRectangle(rectangle, gridCell);
    }

    @Override
    protected void exportLine(JRPrintLine line, JRExporterGridCell gridCell, int colIndex, int rowIndex) throws JRException {
        JRBaseLineBox box = new JRBaseLineBox(null);
        JRBoxPen pen = null;
        float ratio = line.getWidth() / line.getHeight();
        pen = ratio > 1.0f ? (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? box.getTopPen() : box.getBottomPen()) : (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? box.getLeftPen() : box.getRightPen());
        pen.setLineColor(line.getLinePen().getLineColor());
        pen.setLineStyle(line.getLinePen().getLineStyleValue());
        pen.setLineWidth(line.getLinePen().getLineWidth());
        gridCell.setBox(box);
        this.tableBuilder.buildCellHeader(this.styleCache.getCellStyle(gridCell), gridCell.getColSpan(), gridCell.getRowSpan());
        this.tempBodyWriter.write("<text:p>");
        this.tempBodyWriter.write("</text:p>");
        this.tableBuilder.buildCellFooter();
    }

    @Override
    protected void exportFrame(JRPrintFrame frame, JRExporterGridCell cell, int colIndex, int rowIndex) throws JRException {
        this.addBlankCell(cell, colIndex, rowIndex);
    }

    @Override
    protected void exportGenericElement(JRGenericPrintElement element, JRExporterGridCell gridCell, int colIndex, int rowIndex, int emptyCols, int yCutsRow, JRGridLayout layout) throws JRException {
        GenericElementOdsHandler handler = (GenericElementOdsHandler)GenericElementHandlerEnviroment.getInstance(this.getJasperReportsContext()).getElementHandler(element.getGenericType(), ODS_EXPORTER_KEY);
        if (handler != null) {
            ExporterContext exporterContext = new ExporterContext(this.tableBuilder);
            handler.exportElement(exporterContext, element, gridCell, colIndex, rowIndex, emptyCols, yCutsRow, layout);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No ODS generic element handler for " + element.getGenericType()));
        }
    }

    @Override
    protected void setFreezePane(int rowIndex, int colIndex) {
    }

    @Override
    protected void setFreezePane(int rowIndex, int colIndex, boolean isRowEdge, boolean isColumnEdge) {
    }

    @Override
    protected void setSheetName(String sheetName) {
    }

    @Override
    protected void setAutoFilter(String autoFilterRange) {
    }

    @Override
    protected void setRowLevels(XlsRowLevelInfo levelInfo, String level) {
    }

    public JROdsExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JROdsExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
        this.exporterContext = new ExporterContext(null);
    }

    @Override
    protected Class<OdsExporterConfiguration> getConfigurationInterface() {
        return OdsExporterConfiguration.class;
    }

    @Override
    protected Class<OdsReportConfiguration> getItemConfigurationInterface() {
        return OdsReportConfiguration.class;
    }

    @Override
    protected void initExport() {
        super.initExport();
    }

    @Override
    protected void initReport() {
        super.initReport();
        XlsReportConfiguration configuration = (XlsReportConfiguration)this.getCurrentItemConfiguration();
        this.nature = new JROdsExporterNature(this.jasperReportsContext, this.filter, configuration.isIgnoreGraphics(), configuration.isIgnorePageMargins());
    }

    @Override
    public String getExporterKey() {
        return ODS_EXPORTER_KEY;
    }

    @Override
    public String getExporterPropertiesPrefix() {
        return ODS_EXPORTER_PROPERTIES_PREFIX;
    }

    protected void insertPageAnchor(TableBuilder tableBuilder) {
        if (this.startPage) {
            String pageName = JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + (this.sheetIndex - this.sheetsBeforeCurrentReport);
            String cellAddress = "$&apos;" + tableBuilder.getTableName() + "&apos;.$A$1";
            tableBuilder.exportAnchor(pageName);
            this.namedExpressions.append("<table:named-range table:name=\"" + pageName + "\" table:base-cell-address=\"" + cellAddress + "\" table:cell-range-address=\"" + cellAddress + "\"/>\n");
            this.startPage = false;
        }
    }

    @Override
    protected void exportEmptyReport() throws JRException, IOException {
    }

    protected class OdsTableBuilder
    extends TableBuilder {
        protected OdsTableBuilder(DocumentBuilder documentBuilder, JasperPrint jasperPrint, int pageFormatIndex, int pageIndex, WriterHelper bodyWriter, WriterHelper styleWriter, StyleCache styleCache, Map<Integer, String> rowStyles, Map<Integer, String> columnStyles, Color tabColor) {
            super(documentBuilder, jasperPrint, pageFormatIndex, pageIndex, bodyWriter, styleWriter, styleCache, rowStyles, columnStyles, tabColor);
        }

        protected OdsTableBuilder(DocumentBuilder documentBuilder, JasperPrint jasperPrint, int pageFormatIndex, int pageIndex, WriterHelper bodyWriter, WriterHelper styleWriter, StyleCache styleCache, Map<Integer, String> rowStyles, Map<Integer, String> columnStyles, String sheetName, Color tabColor) {
            super(documentBuilder, jasperPrint, pageFormatIndex, pageIndex, bodyWriter, styleWriter, styleCache, rowStyles, columnStyles, tabColor);
            this.tableName = sheetName;
        }

        @Override
        protected String getIgnoreHyperlinkProperty() {
            return "net.sf.jasperreports.export.xls.ignore.hyperlink";
        }

        @Override
        protected void exportTextContents(JRPrintText textElement) {
            String href = null;
            String ignLnkPropName = this.getIgnoreHyperlinkProperty();
            Boolean ignoreHyperlink = HyperlinkUtil.getIgnoreHyperlink(ignLnkPropName, textElement);
            boolean isIgnoreTextFormatting = JROdsExporter.this.isIgnoreTextFormatting(textElement);
            if (ignoreHyperlink == null) {
                ignoreHyperlink = JROdsExporter.this.getPropertiesUtil().getBooleanProperty(JROdsExporter.this.jasperPrint, ignLnkPropName, false);
            }
            if (!ignoreHyperlink.booleanValue()) {
                href = JROdsExporter.this.documentBuilder.getHyperlinkURL(textElement, ((OdsReportConfiguration)JROdsExporter.this.getCurrentItemConfiguration()).isOnePagePerSheet());
            }
            if (href == null) {
                this.exportStyledText(textElement, false, isIgnoreTextFormatting);
            } else {
                JRStyledText styledText = JROdsExporter.this.getStyledText(textElement);
                if (styledText != null && styledText.length() > 0) {
                    String text = styledText.getText();
                    Locale locale = JROdsExporter.this.getTextLocale(textElement);
                    int runLimit = 0;
                    AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
                    while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
                        String runText = text.substring(iterator.getIndex(), runLimit);
                        this.startTextSpan(iterator.getAttributes(), runText, locale, isIgnoreTextFormatting);
                        this.writeHyperlink(textElement, href, true);
                        this.writeText(runText);
                        this.endHyperlink(true);
                        this.endTextSpan();
                        iterator.setIndex(runLimit);
                    }
                }
            }
        }
    }

    protected class OdsDocumentBuilder
    extends DocumentBuilder {
        public OdsDocumentBuilder(OasisZip oasisZip) {
            super(oasisZip);
        }

        @Override
        public JRStyledText getStyledText(JRPrintText text) {
            return JROdsExporter.this.getStyledText(text);
        }

        @Override
        public Locale getTextLocale(JRPrintText text) {
            return JROdsExporter.this.getTextLocale(text);
        }

        @Override
        public String getInvalidCharReplacement() {
            return JROdsExporter.this.invalidCharReplacement;
        }

        @Override
        protected void insertPageAnchor(TableBuilder tableBuilder) {
            JROdsExporter.this.insertPageAnchor(tableBuilder);
        }

        @Override
        protected JRHyperlinkProducer getHyperlinkProducer(JRPrintHyperlink link) {
            return JROdsExporter.this.getHyperlinkProducer(link);
        }

        @Override
        protected JasperReportsContext getJasperReportsContext() {
            return JROdsExporter.this.getJasperReportsContext();
        }

        @Override
        protected int getReportIndex() {
            return JROdsExporter.this.reportIndex;
        }

        @Override
        protected int getPageIndex() {
            return JROdsExporter.this.pageIndex;
        }
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JROdsExporterContext {
        TableBuilder tableBuilder;

        public ExporterContext(TableBuilder tableBuidler) {
            super(JROdsExporter.this);
            this.tableBuilder = null;
            this.tableBuilder = tableBuidler;
        }

        @Override
        public TableBuilder getTableBuilder() {
            return this.tableBuilder;
        }
    }
}

