/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.HtmlFont;
import net.sf.jasperreports.engine.export.HtmlFontFamily;
import net.sf.jasperreports.engine.export.HtmlFontUtil;
import net.sf.jasperreports.engine.export.HtmlResourceHandler;
import net.sf.jasperreports.web.util.FontFamilyHtmlResourceHandler;
import net.sf.jasperreports.web.util.WebResourceHandler;
import net.sf.jasperreports.web.util.WebUtil;

public class FontWebResourceHandler
implements WebResourceHandler {
    public static final String REQUEST_PARAMETER_FONT_NAME = "font";

    @Override
    public boolean handleResource(JasperReportsContext jasperReportsContext, HttpServletRequest request, HttpServletResponse response) {
        HtmlFontFamily htmlFontFamily;
        String fontName = request.getParameter(REQUEST_PARAMETER_FONT_NAME);
        if (fontName != null && (htmlFontFamily = HtmlFontFamily.getInstance(jasperReportsContext, fontName)) != null) {
            response.setContentType("text/css");
            try {
                String basePath = this.getResourceBasePath(jasperReportsContext, request);
                byte[] resourceData = this.processFont(jasperReportsContext, basePath, htmlFontFamily);
                response.getOutputStream().write(resourceData);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
            return true;
        }
        return false;
    }

    protected byte[] processFont(String basePath, HtmlFont htmlFont) {
        return this.processFont((JasperReportsContext)DefaultJasperReportsContext.getInstance(), basePath, htmlFont);
    }

    protected byte[] processFont(JasperReportsContext jasperReportsContext, String basePath, HtmlFont htmlFont) {
        return this.processFont(jasperReportsContext, basePath, htmlFont.getFamily());
    }

    protected byte[] processFont(JasperReportsContext jasperReportsContext, String basePath, HtmlFontFamily htmlFontFamily) {
        FontFamilyHtmlResourceHandler resourceHandler = new FontFamilyHtmlResourceHandler(basePath, htmlFontFamily);
        String fontCss = HtmlFontUtil.getInstance(jasperReportsContext).getHtmlFont((HtmlResourceHandler)resourceHandler, null, htmlFontFamily, true, true);
        try {
            return fontCss.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new JRRuntimeException(e);
        }
    }

    public String getResourceBasePath(JasperReportsContext jasperReportsContext, HttpServletRequest request) {
        return request.getContextPath() + WebUtil.getInstance(jasperReportsContext).getResourcesPath() + "/";
    }
}

