/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Zone;
import org.netxms.ui.eclipse.objectbrowser.Activator;
import org.netxms.ui.eclipse.objectbrowser.dialogs.helpers.ZoneSelectionDialogComparator;
import org.netxms.ui.eclipse.objectbrowser.dialogs.helpers.ZoneSelectionDialogFilter;
import org.netxms.ui.eclipse.objectbrowser.widgets.internal.ObjectTreeContentProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ZoneSelectionDialog
extends Dialog {
    private Zone zone;
    private FilterText filterText;
    private TableViewer zoneList;
    private ZoneSelectionDialogFilter filter;

    public ZoneSelectionDialog(Shell parent) {
        super(parent);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select Zone");
        newShell.setSize(300, 500);
    }

    protected Control createDialogArea(Composite parent) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        NXCSession session = ConsoleSharedData.getSession();
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.horizontalSpacing = 4;
        dialogArea.setLayout((Layout)layout);
        this.filterText = new FilterText(dialogArea, 0, null, false);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.filterText.setLayoutData((Object)gd);
        String filterString = settings.get("SelectZone.Filter");
        if (filterString != null) {
            this.filterText.setText(filterString);
        }
        String[] names = new String[]{"Name"};
        int[] widths = new int[]{200};
        this.zoneList = new SortableTableViewer(dialogArea, names, widths, 0, 128, 68100);
        long[] zoneIds = session.findAllZoneIds();
        this.zoneList.setContentProvider((IContentProvider)new ObjectTreeContentProvider(zoneIds));
        this.zoneList.setComparator((ViewerComparator)new ZoneSelectionDialogComparator());
        this.zoneList.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.filter = new ZoneSelectionDialogFilter();
        if (filterString != null) {
            this.filter.setFilterString(filterString);
        }
        this.zoneList.addFilter((ViewerFilter)this.filter);
        this.zoneList.setInput((Object)session);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this.zoneList.getTable().setLayoutData((Object)gd);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ZoneSelectionDialog.this.filter.setFilterString(ZoneSelectionDialog.this.filterText.getText());
                ZoneSelectionDialog.this.zoneList.refresh();
            }
        });
        this.zoneList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ZoneSelectionDialog.this.okPressed();
            }
        });
        this.filterText.setFocus();
        return dialogArea;
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.zoneList.getSelection();
        if (selection.size() <= 0) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please select zone object");
            return;
        }
        this.zone = (Zone)selection.getFirstElement();
        super.okPressed();
    }

    public long getZoneId() {
        return this.zone.getObjectId();
    }

    public String getZoneName() {
        return this.zone.getObjectName();
    }
}

