/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.views.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Interface;
import org.netxms.client.topology.Port;
import org.netxms.client.topology.VlanInfo;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.topology.widgets.helpers.PortInfo;

public class VlanLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private static final Color HIGHLIGHT = new Color((Device)Display.getDefault(), 255, 216, 0);
    private NXCSession session = ConsoleSharedData.getSession();
    private PortInfo selectedPort = null;

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        VlanInfo vlan = (VlanInfo)element;
        switch (columnIndex) {
            case 0: {
                return Integer.toString(vlan.getVlanId());
            }
            case 1: {
                return vlan.getName();
            }
            case 2: {
                return this.buildPortList(vlan);
            }
        }
        return null;
    }

    private String buildPortList(VlanInfo vlan) {
        int lastPort;
        ArrayList<Port> ports = new ArrayList<Port>(Arrays.asList(vlan.getPorts()));
        if (ports.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator it = ports.iterator();
        while (it.hasNext()) {
            Port p = (Port)it.next();
            Interface iface = (Interface)this.session.findObjectById(p.getObjectId(), Interface.class);
            if (iface == null || (iface.getFlags() & 2) != 0) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(iface.getObjectName());
            it.remove();
        }
        if (ports.size() == 0) {
            return sb.toString();
        }
        int slot = ((Port)ports.get(0)).getSlot();
        int firstPort = lastPort = ((Port)ports.get(0)).getPort();
        if (sb.length() > 0) {
            sb.append(',');
        }
        sb.append(slot);
        sb.append('/');
        sb.append(firstPort);
        int i = 1;
        while (i < ports.size()) {
            if (((Port)ports.get(i)).getSlot() == slot && ((Port)ports.get(i)).getPort() == lastPort + 1) {
                ++lastPort;
            } else {
                if (((Port)ports.get(i - 1)).getPort() != firstPort) {
                    if (lastPort - firstPort > 1) {
                        sb.append('-');
                    } else {
                        sb.append(',');
                    }
                    sb.append(slot);
                    sb.append('/');
                    sb.append(lastPort);
                }
                slot = ((Port)ports.get(i)).getSlot();
                firstPort = lastPort = ((Port)ports.get(i)).getPort();
                sb.append(',');
                sb.append(slot);
                sb.append('/');
                sb.append(lastPort);
            }
            ++i;
        }
        if (((Port)ports.get(i - 1)).getPort() != firstPort) {
            if (lastPort - firstPort > 1) {
                sb.append('-');
            } else {
                sb.append(',');
            }
            sb.append(slot);
            sb.append('/');
            sb.append(lastPort);
        }
        return sb.toString();
    }

    public boolean setSelectedPort(PortInfo selectedPort) {
        if (selectedPort == this.selectedPort) {
            return false;
        }
        this.selectedPort = selectedPort;
        return true;
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        return this.selectedPort != null && ((VlanInfo)element).containsPort(this.selectedPort.getSlot(), this.selectedPort.getPort()) ? HIGHLIGHT : null;
    }
}

