/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import org.netxms.client.datacollection.DciValue;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="dci", strict=false)
public class ChartDciConfig {
    public static final String UNSET_COLOR = "UNSET";
    public static final int ITEM = 1;
    public static final int TABLE = 2;
    public static final int DEFAULT = 0;
    public static final int LINE = 1;
    public static final int AREA = 2;
    @Attribute
    public long nodeId;
    @Attribute
    public long dciId;
    @Element(required=false)
    public String dciName;
    @Element(required=false)
    public String dciDescription;
    @Element(required=false)
    public int type;
    @Element(required=false)
    public String color;
    @Element(required=false)
    public String name;
    @Element(required=false)
    public int lineWidth;
    @Element(required=false)
    public int displayType;
    @Element(required=false)
    public boolean area;
    @Element(required=false)
    public boolean showThresholds;
    @Element(required=false)
    public boolean invertValues;
    @Element(required=false)
    public boolean multiMatch;
    @Element(required=false)
    public String instance;
    @Element(required=false)
    public String column;
    @Element(required=false)
    public String displayFormat;

    public ChartDciConfig() {
        this.nodeId = 0L;
        this.dciId = 0L;
        this.dciName = "";
        this.dciDescription = "";
        this.type = 1;
        this.color = UNSET_COLOR;
        this.name = "";
        this.lineWidth = 2;
        this.displayType = 0;
        this.area = false;
        this.showThresholds = false;
        this.invertValues = false;
        this.multiMatch = false;
        this.instance = "";
        this.column = "";
        this.displayFormat = "%s";
    }

    public ChartDciConfig(ChartDciConfig src) {
        this.nodeId = src.nodeId;
        this.dciId = src.dciId;
        this.dciName = src.dciName;
        this.dciDescription = src.dciDescription;
        this.type = src.type;
        this.color = src.color;
        this.name = src.name;
        this.lineWidth = src.lineWidth;
        this.displayType = src.displayType;
        this.area = src.area;
        this.showThresholds = src.showThresholds;
        this.invertValues = src.invertValues;
        this.multiMatch = src.multiMatch;
        this.instance = src.instance;
        this.column = src.column;
        this.displayFormat = src.displayFormat;
    }

    public ChartDciConfig(DciValue dci) {
        this.nodeId = dci.getNodeId();
        this.dciId = dci.getId();
        this.dciName = dci.getName();
        this.dciDescription = dci.getDescription();
        this.type = dci.getDcObjectType();
        this.name = dci.getDescription();
        this.color = UNSET_COLOR;
        this.lineWidth = 2;
        this.area = false;
        this.showThresholds = false;
        this.invertValues = false;
        this.multiMatch = false;
        this.instance = "";
        this.column = "";
        this.displayFormat = "%s";
    }

    public int getColorAsInt() {
        if (this.color.equals(UNSET_COLOR)) {
            return -1;
        }
        if (this.color.startsWith("0x")) {
            return Integer.parseInt(this.color.substring(2), 16);
        }
        return Integer.parseInt(this.color, 10);
    }

    public void setColor(int value) {
        this.color = "0x" + Integer.toHexString(value);
    }

    public String getName() {
        return this.name != null && !this.name.isEmpty() ? this.name : "[" + Long.toString(this.dciId) + "]";
    }

    public String getDisplayFormat() {
        return this.displayFormat != null && !this.displayFormat.isEmpty() ? this.displayFormat : "%s";
    }

    public int getDisplayType() {
        return this.displayType == 0 && this.area ? 2 : this.displayType;
    }

    public String getDciName() {
        return this.dciName == null ? "" : this.dciName;
    }

    public void setDciName(String dciName) {
        this.dciName = dciName;
    }

    public String getDciDescription() {
        return this.dciDescription == null ? "" : this.dciDescription;
    }

    public void setDciDescription(String dciDescription) {
        this.dciDescription = dciDescription;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof ChartDciConfig) {
            return this.dciId == ((ChartDciConfig)arg0).dciId;
        }
        return super.equals(arg0);
    }

    public int hashCode() {
        return Long.valueOf(this.dciId).hashCode();
    }
}

