/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets.internal;

import java.text.NumberFormat;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.TableCell;
import org.netxms.client.TableRow;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;

public class TableLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private static final Color FOREGROUND_COLOR_DARK = new Color((Device)Display.getCurrent(), 0, 0, 0);
    private static final Color FOREGROUND_COLOR_LIGHT = new Color((Device)Display.getCurrent(), 255, 255, 255);
    private static final Color[] FOREGROUND_COLORS;
    private boolean useMultipliers = false;
    private int[] columnDataTypes = null;

    static {
        Color[] colorArray = new Color[5];
        colorArray[1] = FOREGROUND_COLOR_DARK;
        colorArray[2] = FOREGROUND_COLOR_DARK;
        colorArray[3] = FOREGROUND_COLOR_LIGHT;
        colorArray[4] = FOREGROUND_COLOR_LIGHT;
        FOREGROUND_COLORS = colorArray;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        TableRow row = (TableRow)element;
        if (columnIndex >= row.size()) {
            return null;
        }
        return this.getValue(row, columnIndex);
    }

    private String getValue(TableRow row, int columnIndex) {
        String value;
        String suffix = null;
        try {
            switch (this.columnDataTypes[columnIndex]) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    if (this.useMultipliers) {
                        long i = Long.parseLong(row.get(columnIndex).getValue());
                        if (i >= 10000000000000L || i <= -10000000000000L) {
                            i /= 1000000000000L;
                            suffix = "T";
                        }
                        if (i >= 10000000000L || i <= -10000000000L) {
                            i /= 1000000000L;
                            suffix = "G";
                        }
                        if (i >= 10000000L || i <= -10000000L) {
                            i /= 1000000L;
                            suffix = "M";
                        }
                        if (i >= 10000L || i <= -10000L) {
                            i /= 1000L;
                            suffix = "K";
                        }
                        value = Long.toString(i);
                        break;
                    }
                    value = row.get(columnIndex).getValue();
                    suffix = " ";
                    break;
                }
                case 5: {
                    if (this.useMultipliers) {
                        double d = Double.parseDouble(row.get(columnIndex).getValue());
                        NumberFormat nf = NumberFormat.getNumberInstance();
                        nf.setMaximumFractionDigits(2);
                        if (d >= 1.0E13 || d <= -1.0E13) {
                            d /= 1.0E12;
                            suffix = "T";
                        }
                        if (d >= 1.0E10 || d <= -1.0E10) {
                            d /= 1.0E9;
                            suffix = "G";
                        }
                        if (d >= 1.0E7 || d <= -1.0E7) {
                            d /= 1000000.0;
                            suffix = "M";
                        }
                        if (d >= 10000.0 || d <= -10000.0) {
                            d /= 1000.0;
                            suffix = "K";
                        }
                        value = Double.toString(d);
                        break;
                    }
                    value = row.get(columnIndex).getValue();
                    break;
                }
                default: {
                    value = row.get(columnIndex).getValue();
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            value = row.get(columnIndex).getValue();
        }
        if (suffix != null) {
            return String.valueOf(value) + " " + suffix;
        }
        return value;
    }

    public Color getForeground(Object element, int columnIndex) {
        TableRow row = (TableRow)element;
        if (columnIndex >= row.size()) {
            return null;
        }
        TableCell cell = row.get(columnIndex);
        return cell.getStatus() >= 0 && cell.getStatus() < FOREGROUND_COLORS.length ? FOREGROUND_COLORS[cell.getStatus()] : null;
    }

    public Color getBackground(Object element, int columnIndex) {
        TableRow row = (TableRow)element;
        if (columnIndex >= row.size()) {
            return null;
        }
        TableCell cell = row.get(columnIndex);
        return cell.getStatus() > 0 ? StatusDisplayInfo.getStatusColor((int)cell.getStatus()) : null;
    }

    public void setUseMultipliers(boolean useMultipliers) {
        this.useMultipliers = useMultipliers;
    }

    public void setColumnDataTypes(int[] columnDataTypes) {
        this.columnDataTypes = columnDataTypes;
    }
}

