/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.widgets;

import org.eclipse.swt.widgets.Composite;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ZoneSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.AbstractSelector;

public class ZoneSelector
extends AbstractSelector {
    private long objectId = 0L;
    private String emptySelectionName = "<none>";

    public ZoneSelector(Composite parent, int style, boolean showClearButton) {
        super(parent, style, showClearButton ? 8 : 0);
        this.setText(this.emptySelectionName);
    }

    protected void selectionButtonHandler() {
        ZoneSelectionDialog dlg = new ZoneSelectionDialog(this.getShell());
        if (dlg.open() == 0) {
            this.objectId = dlg.getZoneId();
            this.setText(dlg.getZoneName());
            this.fireModifyListeners();
        }
    }

    protected void clearButtonHandler() {
        this.objectId = 0L;
        this.setText(this.emptySelectionName);
        this.fireModifyListeners();
    }

    public long getObjectId() {
        return this.objectId;
    }

    public String getObjectName() {
        return this.getText();
    }

    public void setObjectId(long objectId) {
        this.objectId = objectId;
        if (objectId == 0L) {
            this.setText(this.emptySelectionName);
        } else {
            AbstractObject object = ConsoleSharedData.getSession().findObjectById(objectId);
            this.setText(object != null ? object.getObjectName() : "<" + Long.toString(objectId) + ">");
        }
    }
}

