/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nebula.jface.galleryviewer;

import java.util.LinkedList;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.netxms.nebula.widgets.gallery.GalleryItem;

public class GalleryViewerRow
extends ViewerRow {
    protected GalleryItem item;

    public GalleryViewerRow(GalleryItem item) {
        this.item = item;
    }

    public void setItem(GalleryItem item) {
        this.item = item;
    }

    public Object clone() {
        return new GalleryViewerRow(this.item);
    }

    public Color getBackground(int columnIndex) {
        return this.item.getBackground();
    }

    public Rectangle getBounds() {
        return this.item.getBounds();
    }

    public Rectangle getBounds(int columnIndex) {
        return this.item.getBounds();
    }

    public int getColumnCount() {
        return 0;
    }

    public Control getControl() {
        return this.item.getParent();
    }

    public Object getElement() {
        return this.item.getData();
    }

    public Font getFont(int columnIndex) {
        return this.item.getFont();
    }

    public Color getForeground(int columnIndex) {
        return this.item.getForeground();
    }

    public Image getImage(int columnIndex) {
        return this.item.getImage();
    }

    public Widget getItem() {
        return this.item;
    }

    public ViewerRow getNeighbor(int direction, boolean sameLevel) {
        if (direction == 1) {
            return this.getRowAbove();
        }
        if (direction == 2) {
            return this.getRowBelow();
        }
        throw new IllegalArgumentException("Illegal value of direction argument.");
    }

    protected ViewerRow getRowAbove() {
        if (this.item.getParentItem() == null) {
            int index = this.item.getParent().indexOf(this.item) - 1;
            if (index >= 0) {
                return new GalleryViewerRow(this.item.getParent().getItem(index));
            }
        } else {
            GalleryItem parentItem = this.item.getParentItem();
            int index = parentItem.indexOf(this.item) - 1;
            if (index >= 0) {
                return new GalleryViewerRow(parentItem.getItem(index));
            }
        }
        return null;
    }

    protected ViewerRow getRowBelow() {
        if (this.item.getParentItem() == null) {
            GalleryItem tmp;
            int index = this.item.getParent().indexOf(this.item) + 1;
            if (index < this.item.getParent().getItemCount() && (tmp = this.item.getParent().getItem(index)) != null) {
                return new GalleryViewerRow(tmp);
            }
        } else {
            GalleryItem tmp;
            GalleryItem parentItem = this.item.getParentItem();
            int index = parentItem.indexOf(this.item) + 1;
            if (index < parentItem.getItemCount() && (tmp = parentItem.getItem(index)) != null) {
                return new GalleryViewerRow(tmp);
            }
        }
        return null;
    }

    public String getText(int columnIndex) {
        return this.item.getText();
    }

    public TreePath getTreePath() {
        LinkedList<Object> path = new LinkedList<Object>();
        path.add(this.item.getData());
        GalleryItem curItem = this.item;
        while (curItem.getParentItem() != null) {
            path.addFirst(curItem.getParentItem().getData());
            curItem = curItem.getParentItem();
        }
        return new TreePath(path.toArray());
    }

    public void setBackground(int columnIndex, Color color) {
        this.item.setBackground(color);
    }

    public void setFont(int columnIndex, Font font) {
        this.item.setFont(font);
    }

    public void setForeground(int columnIndex, Color color) {
        this.item.setForeground(color);
    }

    public void setImage(int columnIndex, Image image) {
        Image oldImage = this.item.getImage();
        if (image != oldImage) {
            this.item.setImage(image);
        }
    }

    public void setText(int columnIndex, String text) {
        this.item.setText(text == null ? "" : text);
    }
}

